/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.GatherAndMergeWindows;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.Window;
import io.prestosql.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestSwapAdjacentWindowsBySpecifications
extends BaseRuleTest {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private WindowNode.Frame frame = new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.empty());
    private ResolvedFunction resolvedFunction = this.metadata.resolveFunction(QualifiedName.of((String)"avg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));

    public TestSwapAdjacentWindowsBySpecifications() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutWindowFunctions() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnPlanWithSingleWindowNode() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("a")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)new WindowNode.Function(this.resolvedFunction, (List)ImmutableList.of(), this.frame, false)), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void subsetComesFirst() {
        String columnAAlias = "ALIAS_A";
        String columnBAlias = "ALIAS_B";
        ExpectedValueProvider<WindowNode.Specification> specificationA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)columnAAlias), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());
        ExpectedValueProvider<WindowNode.Specification> specificationAB = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)columnAAlias, (Object)columnBAlias), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());
        Optional<Window> windowAB = Optional.of(new Window((List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new SymbolReference("b")), Optional.empty(), Optional.empty()));
        Optional<Window> windowA = Optional.of(new Window((List)ImmutableList.of((Object)new SymbolReference("a")), Optional.empty(), Optional.empty()));
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("a")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1", (Type)DoubleType.DOUBLE), (Object)new WindowNode.Function(this.resolvedFunction, (List)ImmutableList.of((Object)new SymbolReference("a")), this.frame, false)), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2", (Type)DoubleType.DOUBLE), (Object)new WindowNode.Function(this.resolvedFunction, (List)ImmutableList.of((Object)new SymbolReference("b")), this.frame, false)), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).matches(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationAB).addFunction(PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnBAlias))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)columnAAlias, (Object)0, (Object)columnBAlias, (Object)1)))));
    }

    @Test
    public void dependentWindowsAreNotReordered() {
        Optional<Window> windowA = Optional.of(new Window((List)ImmutableList.of((Object)new SymbolReference("a")), Optional.empty(), Optional.empty()));
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("a")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)new WindowNode.Function(this.resolvedFunction, (List)ImmutableList.of((Object)new SymbolReference("avg_2")), this.frame, false)), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)new WindowNode.Function(this.resolvedFunction, (List)ImmutableList.of((Object)new SymbolReference("a")), this.frame, false)), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).doesNotFire();
    }
}

