/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import io.prestosql.Session;
import io.prestosql.cost.CachingCostProvider;
import io.prestosql.cost.CachingStatsProvider;
import io.prestosql.cost.CostCalculator;
import io.prestosql.cost.CostProvider;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.cost.StatsProvider;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Match;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.assertions.PlanAssert;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.Memo;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.planprinter.PlanPrinter;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.testng.Assert;

public class RuleAssert {
    private final Metadata metadata;
    private TestingStatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private Session session;
    private final Rule<?> rule;
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private TypeProvider types;
    private PlanNode plan;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;

    public RuleAssert(Metadata metadata, StatsCalculator statsCalculator, CostCalculator costCalculator, Session session, Rule<?> rule, TransactionManager transactionManager, AccessControl accessControl) {
        this.metadata = metadata;
        this.statsCalculator = new TestingStatsCalculator(statsCalculator);
        this.costCalculator = costCalculator;
        this.session = session;
        this.rule = rule;
        this.transactionManager = transactionManager;
        this.accessControl = accessControl;
    }

    public RuleAssert setSystemProperty(String key, String value) {
        return this.withSession(Session.builder((Session)this.session).setSystemProperty(key, value).build());
    }

    public RuleAssert withSession(Session session) {
        this.session = session;
        return this;
    }

    public RuleAssert overrideStats(String nodeId, PlanNodeStatsEstimate nodeStats) {
        this.statsCalculator.setNodeStats(new PlanNodeId(nodeId), nodeStats);
        return this;
    }

    public RuleAssert on(Function<PlanBuilder, PlanNode> planProvider) {
        Preconditions.checkArgument((this.plan == null ? 1 : 0) != 0, (Object)"plan has already been set");
        PlanBuilder builder = new PlanBuilder(this.idAllocator, this.metadata);
        this.plan = planProvider.apply(builder);
        this.types = builder.getTypes();
        return this;
    }

    public void doesNotFire() {
        RuleApplication ruleApplication = this.applyRule();
        if (ruleApplication.wasRuleApplied()) {
            Assert.fail((String)String.format("Expected %s to not fire for:\n%s", this.rule.getClass().getName(), this.inTransaction(session -> PlanPrinter.textLogicalPlan((PlanNode)this.plan, (TypeProvider)ruleApplication.types, (Metadata)this.metadata, (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)2, (boolean)false))));
        }
    }

    public void matches(PlanMatchPattern pattern) {
        PlanNode actual;
        RuleApplication ruleApplication = this.applyRule();
        TypeProvider types = ruleApplication.types;
        if (!ruleApplication.wasRuleApplied()) {
            Assert.fail((String)String.format("%s did not fire for:\n%s", this.rule.getClass().getName(), this.formatPlan(this.plan, types)));
        }
        if ((actual = ruleApplication.getTransformedPlan()) == this.plan) {
            Assert.fail((String)String.format("%s: rule fired but return the original plan:\n%s", this.rule.getClass().getName(), this.formatPlan(this.plan, types)));
        }
        if (!ImmutableSet.copyOf((Collection)this.plan.getOutputSymbols()).equals((Object)ImmutableSet.copyOf((Collection)actual.getOutputSymbols()))) {
            Assert.fail((String)String.format("%s: output schema of transformed and original plans are not equivalent\n\texpected: %s\n\tactual:   %s", this.rule.getClass().getName(), this.plan.getOutputSymbols(), actual.getOutputSymbols()));
        }
        this.inTransaction(session -> {
            PlanAssert.assertPlan(session, this.metadata, ruleApplication.statsProvider, new Plan(actual, types, StatsAndCosts.empty()), ruleApplication.lookup, pattern);
            return null;
        });
    }

    private RuleApplication applyRule() {
        SymbolAllocator symbolAllocator = new SymbolAllocator(this.types.allTypes());
        Memo memo = new Memo(this.idAllocator, this.plan);
        Lookup lookup = Lookup.from(planNode -> Stream.of(memo.resolve(planNode)));
        PlanNode memoRoot = memo.getNode(memo.getRootGroup());
        return this.inTransaction(session -> RuleAssert.applyRule(this.rule, memoRoot, this.ruleContext(this.statsCalculator, this.costCalculator, symbolAllocator, memo, lookup, (Session)session)));
    }

    private static <T> RuleApplication applyRule(Rule<T> rule, PlanNode planNode, Rule.Context context) {
        Capture planNodeCapture = Capture.newCapture();
        Pattern pattern = rule.getPattern().capturedAs(planNodeCapture);
        Optional match = (Optional)pattern.match((Object)planNode, (Object)context.getLookup()).collect(MoreCollectors.toOptional());
        Rule.Result result = !rule.isEnabled(context.getSession()) || match.isEmpty() ? Rule.Result.empty() : rule.apply(((Match)match.get()).capture(planNodeCapture), ((Match)match.get()).captures(), context);
        return new RuleApplication(context.getLookup(), context.getStatsProvider(), context.getSymbolAllocator().getTypes(), result);
    }

    private String formatPlan(PlanNode plan, TypeProvider types) {
        CachingStatsProvider statsProvider = new CachingStatsProvider((StatsCalculator)this.statsCalculator, this.session, types);
        CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, (StatsProvider)statsProvider, this.session, types);
        return this.inTransaction(arg_0 -> this.lambda$formatPlan$4(plan, types, (StatsProvider)statsProvider, (CostProvider)costProvider, arg_0));
    }

    private <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().execute(this.session, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }

    private Rule.Context ruleContext(StatsCalculator statsCalculator, CostCalculator costCalculator, final SymbolAllocator symbolAllocator, Memo memo, final Lookup lookup, final Session session) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, Optional.of(memo), lookup, session, symbolAllocator.getTypes());
        CachingCostProvider costProvider = new CachingCostProvider(costCalculator, (StatsProvider)statsProvider, Optional.of(memo), session, symbolAllocator.getTypes());
        return new Rule.Context((StatsProvider)statsProvider, (CostProvider)costProvider){
            final /* synthetic */ StatsProvider val$statsProvider;
            final /* synthetic */ CostProvider val$costProvider;
            {
                this.val$statsProvider = statsProvider;
                this.val$costProvider = costProvider;
            }

            public Lookup getLookup() {
                return lookup;
            }

            public PlanNodeIdAllocator getIdAllocator() {
                return RuleAssert.this.idAllocator;
            }

            public SymbolAllocator getSymbolAllocator() {
                return symbolAllocator;
            }

            public Session getSession() {
                return session;
            }

            public StatsProvider getStatsProvider() {
                return this.val$statsProvider;
            }

            public CostProvider getCostProvider() {
                return this.val$costProvider;
            }

            public void checkTimeoutNotExhausted() {
            }

            public WarningCollector getWarningCollector() {
                return WarningCollector.NOOP;
            }
        };
    }

    private /* synthetic */ String lambda$formatPlan$4(PlanNode plan, TypeProvider types, StatsProvider statsProvider, CostProvider costProvider, Session session) {
        return PlanPrinter.textLogicalPlan((PlanNode)plan, (TypeProvider)types, (Metadata)this.metadata, (StatsAndCosts)StatsAndCosts.create((PlanNode)plan, (StatsProvider)statsProvider, (CostProvider)costProvider), (Session)session, (int)2, (boolean)false);
    }

    private static class TestingStatsCalculator
    implements StatsCalculator {
        private final StatsCalculator delegate;
        private final Map<PlanNodeId, PlanNodeStatsEstimate> stats = new HashMap<PlanNodeId, PlanNodeStatsEstimate>();

        TestingStatsCalculator(StatsCalculator delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
            if (this.stats.containsKey(node.getId())) {
                return this.stats.get(node.getId());
            }
            return this.delegate.calculateStats(node, sourceStats, lookup, session, types);
        }

        public void setNodeStats(PlanNodeId nodeId, PlanNodeStatsEstimate nodeStats) {
            this.stats.put(nodeId, nodeStats);
        }
    }

    private static class RuleApplication {
        private final Lookup lookup;
        private final StatsProvider statsProvider;
        private final TypeProvider types;
        private final Rule.Result result;

        public RuleApplication(Lookup lookup, StatsProvider statsProvider, TypeProvider types, Rule.Result result) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
            this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.result = Objects.requireNonNull(result, "result is null");
        }

        private boolean wasRuleApplied() {
            return !this.result.isEmpty();
        }

        public PlanNode getTransformedPlan() {
            return (PlanNode)this.result.getTransformedPlan().orElseThrow(() -> new IllegalStateException("Rule did not produce transformed plan"));
        }
    }
}

