/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.RowNumberSymbolMatcher;
import io.prestosql.sql.planner.assertions.RvalueMatcher;
import io.prestosql.sql.planner.assertions.TopNRowNumberSymbolMatcher;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import io.prestosql.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestWindowFilterPushDown
extends BasePlanTest {
    @Test
    public void testLimitAboveWindow() {
        String sql = "SELECT row_number() OVER (PARTITION BY suppkey ORDER BY orderkey) partition_row_number FROM lineitem LIMIT 10";
        this.assertPlanWithSession(sql, this.optimizeTopNRowNumber(true), true, PlanMatchPattern.anyTree(PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.node(TopNRowNumberNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))));
        this.assertPlanWithSession(sql, this.optimizeTopNRowNumber(false), true, PlanMatchPattern.anyTree(PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))));
    }

    @Test
    public void testFilterAboveWindow() {
        String sql = "SELECT * FROM (SELECT row_number() OVER (PARTITION BY suppkey ORDER BY orderkey) partition_row_number FROM lineitem) WHERE partition_row_number < 10";
        this.assertPlanWithSession(sql, this.optimizeTopNRowNumber(true), true, PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.node(TopNRowNumberNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem"))))));
        this.assertPlanWithSession(sql, this.optimizeTopNRowNumber(false), true, PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))));
        this.assertPlanWithSession("SELECT * FROM (SELECT name, row_number() OVER(ORDER BY name) FROM nation) t(name, row_number) WHERE row_number < 0", this.optimizeTopNRowNumber(true), true, PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"row_number"), PlanMatchPattern.values("name", "row_number")));
        this.assertPlanWithSession("SELECT * FROM (SELECT name, row_number() OVER(ORDER BY name) FROM nation) t(name, row_number) WHERE row_number < 2", this.optimizeTopNRowNumber(true), true, PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"row_number"), PlanMatchPattern.topNRowNumber(pattern -> pattern.maxRowCountPerPartition(1).specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"name"), (Map<String, SortOrder>)ImmutableMap.of((Object)"name", (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))).withAlias("row_number", (RvalueMatcher)new TopNRowNumberSymbolMatcher())));
        this.assertPlanWithSession("SELECT * FROM (SELECT name, row_number() OVER(ORDER BY name) FROM nation) t(name, row_number) WHERE row_number <= 1", this.optimizeTopNRowNumber(true), true, PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"row_number"), PlanMatchPattern.topNRowNumber(pattern -> pattern.maxRowCountPerPartition(1).specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"name"), (Map<String, SortOrder>)ImmutableMap.of((Object)"name", (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))).withAlias("row_number", (RvalueMatcher)new TopNRowNumberSymbolMatcher())));
        this.assertPlanWithSession("SELECT * FROM (SELECT name, row_number() OVER(ORDER BY name) FROM nation) t(name, row_number) WHERE row_number <= 1 AND row_number > -10", this.optimizeTopNRowNumber(true), true, PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"row_number"), PlanMatchPattern.topNRowNumber(pattern -> pattern.maxRowCountPerPartition(1).specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"name"), (Map<String, SortOrder>)ImmutableMap.of((Object)"name", (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))).withAlias("row_number", (RvalueMatcher)new TopNRowNumberSymbolMatcher())));
        this.assertPlanWithSession("SELECT * FROM (SELECT name, row_number() OVER(ORDER BY name) FROM nation) t(name, row_number) WHERE row_number > 1 AND row_number < 3", this.optimizeTopNRowNumber(true), true, PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"row_number"), PlanMatchPattern.filter("(row_number > BIGINT '1') AND (row_number < BIGINT '3')", PlanMatchPattern.topNRowNumber(pattern -> pattern.maxRowCountPerPartition(2).specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"name"), (Map<String, SortOrder>)ImmutableMap.of((Object)"name", (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))).withAlias("row_number", (RvalueMatcher)new TopNRowNumberSymbolMatcher()))));
    }

    @Test
    public void testFilterAboveRowNumber() {
        this.assertPlan("SELECT * FROM (SELECT name, row_number() OVER() FROM nation) t(name, row_number) WHERE row_number < 0", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"row_number"), PlanMatchPattern.values("name", "row_number")));
        this.assertPlan("SELECT * FROM (SELECT name, row_number() OVER() FROM nation) t(name, row_number) WHERE row_number < 2", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"row_number"), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(1)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher())));
        this.assertPlan("SELECT * FROM (SELECT name, row_number() OVER() FROM nation) t(name, row_number) WHERE row_number <= 1", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"row_number"), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(1)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher())));
        this.assertPlan("SELECT * FROM (SELECT name, row_number() OVER() FROM nation) t(name, row_number) WHERE row_number <= 1 AND row_number > -10", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"row_number"), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(1)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher())));
        this.assertPlan("SELECT * FROM (SELECT name, row_number() OVER() FROM nation) t(name, row_number) WHERE row_number > 1 AND row_number < 3", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"row_number"), PlanMatchPattern.filter("(row_number > BIGINT '1') AND (row_number < BIGINT '3')", PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    private Session optimizeTopNRowNumber(boolean enabled) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_top_n_row_number", Boolean.toString(enabled)).build();
    }
}

