/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.type.SqlTime;
import io.prestosql.spi.type.SqlTimeWithTimeZone;
import io.prestosql.spi.type.SqlTimestamp;
import io.prestosql.spi.type.SqlTimestampWithTimeZone;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.assertions.PlanAssert;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.MaterializedRow;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;

public class QueryAssertions
implements Closeable {
    private final QueryRunner runner;

    public QueryAssertions() {
        this(TestingSession.testSessionBuilder().setCatalog("local").setSchema("default").build());
    }

    public QueryAssertions(Session session) {
        this((QueryRunner)LocalQueryRunner.create((Session)session));
    }

    public QueryAssertions(QueryRunner runner) {
        this.runner = Objects.requireNonNull(runner, "runner is null");
    }

    public Session.SessionBuilder sessionBuilder() {
        return Session.builder((Session)this.runner.getDefaultSession());
    }

    public Session getDefaultSession() {
        return this.runner.getDefaultSession();
    }

    public AssertProvider<QueryAssert> query(@Language(value="SQL") String query) {
        return this.query(query, this.runner.getDefaultSession());
    }

    public AssertProvider<QueryAssert> query(@Language(value="SQL") String query, Session session) {
        return QueryAssert.newQueryAssert(query, this.runner, session);
    }

    public AssertProvider<ExpressionAssert> expression(@Language(value="SQL") String expression) {
        return this.expression(expression, this.runner.getDefaultSession());
    }

    public AssertProvider<ExpressionAssert> expression(@Language(value="SQL") String expression, Session session) {
        return ExpressionAssert.newExpressionAssert(expression, this.runner, session);
    }

    public void assertFails(@Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        try {
            this.runner.execute(this.runner.getDefaultSession(), sql).toTestTypes();
            Assert.fail((String)String.format("Expected query to fail: %s", sql));
        }
        catch (RuntimeException exception) {
            exception.addSuppressed(new Exception("Query: " + sql));
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exception).isInstanceOf(PrestoException.class)).hasMessageMatching(expectedMessageRegExp);
        }
    }

    public void assertQueryAndPlan(@Language(value="SQL") String actual, @Language(value="SQL") String expected, PlanMatchPattern pattern) {
        this.assertQuery(actual, expected);
        Plan plan = this.runner.executeWithPlan(this.runner.getDefaultSession(), actual, WarningCollector.NOOP).getQueryPlan();
        PlanAssert.assertPlan(this.runner.getDefaultSession(), this.runner.getMetadata(), this.runner.getStatsCalculator(), plan, pattern);
    }

    @Deprecated
    public void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.assertQuery(this.runner.getDefaultSession(), actual, expected, false);
    }

    @Deprecated
    public void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.assertQuery(session, actual, expected, false);
    }

    @Deprecated
    public void assertQueryOrdered(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.assertQuery(this.runner.getDefaultSession(), actual, expected, true);
    }

    private void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected, boolean ensureOrdering) {
        MaterializedResult actualResults = null;
        try {
            actualResults = this.execute(session, actual);
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        MaterializedResult expectedResults = null;
        try {
            expectedResults = this.execute(expected);
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        Assert.assertEquals((Collection)actualResults.getTypes(), (Collection)expectedResults.getTypes(), (String)("Types mismatch for query: \n " + actual + "\n:"));
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        if (ensureOrdering) {
            if (!actualRows.equals(expectedRows)) {
                Assert.assertEquals((Collection)actualRows, (Collection)expectedRows, (String)("For query: \n " + actual + "\n:"));
            }
        } else {
            io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)actualRows, (Iterable)expectedRows, (String)("For query: \n " + actual));
        }
    }

    public void assertQueryReturnsEmptyResult(@Language(value="SQL") String actual) {
        MaterializedResult actualResults = null;
        try {
            actualResults = this.execute(actual);
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        List actualRows = actualResults.getMaterializedRows();
        Assert.assertEquals((int)actualRows.size(), (int)0);
    }

    public MaterializedResult execute(@Language(value="SQL") String query) {
        return this.execute(this.runner.getDefaultSession(), query);
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String query) {
        MaterializedResult actualResults = this.runner.execute(session, query).toTestTypes();
        return actualResults;
    }

    @Override
    public void close() {
        this.runner.close();
    }

    public QueryRunner getQueryRunner() {
        return this.runner;
    }

    protected void executeExclusively(Runnable executionBlock) {
        this.runner.getExclusiveLock().lock();
        try {
            executionBlock.run();
        }
        finally {
            this.runner.getExclusiveLock().unlock();
        }
    }

    public static class ExpressionAssert
    extends AbstractAssert<ExpressionAssert, Object> {
        private static final StandardRepresentation TYPE_RENDERER = new StandardRepresentation(){

            public String toStringOf(Object object) {
                if (object instanceof SqlTimestamp) {
                    SqlTimestamp timestamp = (SqlTimestamp)object;
                    return String.format("%s [p = %s, epochMicros = %s, fraction = %s, tz = %s]", timestamp, timestamp.getPrecision(), timestamp.getEpochMicros(), timestamp.getPicosOfMicros(), timestamp.getSessionTimeZoneKey().map(Object::toString).orElse("\u00f8"));
                }
                if (object instanceof SqlTimestampWithTimeZone) {
                    SqlTimestampWithTimeZone timestamp = (SqlTimestampWithTimeZone)object;
                    return String.format("%s [p = %s, epochMillis = %s, fraction = %s, tz = %s]", timestamp, timestamp.getPrecision(), timestamp.getEpochMillis(), timestamp.getPicosOfMilli(), timestamp.getTimeZoneKey());
                }
                if (object instanceof SqlTime) {
                    SqlTime time = (SqlTime)object;
                    return String.format("%s [millis = %s, tz = %s]", time, time.getMillis(), time.getSessionTimeZoneKey().map(Object::toString).orElse("\u00f8"));
                }
                if (object instanceof SqlTimeWithTimeZone) {
                    SqlTimeWithTimeZone time = (SqlTimeWithTimeZone)object;
                    return String.format("%s [millis = %s, tz = %s]", time, time.getMillisUtc(), time.getTimeZoneKey());
                }
                return Objects.toString(object);
            }
        };
        private final QueryRunner runner;
        private final Session session;
        private final Type actualType;

        static AssertProvider<ExpressionAssert> newExpressionAssert(String expression, QueryRunner runner, Session session) {
            MaterializedResult result = runner.execute(session, "VALUES " + expression);
            Type type = (Type)result.getTypes().get(0);
            Object value = result.getOnlyColumnAsSet().iterator().next();
            return () -> (ExpressionAssert)new ExpressionAssert(runner, session, value, type).withRepresentation((Representation)TYPE_RENDERER);
        }

        public ExpressionAssert(QueryRunner runner, Session session, Object actual, Type actualType) {
            super(actual, Object.class);
            this.runner = runner;
            this.session = session;
            this.actualType = actualType;
        }

        public ExpressionAssert isEqualTo(BiFunction<Session, QueryRunner, Object> evaluator) {
            return (ExpressionAssert)this.isEqualTo(evaluator.apply(this.session, this.runner));
        }

        public ExpressionAssert matches(@Language(value="SQL") String expression) {
            MaterializedResult result = this.runner.execute(this.session, "VALUES " + expression);
            Type expectedType = (Type)result.getTypes().get(0);
            Object expectedValue = result.getOnlyColumnAsSet().iterator().next();
            return (ExpressionAssert)this.satisfies(actual -> {
                ((ObjectAssert)Assertions.assertThat((Object)this.actualType).as("Type", new Object[0])).isEqualTo((Object)expectedType);
                ((ObjectAssert)Assertions.assertThat((Object)actual).withRepresentation((Representation)TYPE_RENDERER)).isEqualTo(expectedValue);
            });
        }

        public ExpressionAssert hasType(Type type) {
            this.objects.assertEqual((AssertionInfo)this.info, (Object)this.actualType, (Object)type);
            return this;
        }
    }

    public static class QueryAssert
    extends AbstractAssert<QueryAssert, MaterializedResult> {
        private static final Representation ROWS_REPRESENTATION = new StandardRepresentation(){

            public String toStringOf(Object object) {
                if (object instanceof List) {
                    List list = (List)object;
                    return list.stream().map(this::toStringOf).collect(Collectors.joining(", "));
                }
                if (object instanceof MaterializedRow) {
                    MaterializedRow row = (MaterializedRow)object;
                    return row.getFields().stream().map(Object::toString).collect(Collectors.joining(", ", "(", ")"));
                }
                return super.toStringOf(object);
            }
        };
        private final QueryRunner runner;
        private final Session session;
        private boolean ordered;

        static AssertProvider<QueryAssert> newQueryAssert(String query, QueryRunner runner, Session session) {
            MaterializedResult result = runner.execute(session, query);
            return () -> new QueryAssert(runner, session, result);
        }

        public QueryAssert(QueryRunner runner, Session session, MaterializedResult actual) {
            super((Object)actual, Object.class);
            this.runner = runner;
            this.session = session;
        }

        public QueryAssert matches(BiFunction<Session, QueryRunner, MaterializedResult> evaluator) {
            MaterializedResult expected = evaluator.apply(this.session, this.runner);
            return (QueryAssert)this.isEqualTo(expected);
        }

        public QueryAssert ordered() {
            this.ordered = true;
            return this;
        }

        public QueryAssert matches(@Language(value="SQL") String query) {
            MaterializedResult expected = this.runner.execute(this.session, query);
            return (QueryAssert)this.satisfies(actual -> {
                ((ListAssert)Assertions.assertThat((List)actual.getTypes()).as("Output types", new Object[0])).isEqualTo((Object)expected.getTypes());
                ListAssert assertion = (ListAssert)((ListAssert)Assertions.assertThat((List)actual.getMaterializedRows()).as("Rows", new Object[0])).withRepresentation(ROWS_REPRESENTATION);
                if (this.ordered) {
                    assertion.containsExactlyElementsOf((Iterable)expected.getMaterializedRows());
                } else {
                    assertion.containsExactlyInAnyOrderElementsOf((Iterable)expected.getMaterializedRows());
                }
            });
        }
    }
}

