/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import io.prestosql.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFormat {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testAggregationInFormat() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT format('%.6f', sum(1000000 / 1e6))")))).matches("SELECT cast(1.000000 as varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT format('%.6f', avg(1))")))).matches("SELECT cast(1.000000 as varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT format('%d', count(1))")))).matches("SELECT cast(1 as varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT format('%d', arbitrary(1))")))).matches("SELECT cast(1 as varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT format('%s %s %s %s %s', sum(1), avg(1), count(1), max(1), min(1))")))).matches("SELECT cast('1 1.0 1 1 1' as varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT format('%s', approx_distinct(1.0))")))).matches("SELECT cast(1 as varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT format('%d', cast(sum(totalprice) as bigint)) FROM (VALUES 20,99,15) t(totalprice)")))).matches("SELECT CAST(sum(totalprice) as VARCHAR) FROM (VALUES 20,99,15) t(totalprice)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT format('%s', sum(k)) FROM (VALUES 1, 2, 3) t(k)")))).matches("VALUES CAST('6' as VARCHAR)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT format(arbitrary(s), sum(k)) FROM (VALUES ('%s', 1), ('%s', 2), ('%s', 3)) t(s, k)")))).matches("VALUES CAST('6' as VARCHAR)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT format(s, 1) FROM (VALUES ('%s', 1)) t(s, k) GROUP BY k")).hasMessageMatching("\\Qline 1:8: 'format(s, 1)' must be an aggregate expression or appear in GROUP BY clause\\E");
    }
}

