/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.testng.IClassListener;
import org.testng.ITestClass;
import org.testng.annotations.Test;

public class ReportUnannotatedMethods
implements IClassListener {
    public void onBeforeClass(ITestClass testClass) {
        Method[] publicMethods = testClass.getRealClass().getMethods();
        List unannotatedMethods = (List)Arrays.stream(publicMethods).filter(method -> method.getDeclaringClass() != Object.class).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> !method.isBridge()).filter(method -> !ReportUnannotatedMethods.isTestMethod(method)).collect(ImmutableList.toImmutableList());
        if (!unannotatedMethods.isEmpty()) {
            System.err.println(String.format("FATAL: Test class %s has methods which are public but not explicitly annotated. Are they missing @Test?%s", testClass.getRealClass().getName(), unannotatedMethods.stream().map(Method::toString).collect(Collectors.joining("\n\t\t", "\n\t\t", ""))));
            System.err.println("JVM will be terminated");
            System.exit(1);
        }
    }

    public void onAfterClass(ITestClass testClass) {
    }

    private static boolean isTestMethod(Method method) {
        Method overridden;
        if (ReportUnannotatedMethods.isTestAnnotated(method)) {
            return true;
        }
        Class<?> superclass = method.getDeclaringClass().getSuperclass();
        try {
            overridden = superclass.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
        return ReportUnannotatedMethods.isTestMethod(overridden);
    }

    private static boolean isTestAnnotated(Method method) {
        return Arrays.stream(method.getAnnotations()).map(Annotation::annotationType).anyMatch(annotationClass -> {
            if ("org.openjdk.jmh.annotations.Benchmark".equals(annotationClass.getName())) {
                return true;
            }
            if (Test.class.getPackage().equals(annotationClass.getPackage())) {
                return true;
            }
            return "io.prestosql.tempto".equals(annotationClass.getPackage().getName());
        });
    }
}

