/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockSerdeUtil;
import io.prestosql.operator.aggregation.TypedSet;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.SqlDate;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.DateTimeTestingUtils;
import io.prestosql.type.JsonType;
import io.prestosql.type.Timestamps;
import io.prestosql.type.UnknownType;
import io.prestosql.util.StructuralTestUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestArrayOperators
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
    }

    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice uncheckedToJson(@SqlType(value="varchar(x)") Slice slice) {
        return slice;
    }

    @Test
    public void testStackRepresentation() {
        Block actualBlock = StructuralTestUtil.arrayBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 1L, 2L), StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 3L));
        DynamicSliceOutput actualSliceOutput = new DynamicSliceOutput(100);
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)this.functionAssertions.getMetadata().getBlockEncodingSerde(), (SliceOutput)actualSliceOutput, (Block)actualBlock);
        Block expectedBlock = new ArrayType((Type)BigintType.BIGINT).createBlockBuilder(null, 3).appendStructure(BigintType.BIGINT.createBlockBuilder(null, 2).writeLong(1L).closeEntry().writeLong(2L).closeEntry().build()).appendStructure(BigintType.BIGINT.createBlockBuilder(null, 1).writeLong(3L).closeEntry().build()).build();
        DynamicSliceOutput expectedSliceOutput = new DynamicSliceOutput(100);
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)this.functionAssertions.getMetadata().getBlockEncodingSerde(), (SliceOutput)expectedSliceOutput, (Block)expectedBlock);
        Assert.assertEquals((Object)actualSliceOutput.slice(), (Object)expectedSliceOutput.slice());
    }

    @Test
    public void testTypeConstructor() {
        this.assertFunction("ARRAY[7]", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)7));
        this.assertFunction("ARRAY[12.34E0, 56.78E0]", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)12.34, (Object)56.78));
    }

    @Test
    public void testArrayElements() {
        this.assertFunction("CAST(ARRAY [null] AS ARRAY<INTEGER>)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(new Integer[]{null}));
        this.assertFunction("CAST(ARRAY [1, 2, 3] AS ARRAY<INTEGER>)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("CAST(ARRAY [1, null, 3] AS ARRAY<INTEGER>)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(1, null, 3));
        this.assertFunction("CAST(ARRAY [null] AS ARRAY<BIGINT>)", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(new Long[]{null}));
        this.assertFunction("CAST(ARRAY [1, 2, 3] AS ARRAY<BIGINT>)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        this.assertFunction("CAST(ARRAY [1, null, 3] AS ARRAY<BIGINT>)", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(1L, null, 3L));
        this.assertFunction("CAST(ARRAY [1, 2, 3] AS ARRAY<DOUBLE>)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0));
        this.assertFunction("CAST(ARRAY [1, null, 3] AS ARRAY<DOUBLE>)", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(1.0, null, 3.0));
        this.assertFunction("CAST(ARRAY ['1', '2'] AS ARRAY<VARCHAR>)", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"1", (Object)"2"));
        this.assertFunction("CAST(ARRAY ['1', '2'] AS ARRAY<DOUBLE>)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)2.0));
        this.assertFunction("CAST(ARRAY [true, false] AS ARRAY<BOOLEAN>)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("CAST(ARRAY [true, false] AS ARRAY<VARCHAR>)", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"true", (Object)"false"));
        this.assertFunction("CAST(ARRAY [1, 0] AS ARRAY<BOOLEAN>)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("CAST(ARRAY [ARRAY[1], ARRAY[2, 3]] AS ARRAY<ARRAY<DOUBLE>>)", (Type)new ArrayType((Type)new ArrayType((Type)DoubleType.DOUBLE)), Arrays.asList(Arrays.asList(1.0), Arrays.asList(2.0, 3.0)));
        this.assertFunction("CAST(ARRAY [ARRAY[1.0], ARRAY[2.0, 3.0]] AS ARRAY<ARRAY<DOUBLE>>)", (Type)new ArrayType((Type)new ArrayType((Type)DoubleType.DOUBLE)), Arrays.asList(Arrays.asList(1.0), Arrays.asList(2.0, 3.0)));
        this.assertFunction("CAST(ARRAY [ARRAY[1.0E0], ARRAY[2.0E0, 3.0E0]] AS ARRAY<ARRAY<DECIMAL(2,1)>>)", (Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))), Arrays.asList(Arrays.asList(TestArrayOperators.decimal("1.0")), Arrays.asList(TestArrayOperators.decimal("2.0"), TestArrayOperators.decimal("3.0"))));
        this.assertFunction("CAST(ARRAY [ARRAY[1.0E0], ARRAY[2.0E0, 3.0E0]] AS ARRAY<ARRAY<DECIMAL(20,10)>>)", (Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)20, (int)10))), Arrays.asList(Arrays.asList(TestArrayOperators.decimal("0000000001.0000000000")), Arrays.asList(TestArrayOperators.decimal("0000000002.0000000000"), TestArrayOperators.decimal("0000000003.0000000000"))));
        this.assertInvalidFunction("CAST(ARRAY [1, null, 3] AS ARRAY<TIMESTAMP>)", (ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertInvalidFunction("CAST(ARRAY [1, null, 3] AS ARRAY<ARRAY<TIMESTAMP>>)", (ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertInvalidFunction("CAST(ARRAY ['puppies', 'kittens'] AS ARRAY<BIGINT>)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    @Test
    public void testArraySize() {
        int size = Math.toIntExact(TypedSet.MAX_FUNCTION_MEMORY.toBytes() + 1L);
        this.assertInvalidFunction("array_distinct(ARRAY['" + "x".repeat(size) + "', '" + "y".repeat(size) + "', '" + "z".repeat(size) + "'])", (ErrorCodeSupplier)StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT);
    }

    @Test
    public void testArrayToJson() {
        this.assertFunction("cast(cast (null as ARRAY<BIGINT>) AS JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(ARRAY[] AS JSON)", (Type)JsonType.JSON, "[]");
        this.assertFunction("cast(ARRAY[null, null] AS JSON)", (Type)JsonType.JSON, "[null,null]");
        this.assertFunction("cast(ARRAY[true, false, null] AS JSON)", (Type)JsonType.JSON, "[true,false,null]");
        this.assertFunction("cast(cast(ARRAY[1, 2, null] AS ARRAY<TINYINT>) AS JSON)", (Type)JsonType.JSON, "[1,2,null]");
        this.assertFunction("cast(cast(ARRAY[12345, -12345, null] AS ARRAY<SMALLINT>) AS JSON)", (Type)JsonType.JSON, "[12345,-12345,null]");
        this.assertFunction("cast(cast(ARRAY[123456789, -123456789, null] AS ARRAY<INTEGER>) AS JSON)", (Type)JsonType.JSON, "[123456789,-123456789,null]");
        this.assertFunction("cast(cast(ARRAY[1234567890123456789, -1234567890123456789, null] AS ARRAY<BIGINT>) AS JSON)", (Type)JsonType.JSON, "[1234567890123456789,-1234567890123456789,null]");
        this.assertFunction("CAST(CAST(ARRAY[3.14E0, nan(), infinity(), -infinity(), null] AS ARRAY<REAL>) AS JSON)", (Type)JsonType.JSON, "[3.14,\"NaN\",\"Infinity\",\"-Infinity\",null]");
        this.assertFunction("CAST(ARRAY[3.14E0, 1e-323, 1e308, nan(), infinity(), -infinity(), null] AS JSON)", (Type)JsonType.JSON, "[3.14,1.0E-323,1.0E308,\"NaN\",\"Infinity\",\"-Infinity\",null]");
        this.assertFunction("CAST(ARRAY[DECIMAL '3.14', null] AS JSON)", (Type)JsonType.JSON, "[3.14,null]");
        this.assertFunction("CAST(ARRAY[DECIMAL '12345678901234567890.123456789012345678', null] AS JSON)", (Type)JsonType.JSON, "[12345678901234567890.123456789012345678,null]");
        this.assertFunction("cast(ARRAY['a', 'bb', null] AS JSON)", (Type)JsonType.JSON, "[\"a\",\"bb\",null]");
        this.assertFunction("cast(ARRAY[JSON '123', JSON '3.14', JSON 'false', JSON '\"abc\"', JSON '[1, \"a\", null]', JSON '{\"a\": 1, \"b\": \"str\", \"c\": null}', JSON 'null', null] AS JSON)", (Type)JsonType.JSON, "[123,3.14,false,\"abc\",[1,\"a\",null],{\"a\":1,\"b\":\"str\",\"c\":null},null,null]");
        this.assertFunction("CAST(ARRAY[TIMESTAMP '1970-01-01 00:00:01', null] AS JSON)", (Type)JsonType.JSON, String.format("[\"%s\",null]", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("CAST(ARRAY[DATE '2001-08-22', DATE '2001-08-23', null] AS JSON)", (Type)JsonType.JSON, "[\"2001-08-22\",\"2001-08-23\",null]");
        this.assertFunction("cast(ARRAY[ARRAY[1, 2], ARRAY[3, null], ARRAY[], ARRAY[null, null], null] AS JSON)", (Type)JsonType.JSON, "[[1,2],[3,null],[],[null,null],null]");
        this.assertFunction("cast(ARRAY[MAP(ARRAY['b', 'a'], ARRAY[2, 1]), MAP(ARRAY['three', 'none'], ARRAY[3, null]), MAP(), MAP(ARRAY['h2', 'h1'], ARRAY[null, null]), null] AS JSON)", (Type)JsonType.JSON, "[{\"a\":1,\"b\":2},{\"none\":null,\"three\":3},{},{\"h1\":null,\"h2\":null},null]");
        this.assertFunction("cast(ARRAY[ROW(1, 2), ROW(3, CAST(null as INTEGER)), CAST(ROW(null, null) AS ROW(INTEGER, INTEGER)), null] AS JSON)", (Type)JsonType.JSON, "[[1,2],[3,null],[null,null],null]");
        this.assertFunction("CAST(ARRAY [12345.12345, 12345.12345, 3.0] AS JSON)", (Type)JsonType.JSON, "[12345.12345,12345.12345,3.00000]");
        this.assertFunction("CAST(ARRAY [123456789012345678901234567890.87654321, 123456789012345678901234567890.12345678] AS JSON)", (Type)JsonType.JSON, "[123456789012345678901234567890.87654321,123456789012345678901234567890.12345678]");
    }

    @Test
    public void testJsonToArray() {
        this.assertFunction("CAST(CAST (null AS JSON) AS ARRAY<BIGINT>)", (Type)new ArrayType((Type)BigintType.BIGINT), null);
        this.assertFunction("CAST(JSON 'null' AS ARRAY<BIGINT>)", (Type)new ArrayType((Type)BigintType.BIGINT), null);
        this.assertFunction("CAST(JSON '[]' AS ARRAY<BIGINT>)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of());
        this.assertFunction("CAST(JSON '[null, null]' AS ARRAY<BIGINT>)", (Type)new ArrayType((Type)BigintType.BIGINT), Lists.newArrayList((Object[])new Object[]{null, null}));
        this.assertFunction("CAST(JSON '[true, false, 12, 0, 12.3, 0.0, \"true\", \"false\", null]' AS ARRAY<BOOLEAN>)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(true, false, true, false, true, false, true, false, null));
        this.assertFunction("CAST(JSON '[true, false, 12, 12.7, \"12\", null]' AS ARRAY<TINYINT>)", (Type)new ArrayType((Type)TinyintType.TINYINT), Arrays.asList((byte)1, (byte)0, (byte)12, (byte)13, (byte)12, null));
        this.assertFunction("CAST(JSON '[true, false, 12345, 12345.6, \"12345\", null]' AS ARRAY<SMALLINT>)", (Type)new ArrayType((Type)SmallintType.SMALLINT), Arrays.asList((short)1, (short)0, (short)12345, (short)12346, (short)12345, null));
        this.assertFunction("CAST(JSON '[true, false, 12345678, 12345678.9, \"12345678\", null]' AS ARRAY<INTEGER>)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(1, 0, 12345678, 12345679, 12345678, null));
        this.assertFunction("CAST(JSON '[true, false, 1234567891234567, 1234567891234567.8, \"1234567891234567\", null]' AS ARRAY<BIGINT>)", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(1L, 0L, 1234567891234567L, 1234567891234568L, 1234567891234567L, null));
        this.assertFunction("CAST(JSON '[true, false, 12345, 12345.67, \"3.14\", \"NaN\", \"Infinity\", \"-Infinity\", null]' AS ARRAY<REAL>)", (Type)new ArrayType((Type)RealType.REAL), Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(12345.0f), Float.valueOf(12345.67f), Float.valueOf(3.14f), Float.valueOf(Float.NaN), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), null));
        this.assertFunction("CAST(JSON '[true, false, 1234567890, 1234567890.1, \"3.14\", \"NaN\", \"Infinity\", \"-Infinity\", null]' AS ARRAY<DOUBLE>)", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(1.0, 0.0, 1.23456789E9, 1.2345678901E9, 3.14, Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, null));
        this.assertFunction("CAST(JSON '[true, false, 128, 123.456, \"3.14\", null]' AS ARRAY<DECIMAL(10, 5)>)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)10, (int)5)), Arrays.asList(TestArrayOperators.decimal("1.00000"), TestArrayOperators.decimal("0.00000"), TestArrayOperators.decimal("128.00000"), TestArrayOperators.decimal("123.45600"), TestArrayOperators.decimal("3.14000"), null));
        this.assertFunction("CAST(JSON '[true, false, 128, 12345678.12345678, \"3.14\", null]' AS ARRAY<DECIMAL(38, 8)>)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)38, (int)8)), Arrays.asList(TestArrayOperators.decimal("1.00000000"), TestArrayOperators.decimal("0.00000000"), TestArrayOperators.decimal("128.00000000"), TestArrayOperators.decimal("12345678.12345678"), TestArrayOperators.decimal("3.14000000"), null));
        this.assertFunction("CAST(JSON '[true, false, 12, 12.3, \"puppies\", \"kittens\", \"null\", \"\", null]' AS ARRAY<VARCHAR>)", (Type)new ArrayType((Type)VarcharType.VARCHAR), Arrays.asList("true", "false", "12", "12.3", "puppies", "kittens", "null", "", null));
        this.assertFunction("CAST(JSON '[5, 3.14, [1, 2, 3], \"e\", {\"a\": \"b\"}, null, \"null\", [null]]' AS ARRAY<JSON>)", (Type)new ArrayType((Type)JsonType.JSON), ImmutableList.of((Object)"5", (Object)"3.14", (Object)"[1,2,3]", (Object)"\"e\"", (Object)"{\"a\":\"b\"}", (Object)"null", (Object)"\"null\"", (Object)"[null]"));
        this.assertFunction("CAST(JSON '[[1, 2], [3, null], [], [null, null], null]' AS ARRAY<ARRAY<BIGINT>>)", (Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)), Arrays.asList(Arrays.asList(1L, 2L), Arrays.asList(3L, null), Collections.emptyList(), Arrays.asList(null, null), null));
        this.assertFunction("CAST(JSON '[{\"a\": 1, \"b\": 2}, {\"none\": null, \"three\": 3}, {}, {\"h1\": null,\"h2\": null}, null]' AS ARRAY<MAP<VARCHAR, BIGINT>>)", (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), Arrays.asList(ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)2L), TestArrayOperators.asMap(ImmutableList.of((Object)"none", (Object)"three"), Arrays.asList(null, 3L)), ImmutableMap.of(), TestArrayOperators.asMap(ImmutableList.of((Object)"h1", (Object)"h2"), Arrays.asList(null, null)), null));
        this.assertFunction("CAST(JSON '[[1, \"two\"], [3, null], {\"k1\": 1, \"k2\": \"two\"}, {\"k2\": null, \"k1\": 3}, null]' AS ARRAY<ROW(k1 BIGINT, k2 VARCHAR)>)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k2", (Type)VarcharType.VARCHAR)))), Arrays.asList(Arrays.asList(1L, "two"), Arrays.asList(3L, null), Arrays.asList(1L, "two"), Arrays.asList(3L, null), null));
        this.assertInvalidCast("CAST(JSON '{\"a\": 1}' AS ARRAY<BIGINT>)", "Cannot cast to array(bigint). Expected a json array, but got {\n{\"a\":1}");
        this.assertInvalidCast("CAST(JSON '[1, 2, 3]' AS ARRAY<ARRAY<BIGINT>>)", "Cannot cast to array(array(bigint)). Expected a json array, but got 1\n[1,2,3]");
        this.assertInvalidCast("CAST(JSON '[1, {}]' AS ARRAY<BIGINT>)", "Cannot cast to array(bigint). Unexpected token when cast to bigint: {\n[1,{}]");
        this.assertInvalidCast("CAST(JSON '[[1], {}]' AS ARRAY<ARRAY<BIGINT>>)", "Cannot cast to array(array(bigint)). Expected a json array, but got {\n[[1],{}]");
        this.assertInvalidCast("CAST(unchecked_to_json('1, 2, 3') AS ARRAY<BIGINT>)", "Cannot cast to array(bigint).\n1, 2, 3");
        this.assertInvalidCast("CAST(unchecked_to_json('[1] 2') AS ARRAY<BIGINT>)", "Cannot cast to array(bigint). Unexpected trailing token: 2\n[1] 2");
        this.assertInvalidCast("CAST(unchecked_to_json('[1, 2, 3') AS ARRAY<BIGINT>)", "Cannot cast to array(bigint).\n[1, 2, 3");
        this.assertInvalidCast("CAST(JSON '[\"a\", \"b\"]' AS ARRAY<BIGINT>)", "Cannot cast to array(bigint). Cannot cast 'a' to BIGINT\n[\"a\",\"b\"]");
        this.assertInvalidCast("CAST(JSON '[1234567890123.456]' AS ARRAY<INTEGER>)", "Cannot cast to array(integer). Out of range for integer: 1.234567890123456E12\n[1.234567890123456E12]");
        this.assertFunction("CAST(JSON '[1, 2.0, 3]' AS ARRAY(DECIMAL(10,5)))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)10, (int)5)), ImmutableList.of((Object)TestArrayOperators.decimal("1.00000"), (Object)TestArrayOperators.decimal("2.00000"), (Object)TestArrayOperators.decimal("3.00000")));
        this.assertFunction("CAST(CAST(ARRAY [1, 2.0, 3] as JSON) AS ARRAY(DECIMAL(10,5)))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)10, (int)5)), ImmutableList.of((Object)TestArrayOperators.decimal("1.00000"), (Object)TestArrayOperators.decimal("2.00000"), (Object)TestArrayOperators.decimal("3.00000")));
        this.assertFunction("CAST(CAST(ARRAY [123456789012345678901234567890.12345678, 1.2] as JSON) AS ARRAY(DECIMAL(38,8)))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)38, (int)8)), ImmutableList.of((Object)TestArrayOperators.decimal("123456789012345678901234567890.12345678"), (Object)TestArrayOperators.decimal("1.20000000")));
        this.assertFunction("CAST(CAST(ARRAY [12345.87654] as JSON) AS ARRAY(DECIMAL(7,2)))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)7, (int)2)), ImmutableList.of((Object)TestArrayOperators.decimal("12345.88")));
        this.assertInvalidCast("CAST(CAST(ARRAY [12345.12345] as JSON) AS ARRAY(DECIMAL(6,2)))");
    }

    @Test
    public void testConstructor() {
        this.assertFunction("ARRAY []", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("ARRAY [NULL]", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Lists.newArrayList((Object[])new Object[]{null}));
        this.assertFunction("ARRAY [1, 2, 3]", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("ARRAY [1, NULL, 3]", (Type)new ArrayType((Type)IntegerType.INTEGER), Lists.newArrayList((Object[])new Integer[]{1, null, 3}));
        this.assertFunction("ARRAY [NULL, 2, 3]", (Type)new ArrayType((Type)IntegerType.INTEGER), Lists.newArrayList((Object[])new Integer[]{null, 2, 3}));
        this.assertFunction("ARRAY [1, 2.0E0, 3]", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0));
        this.assertFunction("ARRAY [ARRAY[1, 2], ARRAY[3]]", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3)));
        this.assertFunction("ARRAY [ARRAY[1, 2], NULL, ARRAY[3]]", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), Lists.newArrayList((Object[])new ImmutableList[]{ImmutableList.of((Object)1, (Object)2), null, ImmutableList.of((Object)3)}));
        this.assertFunction("ARRAY [BIGINT '1', 2, 3]", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        this.assertFunction("ARRAY [1, CAST (NULL AS BIGINT), 3]", (Type)new ArrayType((Type)BigintType.BIGINT), Lists.newArrayList((Object[])new Long[]{1L, null, 3L}));
        this.assertFunction("ARRAY [NULL, 20000000000, 30000000000]", (Type)new ArrayType((Type)BigintType.BIGINT), Lists.newArrayList((Object[])new Long[]{null, 20000000000L, 30000000000L}));
        this.assertFunction("ARRAY [1, 2.0E0, 3]", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0));
        this.assertFunction("ARRAY [ARRAY[1, 2], ARRAY[3]]", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3)));
        this.assertFunction("ARRAY [ARRAY[1, 2], NULL, ARRAY[3]]", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), Lists.newArrayList((Object[])new ImmutableList[]{ImmutableList.of((Object)1, (Object)2), null, ImmutableList.of((Object)3)}));
        this.assertFunction("ARRAY [ARRAY[1, 2], NULL, ARRAY[BIGINT '3']]", (Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)), Lists.newArrayList((Object[])new ImmutableList[]{ImmutableList.of((Object)1L, (Object)2L), null, ImmutableList.of((Object)3L)}));
        this.assertFunction("ARRAY [1.0E0, 2.5E0, 3.0E0]", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)2.5, (Object)3.0));
        this.assertFunction("ARRAY [1, 2.5E0, 3]", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)2.5, (Object)3.0));
        this.assertFunction("ARRAY ['puppies', 'kittens']", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"puppies", (Object)"kittens"));
        this.assertFunction("ARRAY [TRUE, FALSE]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("ARRAY [TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("ARRAY [sqrt(-1)]", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)Double.NaN));
        this.assertFunction("ARRAY [pow(infinity(), 2)]", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)Double.POSITIVE_INFINITY));
        this.assertFunction("ARRAY [pow(-infinity(), 1)]", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)Double.NEGATIVE_INFINITY));
        this.assertFunction("ARRAY [ARRAY [], NULL]", (Type)new ArrayType((Type)new ArrayType((Type)UnknownType.UNKNOWN)), Arrays.asList(ImmutableList.of(), null));
        this.assertFunction("ARRAY [ARRAY[1.0], ARRAY[2.0, 3.0]]", (Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))), Arrays.asList(Arrays.asList(TestArrayOperators.decimal("1.0")), Arrays.asList(TestArrayOperators.decimal("2.0"), TestArrayOperators.decimal("3.0"))));
        this.assertFunction("ARRAY[1.0, 2.0, 3.11]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)2)), Arrays.asList(TestArrayOperators.decimal("1.00"), TestArrayOperators.decimal("2.00"), TestArrayOperators.decimal("3.11")));
        this.assertFunction("ARRAY[1, 2.0, 3.11]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)12, (int)2)), Arrays.asList(TestArrayOperators.decimal("0000000001.00"), TestArrayOperators.decimal("0000000002.00"), TestArrayOperators.decimal("0000000003.11")));
        this.assertFunction("ARRAY [ARRAY[1.0], ARRAY[2.0, 123456789123456.789]]", (Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)18, (int)3))), Arrays.asList(Arrays.asList(TestArrayOperators.decimal("000000000000001.000")), Arrays.asList(TestArrayOperators.decimal("000000000000002.000"), TestArrayOperators.decimal("123456789123456.789"))));
    }

    @Test
    public void testArrayToArrayConcat() {
        this.assertFunction("ARRAY [1, NULL] || ARRAY [3]", (Type)new ArrayType((Type)IntegerType.INTEGER), Lists.newArrayList((Object[])new Integer[]{1, null, 3}));
        this.assertFunction("ARRAY [1, 2] || ARRAY[3, 4]", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4));
        this.assertFunction("ARRAY [1, 2] || ARRAY[3, BIGINT '4']", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        this.assertFunction("ARRAY [1, 2] || ARRAY[3, 40000000000]", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)40000000000L));
        this.assertFunction("ARRAY [NULL] || ARRAY[NULL]", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Lists.newArrayList((Object[])new Object[]{null, null}));
        this.assertFunction("ARRAY ['puppies'] || ARRAY ['kittens']", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"puppies", (Object)"kittens"));
        this.assertFunction("ARRAY [TRUE] || ARRAY [FALSE]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("concat(ARRAY [1] , ARRAY[2,3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("ARRAY [TIMESTAMP '1970-01-01 00:00:01'] || ARRAY[TIMESTAMP '1973-07-08 22:00:01']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("ARRAY [ARRAY[ARRAY[1]]] || ARRAY [ARRAY[ARRAY[2]]]", (Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))), Arrays.asList(Collections.singletonList(Ints.asList((int[])new int[]{1})), Collections.singletonList(Ints.asList((int[])new int[]{2}))));
        this.assertFunction("ARRAY [] || ARRAY []", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("ARRAY [TRUE] || ARRAY [FALSE] || ARRAY [TRUE]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false, (Object)true));
        this.assertFunction("ARRAY [1] || ARRAY [2] || ARRAY [3] || ARRAY [4]", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4));
        this.assertFunction("ARRAY [1] || ARRAY [2.0E0] || ARRAY [3] || ARRAY [4.0E0]", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0, (Object)4.0));
        this.assertFunction("ARRAY [ARRAY [1], ARRAY [2, 8]] || ARRAY [ARRAY [3, 6], ARRAY [4]]", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2, (Object)8), (Object)ImmutableList.of((Object)3, (Object)6), (Object)ImmutableList.of((Object)4)));
        this.assertFunction("ARRAY[1.0] || ARRAY [2.0, 3.11]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)2)), ImmutableList.of((Object)TestArrayOperators.decimal("1.00"), (Object)TestArrayOperators.decimal("2.00"), (Object)TestArrayOperators.decimal("3.11")));
        this.assertFunction("ARRAY[1.0] || ARRAY [2.0] || ARRAY [123456789123456.789]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)18, (int)3)), ImmutableList.of((Object)TestArrayOperators.decimal("000000000000001.000"), (Object)TestArrayOperators.decimal("000000000000002.000"), (Object)TestArrayOperators.decimal("123456789123456.789")));
        List<Object> nullList = Collections.nCopies(2, null);
        this.assertFunction("concat(ARRAY[], ARRAY[NULL], ARRAY[], ARRAY[NULL], ARRAY[])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), nullList);
        this.assertFunction("concat(ARRAY[], ARRAY[], ARRAY[], NULL, ARRAY[])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("concat(ARRAY[], ARRAY[], ARRAY[], ARRAY[], ARRAY[])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("concat(ARRAY[], ARRAY[], ARRAY[333], ARRAY[], ARRAY[])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)333));
        this.assertFunction("concat(ARRAY[1], ARRAY[2,3], ARRAY[])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("concat(ARRAY[1], ARRAY[2,3,3], ARRAY[2,1])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)3, (Object)2, (Object)1));
        this.assertFunction("concat(ARRAY[1], ARRAY[], ARRAY[1,2])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)1, (Object)2));
        this.assertFunction("concat(ARRAY[], ARRAY[1], ARRAY[], ARRAY[3], ARRAY[], ARRAY[5], ARRAY[])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)3, (Object)5));
        this.assertFunction("concat(ARRAY[], ARRAY['123456'], CAST(ARRAY[1,2] AS ARRAY(varchar)), ARRAY[])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"123456", (Object)"1", (Object)"2"));
        this.assertInvalidFunction("ARRAY [ARRAY[1]] || ARRAY[ARRAY[true], ARRAY[false]]", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("ARRAY [ARRAY [1]] || ARRAY [NULL]", (ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL);
        try {
            this.assertFunction("ARRAY [ARRAY [1]] || ARRAY [ARRAY ['x']]", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), null);
            Assert.fail((String)"arrays must be of the same type");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.assertCachedInstanceHasBoundedRetainedSize("ARRAY [1, NULL] || ARRAY [3]");
    }

    @Test
    public void testElementArrayConcat() {
        this.assertFunction("CAST (ARRAY [DATE '2001-08-22'] || DATE '2001-08-23' AS JSON)", (Type)JsonType.JSON, "[\"2001-08-22\",\"2001-08-23\"]");
        this.assertFunction("CAST (DATE '2001-08-23' || ARRAY [DATE '2001-08-22'] AS JSON)", (Type)JsonType.JSON, "[\"2001-08-23\",\"2001-08-22\"]");
        this.assertFunction("1 || ARRAY [2]", (Type)new ArrayType((Type)IntegerType.INTEGER), Lists.newArrayList((Object[])new Integer[]{1, 2}));
        this.assertFunction("ARRAY [2] || 1", (Type)new ArrayType((Type)IntegerType.INTEGER), Lists.newArrayList((Object[])new Integer[]{2, 1}));
        this.assertFunction("ARRAY [2] || BIGINT '1'", (Type)new ArrayType((Type)BigintType.BIGINT), Lists.newArrayList((Object[])new Long[]{2L, 1L}));
        this.assertFunction("TRUE || ARRAY [FALSE]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Lists.newArrayList((Object[])new Boolean[]{true, false}));
        this.assertFunction("ARRAY [FALSE] || TRUE", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Lists.newArrayList((Object[])new Boolean[]{false, true}));
        this.assertFunction("1.0E0 || ARRAY [2.0E0]", (Type)new ArrayType((Type)DoubleType.DOUBLE), Lists.newArrayList((Object[])new Double[]{1.0, 2.0}));
        this.assertFunction("ARRAY [2.0E0] || 1.0E0", (Type)new ArrayType((Type)DoubleType.DOUBLE), Lists.newArrayList((Object[])new Double[]{2.0, 1.0}));
        this.assertFunction("'puppies' || ARRAY ['kittens']", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), Lists.newArrayList((Object[])new String[]{"puppies", "kittens"}));
        this.assertFunction("ARRAY ['kittens'] || 'puppies'", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), Lists.newArrayList((Object[])new String[]{"kittens", "puppies"}));
        this.assertFunction("ARRAY [TIMESTAMP '1970-01-01 00:00:01'] || TIMESTAMP '1973-07-08 22:00:01'", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("TIMESTAMP '1973-07-08 22:00:01' || ARRAY [TIMESTAMP '1970-01-01 00:00:01']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("ARRAY [2, 8] || ARRAY[ARRAY[3, 6], ARRAY[4]]", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)2, (Object)8), (Object)ImmutableList.of((Object)3, (Object)6), (Object)ImmutableList.of((Object)4)));
        this.assertFunction("ARRAY [ARRAY [1], ARRAY [2, 8]] || ARRAY [3, 6]", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2, (Object)8), (Object)ImmutableList.of((Object)3, (Object)6)));
        this.assertFunction("ARRAY [2.0, 3.11] || 1.0", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)2)), Arrays.asList(TestArrayOperators.decimal("2.00"), TestArrayOperators.decimal("3.11"), TestArrayOperators.decimal("1.00")));
        this.assertFunction("ARRAY[1.0] || 2.0 || 123456789123456.789", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)18, (int)3)), Arrays.asList(TestArrayOperators.decimal("000000000000001.000"), TestArrayOperators.decimal("000000000000002.000"), TestArrayOperators.decimal("123456789123456.789")));
        try {
            this.assertFunction("ARRAY [ARRAY[1]] || ARRAY ['x']", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), null);
            Assert.fail((String)"arrays must be of the same type");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.assertCachedInstanceHasBoundedRetainedSize("ARRAY [1, NULL] || 3");
        this.assertCachedInstanceHasBoundedRetainedSize("3 || ARRAY [1, NULL]");
    }

    @Test
    public void testArrayContains() {
        this.assertFunction("CONTAINS(ARRAY ['puppies', 'dogs'], 'dogs')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [1, 2, 3], 2)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [1, BIGINT '2', 3], 2)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [1, 2, 3], BIGINT '2')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [1, 2, 3], 5)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CONTAINS(ARRAY [1, NULL, 3], 1)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [NULL, 2, 3], 1)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("CONTAINS(ARRAY [NULL, 2, 3], NULL)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("CONTAINS(ARRAY [1, 2.0E0, 3], 3.0E0)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [1.0E0, 2.5E0, 3.0E0], 2.2E0)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CONTAINS(ARRAY ['puppies', 'dogs'], 'dogs')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY ['puppies', 'dogs'], 'sharks')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CONTAINS(ARRAY [TRUE, FALSE], TRUE)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [FALSE], TRUE)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CONTAINS(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [3, 4])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [3])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CONTAINS(ARRAY [CAST (NULL AS BIGINT)], 1)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("CONTAINS(ARRAY [CAST (NULL AS BIGINT)], NULL)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("CONTAINS(ARRAY [], NULL)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("CONTAINS(ARRAY [], 1)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CONTAINS(ARRAY [2.2, 1.1], 1.1)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [2.2, 1.1], 1.1)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [2.2, NULL], 1.1)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("CONTAINS(ARRAY [2.2, 1.1], 1.2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CONTAINS(ARRAY [2.2, 1.1], 0000000000001.100)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [2.2, 001.20], 1.2)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [ARRAY [1.1, 2.2], ARRAY [3.3, 4.3]], ARRAY [3.3, 4.300])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CONTAINS(ARRAY [ARRAY [1.1, 2.2], ARRAY [3.3, 4.3]], ARRAY [1.3, null])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CONTAINS(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789'], TIMESTAMP '1111-05-10 12:34:56.123456789')", (Type)BooleanType.BOOLEAN, true);
        this.assertInvalidFunction("CONTAINS(ARRAY [ARRAY [1.1, 2.2], ARRAY [3.3, 4.3]], ARRAY [1.1, null])", (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertInvalidFunction("CONTAINS(ARRAY [ARRAY [1.1, null], ARRAY [3.3, 4.3]], ARRAY [1.1, null])", (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testArrayJoin() {
        this.assertFunction("array_join(ARRAY[NULL, 1, 2], ',')", (Type)VarcharType.VARCHAR, "1,2");
        this.assertFunction("array_join(ARRAY[1, NULL, 2], ',')", (Type)VarcharType.VARCHAR, "1,2");
        this.assertFunction("array_join(ARRAY[1, 2, NULL], ',')", (Type)VarcharType.VARCHAR, "1,2");
        this.assertFunction("ARRAY_JOIN(ARRAY [1, 2, 3], ';', 'N/A')", (Type)VarcharType.VARCHAR, "1;2;3");
        this.assertFunction("ARRAY_JOIN(ARRAY [1, 2, null], ';', 'N/A')", (Type)VarcharType.VARCHAR, "1;2;N/A");
        this.assertFunction("ARRAY_JOIN(ARRAY [1, 2, 3], 'x')", (Type)VarcharType.VARCHAR, "1x2x3");
        this.assertFunction("ARRAY_JOIN(ARRAY [BIGINT '1', 2, 3], 'x')", (Type)VarcharType.VARCHAR, "1x2x3");
        this.assertFunction("ARRAY_JOIN(ARRAY [null], '=')", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("ARRAY_JOIN(ARRAY [null,null], '=')", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("ARRAY_JOIN(ARRAY [], 'S')", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("ARRAY_JOIN(ARRAY [''], '', '')", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("ARRAY_JOIN(ARRAY [1, 2, 3, null, 5], ',', '*')", (Type)VarcharType.VARCHAR, "1,2,3,*,5");
        this.assertFunction("ARRAY_JOIN(ARRAY ['a', 'b', 'c', null, null, 'd'], '-', 'N/A')", (Type)VarcharType.VARCHAR, "a-b-c-N/A-N/A-d");
        this.assertFunction("ARRAY_JOIN(ARRAY ['a', 'b', 'c', null, null, 'd'], '-')", (Type)VarcharType.VARCHAR, "a-b-c-d");
        this.assertFunction("ARRAY_JOIN(ARRAY [null, null, null, null], 'X')", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("ARRAY_JOIN(ARRAY [true, false], 'XX')", (Type)VarcharType.VARCHAR, "trueXXfalse");
        this.assertFunction("ARRAY_JOIN(ARRAY [sqrt(-1), infinity()], ',')", (Type)VarcharType.VARCHAR, "NaN,Infinity");
        this.assertFunction("ARRAY_JOIN(ARRAY [JSON '\"a\"', JSON '\"b\"'], ',')", (Type)VarcharType.VARCHAR, "a,b");
        this.assertFunction("ARRAY_JOIN(ARRAY [JSON '\"a\"', JSON 'null'], ',')", (Type)VarcharType.VARCHAR, "a");
        this.assertFunction("ARRAY_JOIN(ARRAY [JSON '\"a\"', JSON 'null'], ',', 'N/A')", (Type)VarcharType.VARCHAR, "a,N/A");
        this.assertFunction("ARRAY_JOIN(ARRAY [TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01'], '|')", (Type)VarcharType.VARCHAR, String.format("%s|%s", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("ARRAY_JOIN(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789'], '|')", (Type)VarcharType.VARCHAR, "2020-05-10 12:34:56.123456789|1111-05-10 12:34:56.123456789");
        this.assertFunction("ARRAY_JOIN(ARRAY [null, TIMESTAMP '1970-01-01 00:00:01'], '|')", (Type)VarcharType.VARCHAR, DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION).toString());
        this.assertFunction("ARRAY_JOIN(ARRAY [null, TIMESTAMP '1970-01-01 00:00:01'], '|', 'XYZ')", (Type)VarcharType.VARCHAR, "XYZ|" + DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION).toString());
        this.assertFunction("ARRAY_JOIN(ARRAY [1.0, 2.1, 3.3], 'x')", (Type)VarcharType.VARCHAR, "1.0x2.1x3.3");
        this.assertFunction("ARRAY_JOIN(ARRAY [1.0, 2.100, 3.3], 'x')", (Type)VarcharType.VARCHAR, "1.000x2.100x3.300");
        this.assertFunction("ARRAY_JOIN(ARRAY [1.0, 2.100, NULL], 'x', 'N/A')", (Type)VarcharType.VARCHAR, "1.000x2.100xN/A");
        this.assertFunction("ARRAY_JOIN(ARRAY [1.0, DOUBLE '002.100', 3.3], 'x')", (Type)VarcharType.VARCHAR, "1.0x2.1x3.3");
        this.assertInvalidFunction("ARRAY_JOIN(ARRAY [ARRAY [1], ARRAY [2]], '-')", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("ARRAY_JOIN(ARRAY [MAP(ARRAY [1], ARRAY [2])], '-')", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("ARRAY_JOIN(ARRAY [cast(row(1, 2) AS row(col0 bigint, col1 bigint))], '-')", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND);
    }

    @Test
    public void testCardinality() {
        this.assertFunction("CARDINALITY(ARRAY [])", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("CARDINALITY(ARRAY [NULL])", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("CARDINALITY(ARRAY [1, 2, 3])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("CARDINALITY(ARRAY [1, NULL, 3])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("CARDINALITY(ARRAY [1, 2.0E0, 3])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("CARDINALITY(ARRAY [ARRAY[1, 2], ARRAY[3]])", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CARDINALITY(ARRAY [1.0E0, 2.5E0, 3.0E0])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("CARDINALITY(ARRAY ['puppies', 'kittens'])", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CARDINALITY(ARRAY [TRUE, FALSE])", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CARDINALITY(ARRAY [1.1, 2.2, 3.3])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("CARDINALITY(ARRAY [1.1, 33832293522235.23522])", (Type)BigintType.BIGINT, 2L);
    }

    @Test
    public void testArrayMin() {
        this.assertFunction("ARRAY_MIN(ARRAY [])", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ARRAY_MIN(ARRAY [NULL])", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ARRAY_MIN(ARRAY [NaN()])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MIN(ARRAY [NULL, NULL, NULL])", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ARRAY_MIN(ARRAY [NaN(), NaN(), NaN()])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MIN(ARRAY [NULL, 2, 3])", (Type)IntegerType.INTEGER, null);
        this.assertFunction("ARRAY_MIN(ARRAY [NaN(), 2, 3])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MIN(ARRAY [NULL, NaN(), 1])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MIN(ARRAY [NaN(), NULL, 3.0])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MIN(ARRAY [1.0E0, NULL, 3])", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("ARRAY_MIN(ARRAY [1.0, NaN(), 3])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MIN(ARRAY ['1', '2', NULL])", (Type)VarcharType.createVarcharType((int)1), null);
        this.assertFunction("ARRAY_MIN(ARRAY [3, 2, 1])", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("ARRAY_MIN(ARRAY [1, 2, 3])", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("ARRAY_MIN(ARRAY [BIGINT '3', 2, 1])", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("ARRAY_MIN(ARRAY [1, 2.0E0, 3])", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("ARRAY_MIN(ARRAY [ARRAY[1, 2], ARRAY[3]])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("ARRAY_MIN(ARRAY [1.0E0, 2.5E0, 3.0E0])", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("ARRAY_MIN(ARRAY ['puppies', 'kittens'])", (Type)VarcharType.createVarcharType((int)7), "kittens");
        this.assertFunction("ARRAY_MIN(ARRAY [TRUE, FALSE])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY_MIN(ARRAY [NULL, FALSE])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAY_MIN(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '2222-05-10 12:34:56.123456789'])", (Type)TimestampType.createTimestampType((int)9), TestArrayOperators.legacyTimestamp(9, "2020-05-10 12:34:56.123456789"));
        this.assertDecimalFunction("ARRAY_MIN(ARRAY [2.1, 2.2, 2.3])", TestArrayOperators.decimal("2.1"));
        this.assertDecimalFunction("ARRAY_MIN(ARRAY [2.111111222111111114111, 2.22222222222222222, 2.222222222222223])", TestArrayOperators.decimal("2.111111222111111114111"));
        this.assertDecimalFunction("ARRAY_MIN(ARRAY [1.9, 2, 2.3])", TestArrayOperators.decimal("0000000001.9"));
        this.assertDecimalFunction("ARRAY_MIN(ARRAY [2.22222222222222222, 2.3])", TestArrayOperators.decimal("2.22222222222222222"));
    }

    @Test
    public void testArrayMax() {
        this.assertFunction("ARRAY_MAX(ARRAY [])", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ARRAY_MAX(ARRAY [NULL])", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ARRAY_MAX(ARRAY [NaN()])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MAX(ARRAY [NULL, NULL, NULL])", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ARRAY_MAX(ARRAY [NaN(), NaN(), NaN()])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MAX(ARRAY [NULL, 2, 3])", (Type)IntegerType.INTEGER, null);
        this.assertFunction("ARRAY_MAX(ARRAY [NaN(), 2, 3])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MAX(ARRAY [NULL, NaN(), 1])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MAX(ARRAY [NaN(), NULL, 3.0])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MAX(ARRAY [1.0E0, NULL, 3])", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("ARRAY_MAX(ARRAY [1.0, NaN(), 3])", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ARRAY_MAX(ARRAY ['1', '2', NULL])", (Type)VarcharType.createVarcharType((int)1), null);
        this.assertFunction("ARRAY_MAX(ARRAY [3, 2, 1])", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("ARRAY_MAX(ARRAY [1, 2, 3])", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("ARRAY_MAX(ARRAY [BIGINT '1', 2, 3])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_MAX(ARRAY [1, 2.0E0, 3])", (Type)DoubleType.DOUBLE, 3.0);
        this.assertFunction("ARRAY_MAX(ARRAY [ARRAY[1, 2], ARRAY[3]])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3));
        this.assertFunction("ARRAY_MAX(ARRAY [1.0E0, 2.5E0, 3.0E0])", (Type)DoubleType.DOUBLE, 3.0);
        this.assertFunction("ARRAY_MAX(ARRAY ['puppies', 'kittens'])", (Type)VarcharType.createVarcharType((int)7), "puppies");
        this.assertFunction("ARRAY_MAX(ARRAY [TRUE, FALSE])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY_MAX(ARRAY [NULL, FALSE])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAY_MAX(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789'])", (Type)TimestampType.createTimestampType((int)9), TestArrayOperators.legacyTimestamp(9, "2020-05-10 12:34:56.123456789"));
        this.assertDecimalFunction("ARRAY_MAX(ARRAY [2.1, 2.2, 2.3])", TestArrayOperators.decimal("2.3"));
        this.assertDecimalFunction("ARRAY_MAX(ARRAY [2.111111222111111114111, 2.22222222222222222, 2.222222222222223])", TestArrayOperators.decimal("2.222222222222223000000"));
        this.assertDecimalFunction("ARRAY_MAX(ARRAY [1.9, 2, 2.3])", TestArrayOperators.decimal("0000000002.3"));
        this.assertDecimalFunction("ARRAY_MAX(ARRAY [2.22222222222222222, 2.3])", TestArrayOperators.decimal("2.30000000000000000"));
    }

    @Test
    public void testArrayPosition() {
        this.assertFunction("ARRAY_POSITION(ARRAY [10, 20, 30, 40], 30)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(CAST (JSON '[]' as array(bigint)), 30)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("ARRAY_POSITION(ARRAY [cast(NULL as bigint)], 30)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("ARRAY_POSITION(ARRAY [cast(NULL as bigint), NULL, NULL], 30)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("ARRAY_POSITION(ARRAY [NULL, NULL, 30, NULL], 30)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(ARRAY [1.1E0, 2.1E0, 3.1E0, 4.1E0], 3.1E0)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(ARRAY [false, false, true, true], true)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(ARRAY ['10', '20', '30', '40'], '30')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(ARRAY [DATE '2000-01-01', DATE '2000-01-02', DATE '2000-01-03', DATE '2000-01-04'], DATE '2000-01-03')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(ARRAY [ARRAY [1, 11], ARRAY [2, 12], ARRAY [3, 13], ARRAY [4, 14]], ARRAY [3, 13])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(ARRAY [], NULL)", (Type)BigintType.BIGINT, null);
        this.assertFunction("ARRAY_POSITION(ARRAY [NULL], NULL)", (Type)BigintType.BIGINT, null);
        this.assertFunction("ARRAY_POSITION(ARRAY [1, NULL, 2], NULL)", (Type)BigintType.BIGINT, null);
        this.assertFunction("ARRAY_POSITION(ARRAY [1, CAST(NULL AS BIGINT), 2], CAST(NULL AS BIGINT))", (Type)BigintType.BIGINT, null);
        this.assertFunction("ARRAY_POSITION(ARRAY [1, NULL, 2], CAST(NULL AS BIGINT))", (Type)BigintType.BIGINT, null);
        this.assertFunction("ARRAY_POSITION(ARRAY [1, CAST(NULL AS BIGINT), 2], NULL)", (Type)BigintType.BIGINT, null);
        this.assertFunction("ARRAY_POSITION(ARRAY [1.0, 2.0, 3.0, 4.0], 3.0)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(ARRAY [1.0, 2.0, 000000000000000000000003.000, 4.0], 3.0)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(ARRAY [1.0, 2.0, 3.0, 4.0], 000000000000000000000003.000)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(ARRAY [1.0, 2.0, 3.0, 4.0], 3)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("ARRAY_POSITION(ARRAY [1.0, 2.0, 3, 4.0], 4.0)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("ARRAY_POSITION(ARRAY [ARRAY[1]], ARRAY[1])", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("ARRAY_POSITION(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789'], TIMESTAMP '1111-05-10 12:34:56.123456789')", (Type)BigintType.BIGINT, 2L);
        this.assertInvalidFunction("ARRAY_POSITION(ARRAY [ARRAY[null]], ARRAY[1])", (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertInvalidFunction("ARRAY_POSITION(ARRAY [ARRAY[null]], ARRAY[null])", (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testSubscript() {
        this.assertInvalidFunction("ARRAY [][1]", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript must be less than or equal to array length: 1 > 0");
        this.assertInvalidFunction("ARRAY [null][-1]", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript is negative: -1");
        this.assertInvalidFunction("ARRAY [1, 2, 3][0]", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        this.assertInvalidFunction("ARRAY [1, 2, 3][-1]", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript is negative: -1");
        this.assertInvalidFunction("ARRAY [1, 2, 3][4]", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript must be less than or equal to array length: 4 > 3");
        this.assertInvalidFunction("ARRAY [1, 2, 3][1.1E0]", (ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, "line 1:1: Cannot use double for subscript of array(integer)");
        this.assertFunction("ARRAY[NULL][1]", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ARRAY[NULL, NULL, NULL][3]", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("1 + ARRAY [2, 1, 3][2]", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("ARRAY [2, 1, 3][2]", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("ARRAY [2, NULL, 3][2]", (Type)IntegerType.INTEGER, null);
        this.assertFunction("ARRAY [1.0E0, 2.5E0, 3.5E0][3]", (Type)DoubleType.DOUBLE, 3.5);
        this.assertFunction("ARRAY [ARRAY[1, 2], ARRAY[3]][2]", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3));
        this.assertFunction("ARRAY [ARRAY[1, 2], NULL, ARRAY[3]][2]", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("ARRAY [ARRAY[1, 2], ARRAY[3]][2][1]", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("ARRAY ['puppies', 'kittens'][2]", (Type)VarcharType.createVarcharType((int)7), "kittens");
        this.assertFunction("ARRAY ['puppies', 'kittens', NULL][3]", (Type)VarcharType.createVarcharType((int)7), null);
        this.assertFunction("ARRAY [TRUE, FALSE][2]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01'][1]", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION));
        this.assertFunction("ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789'][2]", (Type)TimestampType.createTimestampType((int)9), TestArrayOperators.legacyTimestamp(9, "1111-05-10 12:34:56.123456789"));
        this.assertFunction("ARRAY [infinity()][1]", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("ARRAY [-infinity()][1]", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.assertFunction("ARRAY [sqrt(-1)][1]", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertDecimalFunction("ARRAY [2.1, 2.2, 2.3][3]", TestArrayOperators.decimal("2.3"));
        this.assertDecimalFunction("ARRAY [2.111111222111111114111, 2.22222222222222222, 2.222222222222223][3]", TestArrayOperators.decimal("2.222222222222223000000"));
        this.assertDecimalFunction("ARRAY [1.9, 2, 2.3][3]", TestArrayOperators.decimal("0000000002.3"));
        this.assertDecimalFunction("ARRAY [2.22222222222222222, 2.3][1]", TestArrayOperators.decimal("2.22222222222222222"));
    }

    @Test
    public void testElementAt() {
        this.assertInvalidFunction("ELEMENT_AT(ARRAY [], 0)", "SQL array indices start at 1");
        this.assertInvalidFunction("ELEMENT_AT(ARRAY [1, 2, 3], 0)", "SQL array indices start at 1");
        this.assertFunction("ELEMENT_AT(ARRAY [], 1)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ELEMENT_AT(ARRAY [], -1)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ELEMENT_AT(ARRAY [1, 2, 3], 4)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("ELEMENT_AT(ARRAY [1, 2, 3], -4)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("ELEMENT_AT(ARRAY [NULL], 1)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ELEMENT_AT(ARRAY [NULL], -1)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ELEMENT_AT(ARRAY [NULL, NULL, NULL], 3)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("ELEMENT_AT(ARRAY [NULL, NULL, NULL], -1)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("1 + ELEMENT_AT(ARRAY [2, 1, 3], 2)", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("10000000000 + ELEMENT_AT(ARRAY [2, 1, 3], -2)", (Type)BigintType.BIGINT, 10000000001L);
        this.assertFunction("ELEMENT_AT(ARRAY [2, 1, 3], 2)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("ELEMENT_AT(ARRAY [2, 1, 3], -2)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("ELEMENT_AT(ARRAY [2, NULL, 3], 2)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("ELEMENT_AT(ARRAY [2, NULL, 3], -2)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("ELEMENT_AT(ARRAY [BIGINT '2', 1, 3], -2)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("ELEMENT_AT(ARRAY [2, NULL, BIGINT '3'], -2)", (Type)BigintType.BIGINT, null);
        this.assertFunction("ELEMENT_AT(ARRAY [1.0E0, 2.5E0, 3.5E0], 3)", (Type)DoubleType.DOUBLE, 3.5);
        this.assertFunction("ELEMENT_AT(ARRAY [1.0E0, 2.5E0, 3.5E0], -1)", (Type)DoubleType.DOUBLE, 3.5);
        this.assertFunction("ELEMENT_AT(ARRAY [ARRAY [1, 2], ARRAY [3]], 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3));
        this.assertFunction("ELEMENT_AT(ARRAY [ARRAY [1, 2], ARRAY [3]], -1)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3));
        this.assertFunction("ELEMENT_AT(ARRAY [ARRAY [1, 2], NULL, ARRAY [3]], 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("ELEMENT_AT(ARRAY [ARRAY [1, 2], NULL, ARRAY [3]], -2)", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("ELEMENT_AT(ELEMENT_AT(ARRAY [ARRAY[1, 2], ARRAY [3]], 2) , 1)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("ELEMENT_AT(ELEMENT_AT(ARRAY [ARRAY[1, 2], ARRAY [3]], -1) , 1)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("ELEMENT_AT(ELEMENT_AT(ARRAY [ARRAY[1, 2], ARRAY [3]], 2) , -1)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("ELEMENT_AT(ELEMENT_AT(ARRAY [ARRAY[1, 2], ARRAY [3]], -1) , -1)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("ELEMENT_AT(ARRAY ['puppies', 'kittens'], 2)", (Type)VarcharType.createVarcharType((int)7), "kittens");
        this.assertFunction("ELEMENT_AT(ARRAY ['crocodiles', 'kittens'], 2)", (Type)VarcharType.createVarcharType((int)10), "kittens");
        this.assertFunction("ELEMENT_AT(ARRAY ['puppies', 'kittens'], -1)", (Type)VarcharType.createVarcharType((int)7), "kittens");
        this.assertFunction("ELEMENT_AT(ARRAY ['puppies', 'kittens', NULL], 3)", (Type)VarcharType.createVarcharType((int)7), null);
        this.assertFunction("ELEMENT_AT(ARRAY ['puppies', 'kittens', NULL], -1)", (Type)VarcharType.createVarcharType((int)7), null);
        this.assertFunction("ELEMENT_AT(ARRAY [TRUE, FALSE], 2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ELEMENT_AT(ARRAY [TRUE, FALSE], -1)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ELEMENT_AT(ARRAY [TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01'], 1)", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION));
        this.assertFunction("ELEMENT_AT(ARRAY [TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01'], -2)", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION));
        this.assertFunction("ELEMENT_AT(ARRAY [infinity()], 1)", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("ELEMENT_AT(ARRAY [infinity()], -1)", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("ELEMENT_AT(ARRAY [-infinity()], 1)", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.assertFunction("ELEMENT_AT(ARRAY [-infinity()], -1)", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.assertFunction("ELEMENT_AT(ARRAY [sqrt(-1)], 1)", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ELEMENT_AT(ARRAY [sqrt(-1)], -1)", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("ELEMENT_AT(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789'], 2)", (Type)TimestampType.createTimestampType((int)9), TestArrayOperators.legacyTimestamp(9, "1111-05-10 12:34:56.123456789"));
        this.assertDecimalFunction("ELEMENT_AT(ARRAY [2.1, 2.2, 2.3], 3)", TestArrayOperators.decimal("2.3"));
        this.assertDecimalFunction("ELEMENT_AT(ARRAY [2.111111222111111114111, 2.22222222222222222, 2.222222222222223], 3)", TestArrayOperators.decimal("2.222222222222223000000"));
        this.assertDecimalFunction("ELEMENT_AT(ARRAY [1.9, 2, 2.3], -1)", TestArrayOperators.decimal("0000000002.3"));
        this.assertDecimalFunction("ELEMENT_AT(ARRAY [2.22222222222222222, 2.3], -2)", TestArrayOperators.decimal("2.22222222222222222"));
    }

    @Test
    public void testShuffle() {
        this.assertCachedInstanceHasBoundedRetainedSize("SHUFFLE(ARRAY[2, 3, 4, 1])");
    }

    @Test
    public void testSort() {
        this.assertFunction("ARRAY_SORT(ARRAY[2, 3, 4, 1])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4));
        this.assertFunction("ARRAY_SORT(ARRAY[2, BIGINT '3', 4, 1])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        this.assertFunction("ARRAY_SORT(ARRAY [2.3, 2.1, 2.2])", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableList.of((Object)TestArrayOperators.decimal("2.1"), (Object)TestArrayOperators.decimal("2.2"), (Object)TestArrayOperators.decimal("2.3")));
        this.assertFunction("ARRAY_SORT(ARRAY [2, 1.900, 2.330])", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)13, (int)3)), ImmutableList.of((Object)TestArrayOperators.decimal("0000000001.900"), (Object)TestArrayOperators.decimal("0000000002.000"), (Object)TestArrayOperators.decimal("0000000002.330")));
        this.assertFunction("ARRAY_SORT(ARRAY['z', 'f', 's', 'd', 'g'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"d", (Object)"f", (Object)"g", (Object)"s", (Object)"z"));
        this.assertFunction("ARRAY_SORT(ARRAY[TRUE, FALSE])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)false, (Object)true));
        this.assertFunction("ARRAY_SORT(ARRAY[22.1E0, 11.1E0, 1.1E0, 44.1E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.1, (Object)11.1, (Object)22.1, (Object)44.1));
        this.assertFunction("ARRAY_SORT(ARRAY [TIMESTAMP '1973-07-08 22:00:01', TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1989-02-06 12:00:00'])", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1989, (int)2, (int)6, (int)12, (int)0, (int)0, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("ARRAY_SORT(ARRAY [ARRAY [1], ARRAY [2]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2)));
        this.assertFunction("ARRAY_SORT(ARRAY[2, 3, 2, null, null, 4, 1], (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(null, null, 4, 3, 2, 2, 1));
        this.assertFunction("ARRAY_SORT(ARRAY[2, 3, 2, null, null, 4, 1], (x, y) -> CASE WHEN x IS NULL THEN 1 WHEN y IS NULL THEN -1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(4, 3, 2, 2, 1, null, null));
        this.assertFunction("ARRAY_SORT(ARRAY[2, null, BIGINT '3', 4, null, 1], (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(null, null, 4L, 3L, 2L, 1L));
        this.assertFunction("ARRAY_SORT(ARRAY['bc', null, 'ab', 'dc', null], (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), Arrays.asList(null, null, "dc", "bc", "ab"));
        this.assertFunction("ARRAY_SORT(ARRAY['a', null, 'abcd', null, 'abc', 'zx'], (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN length(x) < length(y) THEN 1 WHEN length(x) = length(y) THEN 0 ELSE -1 END)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), Arrays.asList(null, null, "abcd", "abc", "zx", "a"));
        this.assertFunction("ARRAY_SORT(ARRAY[TRUE, null, FALSE, TRUE, null, FALSE, TRUE], (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x = y THEN 0 WHEN x THEN -1 ELSE 1 END)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(null, null, true, true, true, false, false));
        this.assertFunction("ARRAY_SORT(ARRAY[22.1E0, null, null, 11.1E0, 1.1E0, 44.1E0], (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(null, null, 44.1, 22.1, 11.1, 1.1));
        this.assertFunction("ARRAY_SORT(ARRAY[TIMESTAMP '1973-07-08 22:00:01', NULL, TIMESTAMP '1970-01-01 00:00:01', NULL, TIMESTAMP '1989-02-06 12:00:00'], (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN date_diff('millisecond', y, x) < 0 THEN 1 WHEN date_diff('millisecond', y, x) = 0 THEN 0 ELSE -1 END)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), Arrays.asList(null, null, DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1989, (int)2, (int)6, (int)12, (int)0, (int)0, (int)0, (Session)SessionTestUtils.TEST_SESSION), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("ARRAY_SORT(ARRAY[ARRAY[2, 3, 1], null, ARRAY[4, null, 2, 1, 4], ARRAY[1, 2], null], (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN cardinality(x) < cardinality(y) THEN 1 WHEN cardinality(x) = cardinality(y) THEN 0 ELSE -1 END)", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), Arrays.asList(null, null, Arrays.asList(4, null, 2, 1, 4), Arrays.asList(2, 3, 1), Arrays.asList(1, 2)));
        this.assertFunction("ARRAY_SORT(ARRAY[2.3, null, 2.1, null, 2.2], (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), Arrays.asList(null, null, TestArrayOperators.decimal("2.3"), TestArrayOperators.decimal("2.2"), TestArrayOperators.decimal("2.1")));
        this.assertFunction("ARRAY_SORT(ARRAY[TIMESTAMP '1111-06-10 12:34:56.123456789', TIMESTAMP '2020-05-10 12:34:56.123456789'], (x, y) -> CASE WHEN month(x) > month(y) THEN 1 ELSE -1 END)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)9)), ImmutableList.of((Object)TestArrayOperators.legacyTimestamp(9, "2020-05-10 12:34:56.123456789"), (Object)TestArrayOperators.legacyTimestamp(9, "1111-06-10 12:34:56.123456789")));
        List<Integer> expected = Arrays.asList(-1, 0, 1, null, null);
        this.assertFunction("ARRAY_SORT(ARRAY[1, null, 0, null, -1])", (Type)new ArrayType((Type)IntegerType.INTEGER), expected);
        this.assertFunction("ARRAY_SORT(ARRAY[1, null, null, -1, 0])", (Type)new ArrayType((Type)IntegerType.INTEGER), expected);
        this.assertInvalidFunction("ARRAY_SORT(ARRAY[color('red'), color('blue')])", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("ARRAY_SORT(ARRAY[2, 1, 2, 4], (x, y) -> y - x)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lambda comparator must return either -1, 0, or 1");
        this.assertInvalidFunction("ARRAY_SORT(ARRAY[1, 2], (x, y) -> x / COALESCE(y, 0))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lambda comparator must return either -1, 0, or 1");
        this.assertInvalidFunction("ARRAY_SORT(ARRAY[2, 3, 2, 4, 1], (x, y) -> IF(x > y, NULL, IF(x = y, 0, -1)))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lambda comparator must return either -1, 0, or 1");
        this.assertInvalidFunction("ARRAY_SORT(ARRAY[1, null], (x, y) -> x / COALESCE(y, 0))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lambda comparator must return either -1, 0, or 1");
        this.assertCachedInstanceHasBoundedRetainedSize("ARRAY_SORT(ARRAY[2, 3, 4, 1])");
    }

    @Test
    public void testReverse() {
        this.assertFunction("REVERSE(ARRAY[1])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1));
        this.assertFunction("REVERSE(ARRAY[1, 2, 3, 4])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)4, (Object)3, (Object)2, (Object)1));
        this.assertFunction("REVERSE(ARRAY_SORT(ARRAY[2, 3, 4, 1]))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)4, (Object)3, (Object)2, (Object)1));
        this.assertFunction("REVERSE(ARRAY[2, BIGINT '3', 4, 1])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)1L, (Object)4L, (Object)3L, (Object)2L));
        this.assertFunction("REVERSE(ARRAY['a', 'b', 'c', 'd'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"d", (Object)"c", (Object)"b", (Object)"a"));
        this.assertFunction("REVERSE(ARRAY[TRUE, FALSE])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)false, (Object)true));
        this.assertFunction("REVERSE(ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)4.4, (Object)3.3, (Object)2.2, (Object)1.1));
        this.assertCachedInstanceHasBoundedRetainedSize("REVERSE(ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0])");
    }

    @Test
    public void testDistinct() {
        this.assertFunction("ARRAY_DISTINCT(ARRAY [])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("ARRAY_DISTINCT(ARRAY [0, NULL])", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(0, null));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [0, NULL, 0, NULL])", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(0, null));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [2, 3, 4, 3, 1, 2, 3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)2, (Object)3, (Object)4, (Object)1));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [0.0E0, NULL])", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(0.0, null));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [2.2E0, 3.3E0, 4.4E0, 3.3E0, 1, 2.2E0, 3.3E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)2.2, (Object)3.3, (Object)4.4, (Object)1.0));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [FALSE, NULL])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(false, null));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [FALSE, TRUE, NULL])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(false, true, null));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [TRUE, TRUE, TRUE])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [TRUE, FALSE, FALSE, TRUE])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [TIMESTAMP '1973-07-08 22:00:01', TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01'])", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("ARRAY_DISTINCT(ARRAY ['2', '3', '2'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"2", (Object)"3"));
        this.assertFunction("ARRAY_DISTINCT(ARRAY ['BB', 'CCC', 'BB'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"BB", (Object)"CCC"));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [ARRAY [1], ARRAY [1, 2], ARRAY [1, 2, 3], ARRAY [1, 2]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [NULL, 2.2E0, 3.3E0, 4.4E0, 3.3E0, 1, 2.2E0, 3.3E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(null, 2.2, 3.3, 4.4, 1.0));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [2, 3, NULL, 4, 3, 1, 2, 3])", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(2, 3, null, 4, 1));
        this.assertFunction("ARRAY_DISTINCT(ARRAY ['BB', 'CCC', 'BB', NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList("BB", "CCC", null));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(new Object[]{null}));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [NULL, NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(new Object[]{null}));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [NULL, NULL, NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(new Object[]{null}));
        this.assertFunction("ARRAY_DISTINCT(ARRAY[(123, 'abc'), (123, NULL)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, null)));
        this.assertFunction("ARRAY_DISTINCT(ARRAY[(NULL, NULL), (42, 'def'), (NULL, 'abc'), (123, NULL), (42, 'def'), (NULL, NULL), (NULL, 'abc'), (123, NULL)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(null, null), Arrays.asList(42, "def"), Arrays.asList(null, "abc"), Arrays.asList(123, null)));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [CAST(5 AS BIGINT), NULL, CAST(12 AS BIGINT), NULL])", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(5L, null, 12L));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [CAST(100 AS BIGINT), NULL, CAST(100 AS BIGINT), NULL, 0, -2, 0])", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(100L, null, 0L, -2L));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [2.3, 2.3, 2.2])", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableList.of((Object)TestArrayOperators.decimal("2.3"), (Object)TestArrayOperators.decimal("2.2")));
        this.assertFunction("ARRAY_DISTINCT(ARRAY [2.330, 1.900, 2.330])", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)4, (int)3)), ImmutableList.of((Object)TestArrayOperators.decimal("2.330"), (Object)TestArrayOperators.decimal("1.900")));
        this.assertCachedInstanceHasBoundedRetainedSize("ARRAY_DISTINCT(ARRAY[2, 3, 4, 1, 2])");
        this.assertCachedInstanceHasBoundedRetainedSize("ARRAY_DISTINCT(ARRAY[CAST(5 AS BIGINT), NULL, CAST(12 AS BIGINT), NULL])");
        this.assertCachedInstanceHasBoundedRetainedSize("ARRAY_DISTINCT(ARRAY[true, true, false, true, false])");
        this.assertCachedInstanceHasBoundedRetainedSize("ARRAY_DISTINCT(ARRAY['cat', 'dog', 'dog', 'coffee', 'apple'])");
    }

    @Test
    public void testSlice() {
        this.assertFunction("SLICE(ARRAY [1, 2, 3, 4, 5], 1, 4)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4));
        this.assertFunction("SLICE(ARRAY [1, 2], 1, 4)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("SLICE(ARRAY [1, 2, 3, 4, 5], 3, 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3, (Object)4));
        this.assertFunction("SLICE(ARRAY ['1', '2', '3', '4'], 2, 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"2"));
        this.assertFunction("SLICE(ARRAY [1, 2, 3, 4], 3, 3)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3, (Object)4));
        this.assertFunction("SLICE(ARRAY [1, 2, 3, 4], -3, 3)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)2, (Object)3, (Object)4));
        this.assertFunction("SLICE(ARRAY [1, 2, 3, 4], -3, 5)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)2, (Object)3, (Object)4));
        this.assertFunction("SLICE(ARRAY [1, 2, 3, 4], 1, 0)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("SLICE(ARRAY [1, 2, 3, 4], -2, 0)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("SLICE(ARRAY [1, 2, 3, 4], -5, 5)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("SLICE(ARRAY [1, 2, 3, 4], -6, 5)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("SLICE(ARRAY [ARRAY [1], ARRAY [2, 3], ARRAY [4, 5, 6]], 1, 2)", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2, (Object)3)));
        this.assertFunction("SLICE(ARRAY [2.3, 2.3, 2.2], 2, 3)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableList.of((Object)TestArrayOperators.decimal("2.3"), (Object)TestArrayOperators.decimal("2.2")));
        this.assertFunction("SLICE(ARRAY [2.330, 1.900, 2.330], 1, 2)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)4, (int)3)), ImmutableList.of((Object)TestArrayOperators.decimal("2.330"), (Object)TestArrayOperators.decimal("1.900")));
        this.assertInvalidFunction("SLICE(ARRAY [1, 2, 3, 4], 1, -1)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("SLICE(ARRAY [1, 2, 3, 4], 0, 1)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testArraysOverlap() {
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [1, 2], ARRAY [2, 3])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [2, 1], ARRAY [2, 3])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [2, 1], ARRAY [3, 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [1, 2], ARRAY [3, 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [1, 3], ARRAY [2, 4])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [3, 1], ARRAY [2, 4])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [3, 1], ARRAY [4, 2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [1, 3], ARRAY [4, 2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [1, 3], ARRAY [2, 3, 4])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [3, 1], ARRAY [5, 4, 1])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(1 AS BIGINT), 2], ARRAY [CAST(2 AS BIGINT), 3])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(2 AS BIGINT), 1], ARRAY [CAST(2 AS BIGINT), 3])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(2 AS BIGINT), 1], ARRAY [CAST(3 AS BIGINT), 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(1 AS BIGINT), 2], ARRAY [CAST(3 AS BIGINT), 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(1 AS BIGINT), 3], ARRAY [CAST(2 AS BIGINT), 4])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(3 AS BIGINT), 1], ARRAY [CAST(2 AS BIGINT), 4])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(3 AS BIGINT), 1], ARRAY [CAST(4 AS BIGINT), 2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(1 AS BIGINT), 3], ARRAY [CAST(4 AS BIGINT), 2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY ['dog', 'cat'], ARRAY ['monkey', 'dog'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY ['dog', 'cat'], ARRAY ['monkey', 'fox'])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [1, 2], ARRAY [NULL, 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [1, 2], ARRAY [2, NULL])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [2, 1], ARRAY [NULL, 3])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [2, 1], ARRAY [3, NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [NULL, 2], ARRAY [1, 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [2, NULL], ARRAY [1, 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [NULL, 3], ARRAY [2, 1])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [3, NULL], ARRAY [2, 1])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(1 AS BIGINT), 2], ARRAY [NULL, CAST(2 AS BIGINT)])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(1 AS BIGINT), 2], ARRAY [CAST(2 AS BIGINT), NULL])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(2 AS BIGINT), 1], ARRAY [CAST(3 AS BIGINT), NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(2 AS BIGINT), 1], ARRAY [NULL, CAST(3 AS BIGINT)])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [NULL, CAST(2 AS BIGINT)], ARRAY [CAST(1 AS BIGINT), 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(2 AS BIGINT), NULL], ARRAY [CAST(1 AS BIGINT), 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [CAST(3 AS BIGINT), NULL], ARRAY [CAST(2 AS BIGINT), 1])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [NULL, CAST(3 AS BIGINT)], ARRAY [CAST(2 AS BIGINT), 1])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY ['dog', 'cat'], ARRAY [NULL, 'dog'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY ['dog', 'cat'], ARRAY ['monkey', NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [NULL, 'dog'], ARRAY ['dog', 'cat'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY ['monkey', NULL], ARRAY ['dog', 'cat'])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [ARRAY [1, 2], ARRAY[3]], ARRAY [ARRAY[4], ARRAY [1, 2]])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [ARRAY [1, 2], ARRAY[3]], ARRAY [ARRAY[4], NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [ARRAY [2], ARRAY[3]], ARRAY [ARRAY[4], ARRAY[1, 2]])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [], ARRAY [])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [], ARRAY [1, 2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [], ARRAY [NULL])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [true], ARRAY [true, false])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [false], ARRAY [true, true])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [true, false], ARRAY [NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAYS_OVERLAP(ARRAY [false], ARRAY [true, NULL])", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testArrayIntersect() {
        this.assertFunction("ARRAY_INTERSECT(ARRAY [5], ARRAY [5])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)5));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [1, 2, 5, 5, 6], ARRAY [5, 5, 6, 6, 7, 8])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)5, (Object)6));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [IF (RAND() < 1.0E0, 7, 1) , 2], ARRAY [7])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)7));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [CAST(5 AS BIGINT), CAST(5 AS BIGINT)], ARRAY [CAST(1 AS BIGINT), CAST(5 AS BIGINT)])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)5L));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [1, 5], ARRAY [1.0E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [1.0E0, 5.0E0], ARRAY [5.0E0, 5.0E0, 6.0E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)5.0));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [8.3E0, 1.6E0, 4.1E0, 5.2E0], ARRAY [4.0E0, 5.2E0, 8.3E0, 9.7E0, 3.5E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)5.2, (Object)8.3));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [5.1E0, 7, 3.0E0, 4.8E0, 10], ARRAY [6.5E0, 10.0E0, 1.9E0, 5.1E0, 3.9E0, 4.8E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)10.0, (Object)5.1, (Object)4.8));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [2.3, 2.3, 2.2], ARRAY[2.2, 2.3])", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableList.of((Object)TestArrayOperators.decimal("2.3"), (Object)TestArrayOperators.decimal("2.2")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [2.330, 1.900, 2.330], ARRAY [2.3300, 1.9000])", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)5, (int)4)), ImmutableList.of((Object)TestArrayOperators.decimal("2.3300"), (Object)TestArrayOperators.decimal("1.9000")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [2, 3], ARRAY[2.0, 3.0])", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)11, (int)1)), ImmutableList.of((Object)TestArrayOperators.decimal("00000000002.0"), (Object)TestArrayOperators.decimal("00000000003.0")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [true], ARRAY [true])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [true, false], ARRAY [true])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [true, true], ARRAY [true, true])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['abc'], ARRAY ['abc', 'bcd'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"abc"));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['abc', 'abc'], ARRAY ['abc', 'abc'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"abc"));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['foo', 'bar', 'baz'], ARRAY ['foo', 'test', 'bar'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), ImmutableList.of((Object)"foo", (Object)"bar"));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [], ARRAY [5])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [5, 6], ARRAY [])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [1], ARRAY [5])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [CAST(1 AS BIGINT)], ARRAY [CAST(5 AS BIGINT)])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [true, true], ARRAY [false])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [], ARRAY [false])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [5], ARRAY [1.0E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['abc'], ARRAY [])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [], ARRAY ['abc', 'bcd'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [], ARRAY [])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [], ARRAY [NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [NULL], ARRAY [NULL, NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(new Object[]{null}));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [0, 0, 1, NULL], ARRAY [0, 0, 1, NULL])", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(0, 1, null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [0, 0], ARRAY [0, 0, NULL])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)0));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [CAST(0 AS BIGINT), CAST(0 AS BIGINT)], ARRAY [CAST(0 AS BIGINT), NULL])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)0L));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [0.0E0], ARRAY [NULL])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [0.0E0, NULL], ARRAY [0.0E0, NULL])", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(0.0, null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [true, true, false, false, NULL], ARRAY [true, false, false, NULL])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(true, false, null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [false, false], ARRAY [false, false, NULL])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)false));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['abc'], ARRAY [NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [''], ARRAY ['', NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)0)), ImmutableList.of((Object)""));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['', NULL], ARRAY ['', NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)0)), Arrays.asList("", null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [NULL], ARRAY ['abc', NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Collections.singletonList(null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY ['abc', NULL, 'xyz', NULL], ARRAY [NULL, 'abc', NULL, NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList("abc", null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY [], ARRAY [NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY [NULL], ARRAY [NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Collections.singletonList(null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 456), (123, 789)], ARRAY[(123, 456), (123, 456), (123, 789)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))), ImmutableList.of(Arrays.asList(123, 456), Arrays.asList(123, 789)));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[ARRAY[123, 456], ARRAY[123, 789]], ARRAY[ARRAY[123, 456], ARRAY[123, 456], ARRAY[123, 789]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of(Arrays.asList(123, 456), Arrays.asList(123, 789)));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc'), (123, 'cde')], ARRAY[(123, 'abc'), (123, 'cde')])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, "cde")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc'), (123, 'cde'), NULL], ARRAY[(123, 'abc'), (123, 'cde')])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, "cde")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc'), (123, 'cde'), NULL, NULL], ARRAY[(123, 'abc'), (123, 'cde'), NULL])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), Arrays.asList(Arrays.asList(123, "abc"), Arrays.asList(123, "cde"), null));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc'), (123, 'abc')], ARRAY[(123, 'abc'), (123, NULL)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc')], ARRAY[(123, NULL)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of());
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 'abc'), (123, NULL)], ARRAY[(123, 'abc'), (123, NULL)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, null)));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(NULL, 'abc'), (123, 'abc')], ARRAY[(123, 'abc'),(NULL, 'abc')])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(null, "abc"), Arrays.asList(123, "abc")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(NULL, 'abc'), (123, 'abc'), (NULL, 'def'), (NULL, 'abc')], ARRAY[(123, 'abc'), (NULL, 'abc'), (123, 'def'), (123, 'abc'), (123, 'abc'), (123, 'abc'), (123, 'abc'), (NULL, 'abc'), (NULL, 'abc'), (NULL, 'abc')])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(null, "abc")));
        this.assertFunction("ARRAY_INTERSECT(ARRAY[(123, 456), (123, NULL), (42, 43)], ARRAY[(123, NULL), (123, 456), (42, NULL), (NULL, 43)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))), ImmutableList.of(Arrays.asList(123, null), Arrays.asList(123, 456)));
        this.assertCachedInstanceHasBoundedRetainedSize("ARRAY_INTERSECT(ARRAY ['foo', 'bar', 'baz'], ARRAY ['foo', 'test', 'bar'])");
    }

    @Test
    public void testArrayUnion() {
        this.assertFunction("ARRAY_UNION(ARRAY [cast(10 as bigint), NULL, cast(12 as bigint), NULL], ARRAY [NULL, cast(10 as bigint), NULL, NULL])", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(10L, null, 12L));
        this.assertFunction("ARRAY_UNION(ARRAY [12], ARRAY [10])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)12, (Object)10));
        this.assertFunction("ARRAY_UNION(ARRAY ['foo', 'bar', 'baz'], ARRAY ['foo', 'test', 'bar'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"test"));
        this.assertFunction("ARRAY_UNION(ARRAY [NULL], ARRAY [NULL, NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(new Object[]{null}));
        this.assertFunction("ARRAY_UNION(ARRAY ['abc', NULL, 'xyz', NULL], ARRAY [NULL, 'abc', NULL, NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList("abc", null, "xyz"));
        this.assertFunction("ARRAY_UNION(ARRAY [1, 5], ARRAY [1])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)5));
        this.assertFunction("ARRAY_UNION(ARRAY [1, 1, 2, 4], ARRAY [1, 1, 4, 4])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)4));
        this.assertFunction("ARRAY_UNION(ARRAY [2, 8], ARRAY [8, 3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)2, (Object)8, (Object)3));
        this.assertFunction("ARRAY_UNION(ARRAY [IF (RAND() < 1.0E0, 7, 1) , 2], ARRAY [7])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)7, (Object)2));
        this.assertFunction("ARRAY_UNION(ARRAY [1, 5], ARRAY [1.0E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)5.0));
        this.assertFunction("ARRAY_UNION(ARRAY [8.3E0, 1.6E0, 4.1E0, 5.2E0], ARRAY [4.0E0, 5.2E0, 8.3E0, 9.7E0, 3.5E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)8.3, (Object)1.6, (Object)4.1, (Object)5.2, (Object)4.0, (Object)9.7, (Object)3.5));
        this.assertFunction("ARRAY_UNION(ARRAY [5.1E0, 7, 3.0E0, 4.8E0, 10], ARRAY [6.5E0, 10.0E0, 1.9E0, 5.1E0, 3.9E0, 4.8E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)5.1, (Object)7.0, (Object)3.0, (Object)4.8, (Object)10.0, (Object)6.5, (Object)1.9, (Object)3.9));
        this.assertFunction("ARRAY_UNION(ARRAY [ARRAY [4, 5], ARRAY [6, 7]], ARRAY [ARRAY [4, 5], ARRAY [6, 8]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)4, (Object)5), (Object)ImmutableList.of((Object)6, (Object)7), (Object)ImmutableList.of((Object)6, (Object)8)));
    }

    @Test
    public void testComparison() {
        this.assertFunction("ARRAY [1, 2, 3] = ARRAY [1, 2, 3]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1, 2, 3] != ARRAY [1, 2, 3]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, FALSE] = ARRAY [TRUE, FALSE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE] != ARRAY [TRUE, FALSE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] = ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] != ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens'] = ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens'] != ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] = ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] != ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [timestamp '2012-10-31 08:00 UTC'] = ARRAY [timestamp '2012-10-31 01:00 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [timestamp '2012-10-31 08:00 UTC'] != ARRAY [timestamp '2012-10-31 01:00 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] = ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] != ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.0, 2.0, 3.0] = ARRAY [1.0, 2.0, 3.0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.0, 2.0, 3.0] = ARRAY [1.0, 2.0, 3.1]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543] = ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543] = ARRAY [1234567890.1234567890, 9876543210.9876543210, 0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.0, 2.0, 3.0] != ARRAY [1.0, 2.0, 3.0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.0, 2.0, 3.0] != ARRAY [1.0, 2.0, 3.1]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543] != ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543] != ARRAY [1234567890.1234567890, 9876543210.9876543210, 0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1, 2, null] = ARRAY [1, null]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['1', '2', null] = ARRAY ['1', null]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.0, 2.0, null] = ARRAY [1.0, null]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.0E0, 2.0E0, null] = ARRAY [1.0E0, null]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1, 2, null] = ARRAY [1, 2, null]", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAY ['1', '2', null] = ARRAY ['1', '2', null]", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAY [1.0, 2.0, null] = ARRAY [1.0, 2.0, null]", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAY [1.0E0, 2.0E0, null] = ARRAY [1.0E0, 2.0E0, null]", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAY [1, 3, null] = ARRAY [1, 2, null]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1E0, 3E0, null] = ARRAY [1E0, 2E0, null]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['1', '3', null] = ARRAY ['1', '2', null]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY[1], ARRAY[null], ARRAY[2]] = ARRAY [ARRAY[1], ARRAY[2], ARRAY[3]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY[1], ARRAY[null], ARRAY[3]] = ARRAY [ARRAY[1], ARRAY[2], ARRAY[3]]", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAY [10, 20, 30] != ARRAY [5]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [10, 20, 30] = ARRAY [5]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1, 2, 3] != ARRAY [3, 2, 1]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1, 2, 3] = ARRAY [3, 2, 1]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, FALSE, TRUE] != ARRAY [TRUE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE, TRUE] = ARRAY [TRUE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, FALSE] != ARRAY [FALSE, FALSE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE] = ARRAY [FALSE, FALSE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] != ARRAY [1.1E0, 2.2E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] = ARRAY [1.1E0, 2.2E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0] != ARRAY [11.1E0, 22.1E0, 1.1E0, 44.1E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0] = ARRAY [11.1E0, 22.1E0, 1.1E0, 44.1E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] != ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] = ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens'] != ARRAY ['z', 'f', 's', 'd', 'g']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens'] = ARRAY ['z', 'f', 's', 'd', 'g']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] != ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] = ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] != ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] = ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] != ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5, 6]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] = ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5, 6]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] != ARRAY [ARRAY [1, 2, 3], ARRAY [4, 5]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] = ARRAY [ARRAY [1, 2, 3], ARRAY [4, 5]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.0, 2.0, 3.0] = ARRAY [1.0, 2.0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.0, 2.0, 3.0] != ARRAY [1.0, 2.0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1, 2, null] != ARRAY [1, 2, null]", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAY [1, 2, null] != ARRAY [1, null]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1, 3, null] != ARRAY [1, 2, null]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY[1], ARRAY[null], ARRAY[2]] != ARRAY [ARRAY[1], ARRAY[2], ARRAY[3]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY[1], ARRAY[null], ARRAY[3]] != ARRAY [ARRAY[1], ARRAY[2], ARRAY[3]]", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("ARRAY [10, 20, 30] < ARRAY [10, 20, 40, 50]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [10, 20, 30] >= ARRAY [10, 20, 40, 50]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [10, 20, 30] < ARRAY [10, 40]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [10, 20, 30] >= ARRAY [10, 40]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [10, 20] < ARRAY [10, 20, 30]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [10, 20] >= ARRAY [10, 20, 30]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, FALSE] < ARRAY [TRUE, TRUE, TRUE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE] >= ARRAY [TRUE, TRUE, TRUE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, FALSE, FALSE] < ARRAY [TRUE, TRUE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE, FALSE] >= ARRAY [TRUE, TRUE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, FALSE] < ARRAY [TRUE, FALSE, FALSE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE] >= ARRAY [TRUE, FALSE, FALSE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] < ARRAY [1.1E0, 2.2E0, 4.4E0, 4.4E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] >= ARRAY [1.1E0, 2.2E0, 4.4E0, 4.4E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] < ARRAY [1.1E0, 2.2E0, 5.5E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] >= ARRAY [1.1E0, 2.2E0, 5.5E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0] < ARRAY [1.1E0, 2.2E0, 5.5E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0] >= ARRAY [1.1E0, 2.2E0, 5.5E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] < ARRAY ['puppies', 'lizards', 'lizards']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] >= ARRAY ['puppies', 'lizards', 'lizards']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] < ARRAY ['puppies', 'lizards']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] >= ARRAY ['puppies', 'lizards']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens'] < ARRAY ['puppies', 'kittens', 'lizards']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens'] >= ARRAY ['puppies', 'kittens', 'lizards']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] < ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] >= ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] < ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] >= ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] < ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] >= ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] < ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5, 6]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] >= ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5, 6]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] < ARRAY [ARRAY [1, 2], ARRAY [3, 5, 6]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] >= ARRAY [ARRAY [1, 2], ARRAY [3, 5, 6]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.0, 2.0, 3.0] > ARRAY [1.0, 2.0, 3.0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.0, 2.0, 3.0] >= ARRAY [1.0, 2.0, 3.0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.0, 2.0, 3.0] < ARRAY [1.0, 2.0, 3.1]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.0, 2.0, 3.0] <= ARRAY [1.0, 2.0, 3.1]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543] > ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543] >= ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543] < ARRAY [1234567890.1234567890, 9876543210.9876543210, 0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1234567890.1234567890, 9876543210.9876543210] < ARRAY [1234567890.1234567890, 9876543210.9876543210, 0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1234567890.1234567890, 0] < ARRAY [1234567890.1234567890, 9876543210.9876543210, 0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543] <= ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [10, 20, 30] > ARRAY [10, 20, 20]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [10, 20, 30] <= ARRAY [10, 20, 20]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [10, 20, 30] > ARRAY [10, 20]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [10, 20, 30] <= ARRAY [10, 20]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, TRUE, TRUE] > ARRAY [TRUE, TRUE, FALSE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, TRUE, TRUE] <= ARRAY [TRUE, TRUE, FALSE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, TRUE, FALSE] > ARRAY [TRUE, TRUE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, TRUE, FALSE] <= ARRAY [TRUE, TRUE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] > ARRAY [1.1E0, 2.2E0, 2.2E0, 4.4E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] <= ARRAY [1.1E0, 2.2E0, 2.2E0, 4.4E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] > ARRAY [1.1E0, 2.2E0, 3.3E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] <= ARRAY [1.1E0, 2.2E0, 3.3E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] > ARRAY ['puppies', 'kittens', 'kittens']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] <= ARRAY ['puppies', 'kittens', 'kittens']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] > ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] <= ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] > ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] <= ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] > ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:20.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] <= ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:20.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] > ARRAY [ARRAY [1, 2], ARRAY [3, 4]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] <= ARRAY [ARRAY [1, 2], ARRAY [3, 4]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] > ARRAY [ARRAY [1, 2], ARRAY [3, 3, 4]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] <= ARRAY [ARRAY [1, 2], ARRAY [3, 3, 4]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [10, 20, 30] <= ARRAY [50]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [10, 20, 30] > ARRAY [50]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [10, 20, 30] <= ARRAY [10, 20, 30]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [10, 20, 30] > ARRAY [10, 20, 30]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, FALSE] <= ARRAY [TRUE, FALSE, true]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE] > ARRAY [TRUE, FALSE, true]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, FALSE] <= ARRAY [TRUE, FALSE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE] > ARRAY [TRUE, FALSE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] <= ARRAY [2.2E0, 5.5E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] > ARRAY [2.2E0, 5.5E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] <= ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] > ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] <= ARRAY ['puppies', 'lizards']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] > ARRAY ['puppies', 'lizards']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens'] <= ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens'] > ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] <= ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] > ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] <= ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] > ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] <= ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] > ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] <= ARRAY [ARRAY [1, 2], ARRAY [3, 5, 6]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] > ARRAY [ARRAY [1, 2], ARRAY [3, 5, 6]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [10, 20, 30] >= ARRAY [10, 20, 30]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [10, 20, 30] < ARRAY [10, 20, 30]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, FALSE, TRUE] >= ARRAY [TRUE, FALSE, TRUE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE, TRUE] < ARRAY [TRUE, FALSE, TRUE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, FALSE, TRUE] >= ARRAY [TRUE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE, TRUE] < ARRAY [TRUE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] >= ARRAY [1.1E0, 2.2E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] < ARRAY [1.1E0, 2.2E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] >= ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0] < ARRAY [1.1E0, 2.2E0, 3.3E0, 4.4E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] >= ARRAY ['puppies', 'kittens', 'kittens']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens', 'lizards'] < ARRAY ['puppies', 'kittens', 'kittens']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', 'kittens'] >= ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens'] < ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] >= ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] < ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] >= ARRAY [ARRAY [1, 2], ARRAY [3, 4]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] < ARRAY [ARRAY [1, 2], ARRAY [3, 4]]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] >= ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]] < ARRAY [ARRAY [1, 2], ARRAY [3, 4, 5]]", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testDistinctFrom() {
        this.assertFunction("CAST(NULL AS ARRAY(UNKNOWN)) IS DISTINCT FROM CAST(NULL AS ARRAY(UNKNOWN))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [NULL] IS DISTINCT FROM ARRAY [NULL]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("NULL IS DISTINCT FROM ARRAY [1, 2]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1, 2] IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1, 2] IS DISTINCT FROM ARRAY [1, 2]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1, 2, 3] IS DISTINCT FROM ARRAY [1, 2]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1, 2] IS DISTINCT FROM ARRAY [1, NULL]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1, 2] IS DISTINCT FROM ARRAY [1, 3]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1, NULL] IS DISTINCT FROM ARRAY [1, NULL]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1, NULL] IS DISTINCT FROM ARRAY [1, NULL]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1, 2, NULL] IS DISTINCT FROM ARRAY [1, 2]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [TRUE, FALSE] IS DISTINCT FROM ARRAY [TRUE, FALSE]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [TRUE, NULL] IS DISTINCT FROM ARRAY [TRUE, FALSE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [FALSE, NULL] IS DISTINCT FROM ARRAY [NULL, FALSE]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', 'kittens'] IS DISTINCT FROM ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY ['puppies', NULL] IS DISTINCT FROM ARRAY ['puppies', 'kittens']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY ['puppies', NULL] IS DISTINCT FROM ARRAY [NULL, 'kittens']", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY ['puppies'], ARRAY ['kittens']] IS DISTINCT FROM ARRAY [ARRAY ['puppies'], ARRAY ['kittens']]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [ARRAY ['puppies'], NULL] IS DISTINCT FROM ARRAY [ARRAY ['puppies'], ARRAY ['kittens']]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [ARRAY ['puppies'], NULL] IS DISTINCT FROM ARRAY [NULL, ARRAY ['kittens']]", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testArrayRemove() {
        this.assertFunction("ARRAY_REMOVE(ARRAY ['foo', 'bar', 'baz'], 'foo')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"bar", (Object)"baz"));
        this.assertFunction("ARRAY_REMOVE(ARRAY ['foo', 'bar', 'baz'], 'bar')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"foo", (Object)"baz"));
        this.assertFunction("ARRAY_REMOVE(ARRAY ['foo', 'bar', 'baz'], 'baz')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"foo", (Object)"bar"));
        this.assertFunction("ARRAY_REMOVE(ARRAY ['foo', 'bar', 'baz'], 'zzz')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz"));
        this.assertFunction("ARRAY_REMOVE(ARRAY ['foo', 'foo', 'foo'], 'foo')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of());
        this.assertFunction("ARRAY_REMOVE(ARRAY [NULL, 'bar', 'baz'], 'foo')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList(null, "bar", "baz"));
        this.assertFunction("ARRAY_REMOVE(ARRAY ['foo', 'bar', NULL], 'foo')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList("bar", null));
        this.assertFunction("ARRAY_REMOVE(ARRAY [1, 2, 3], 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)2, (Object)3));
        this.assertFunction("ARRAY_REMOVE(ARRAY [1, 2, 3], 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)3));
        this.assertFunction("ARRAY_REMOVE(ARRAY [1, 2, 3], 3)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("ARRAY_REMOVE(ARRAY [1, 2, 3], 4)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("ARRAY_REMOVE(ARRAY [1, 1, 1], 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("ARRAY_REMOVE(ARRAY [NULL, 2, 3], 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(null, 2, 3));
        this.assertFunction("ARRAY_REMOVE(ARRAY [1, NULL, 3], 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(null, 3));
        this.assertFunction("ARRAY_REMOVE(ARRAY [-1.23E0, 3.14E0], 3.14E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)-1.23));
        this.assertFunction("ARRAY_REMOVE(ARRAY [3.14E0], 0.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)3.14));
        this.assertFunction("ARRAY_REMOVE(ARRAY [sqrt(-1), 3.14E0], 3.14E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)Double.NaN));
        this.assertFunction("ARRAY_REMOVE(ARRAY [-1.23E0, sqrt(-1)], nan())", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)-1.23, (Object)Double.NaN));
        this.assertFunction("ARRAY_REMOVE(ARRAY [-1.23E0, nan()], nan())", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)-1.23, (Object)Double.NaN));
        this.assertFunction("ARRAY_REMOVE(ARRAY [-1.23E0, infinity()], -1.23E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)Double.POSITIVE_INFINITY));
        this.assertFunction("ARRAY_REMOVE(ARRAY [infinity(), 3.14E0], infinity())", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)3.14));
        this.assertFunction("ARRAY_REMOVE(ARRAY [-1.23E0, NULL, 3.14E0], 3.14E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(-1.23, null));
        this.assertFunction("ARRAY_REMOVE(ARRAY [TRUE, FALSE, TRUE], TRUE)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)false));
        this.assertFunction("ARRAY_REMOVE(ARRAY [TRUE, FALSE, TRUE], FALSE)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)true));
        this.assertFunction("ARRAY_REMOVE(ARRAY [NULL, FALSE, TRUE], TRUE)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(null, false));
        this.assertFunction("ARRAY_REMOVE(ARRAY [ARRAY ['foo'], ARRAY ['bar'], ARRAY ['baz']], ARRAY ['bar'])", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"foo"), (Object)ImmutableList.of((Object)"baz")));
        this.assertFunction("ARRAY_REMOVE(ARRAY [1.0, 2.0, 3.0], 2.0)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableList.of((Object)TestArrayOperators.decimal("1.0"), (Object)TestArrayOperators.decimal("3.0")));
        this.assertFunction("ARRAY_REMOVE(ARRAY [1.0, 2.0, 3.0], 4.0)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableList.of((Object)TestArrayOperators.decimal("1.0"), (Object)TestArrayOperators.decimal("2.0"), (Object)TestArrayOperators.decimal("3.0")));
        this.assertFunction("ARRAY_REMOVE(ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543], 1234567890.1234567890)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)22, (int)10)), ImmutableList.of((Object)TestArrayOperators.decimal("9876543210.9876543210"), (Object)TestArrayOperators.decimal("123123123456.6549876543")));
        this.assertFunction("ARRAY_REMOVE(ARRAY [1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543], 4.0)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)22, (int)10)), ImmutableList.of((Object)TestArrayOperators.decimal("1234567890.1234567890"), (Object)TestArrayOperators.decimal("9876543210.9876543210"), (Object)TestArrayOperators.decimal("123123123456.6549876543")));
        this.assertCachedInstanceHasBoundedRetainedSize("ARRAY_REMOVE(ARRAY ['foo', 'bar', 'baz'], 'foo')");
        this.assertInvalidFunction("ARRAY_REMOVE(ARRAY [ARRAY[CAST(null AS BIGINT)]], ARRAY[CAST(1 AS BIGINT)])", (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertInvalidFunction("ARRAY_REMOVE(ARRAY [ARRAY[CAST(null AS BIGINT)]], ARRAY[CAST(null AS BIGINT)])", (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertInvalidFunction("ARRAY_REMOVE(ARRAY [ARRAY[CAST(1 AS BIGINT)]], ARRAY[CAST(null AS BIGINT)])", (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testRepeat() {
        this.assertFunction("REPEAT(1, 5)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)1, (Object)1, (Object)1, (Object)1));
        this.assertFunction("REPEAT('varchar', 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"varchar", (Object)"varchar", (Object)"varchar"));
        this.assertFunction("REPEAT(true, 1)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("REPEAT(0.5E0, 4)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)0.5, (Object)0.5, (Object)0.5, (Object)0.5));
        this.assertFunction("REPEAT(array[1], 4)", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)1)));
        this.assertFunction("REPEAT(null, 4)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(null, null, null, null));
        this.assertFunction("REPEAT(cast(null as bigint), 4)", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(null, null, null, null));
        this.assertFunction("REPEAT(cast(null as double), 4)", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(null, null, null, null));
        this.assertFunction("REPEAT(cast(null as varchar), 4)", (Type)new ArrayType((Type)VarcharType.VARCHAR), Arrays.asList(null, null, null, null));
        this.assertFunction("REPEAT(cast(null as boolean), 4)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(null, null, null, null));
        this.assertFunction("REPEAT(cast(null as array(boolean)), 4)", (Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN)), Arrays.asList(null, null, null, null));
        this.assertFunction("REPEAT(cast(null as bigint), 0)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of());
        this.assertFunction("REPEAT(1, 0)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("REPEAT('varchar', 0)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of());
        this.assertFunction("REPEAT(true, 0)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of());
        this.assertFunction("REPEAT(0.5E0, 0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of());
        this.assertFunction("REPEAT(array[1], 0)", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of());
        this.assertInvalidFunction("REPEAT(2, -1)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REPEAT(1, 1000000)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REPEAT('loooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooongvarchar', 9999)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REPEAT(array[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20], 9999)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as array(bigint))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[1,2,3]", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "array[1,2,3,null]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array['test1', 'test2', 'test3', 'test4']", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "array['test1', 'test2', 'test3', null]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array['test1', null, 'test2', 'test3']", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[null, 'test1', 'test2', 'test3']", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[null, time '12:34:56', time '01:23:45']", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[null, timestamp '2016-01-02 12:34:56', timestamp '2016-12-23 01:23:45']", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[null]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[null, null, null]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[row(1), row(2), row(3)]", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "array[cast(row(1) as row(a bigint)), cast(null as row(a bigint)), cast(row(3) as row(a bigint))]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[cast(row(1) as row(a bigint)), cast(row(null) as row(a bigint)), cast(row(3) as row(a bigint))]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[map(array[2], array[-2]), map(array[1], array[-1])]", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "array[map(array[2], array[-2]), null]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[map(array[2], array[-2]), map(array[1], array[null])]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[array[1], array[2], array[3]]", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "array[array[1], array[null], array[3]]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[array[1], array[2], null]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[1E0, 2E0, null]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[1E0, 2E0, 3E0]", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "array[true, false, null]", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "array[true, false, true]", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testSequence() throws ParseException {
        this.assertFunction("SEQUENCE(1, 5)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L, (Object)5L));
        this.assertFunction("SEQUENCE(-10, -5)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)-10L, (Object)-9L, (Object)-8L, (Object)-7L, (Object)-6L, (Object)-5L));
        this.assertFunction("SEQUENCE(-5, 2)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)-5L, (Object)-4L, (Object)-3L, (Object)-2L, (Object)-1L, (Object)0L, (Object)1L, (Object)2L));
        this.assertFunction("SEQUENCE(2, 2)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)2L));
        this.assertFunction("SEQUENCE(date '2016-04-12', date '2016-04-14')", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-04-12"), (Object)TestArrayOperators.sqlDate("2016-04-13"), (Object)TestArrayOperators.sqlDate("2016-04-14")));
        this.assertFunction("SEQUENCE(5, 1)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)5L, (Object)4L, (Object)3L, (Object)2L, (Object)1L));
        this.assertFunction("SEQUENCE(-5, -10)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)-5L, (Object)-6L, (Object)-7L, (Object)-8L, (Object)-9L, (Object)-10L));
        this.assertFunction("SEQUENCE(2, -5)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)2L, (Object)1L, (Object)0L, (Object)-1L, (Object)-2L, (Object)-3L, (Object)-4L, (Object)-5L));
        this.assertFunction("SEQUENCE(date '2016-04-14', date '2016-04-12')", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-04-14"), (Object)TestArrayOperators.sqlDate("2016-04-13"), (Object)TestArrayOperators.sqlDate("2016-04-12")));
        this.assertFunction("SEQUENCE(1, 9, 4)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)1L, (Object)5L, (Object)9L));
        this.assertFunction("SEQUENCE(-10, -5, 2)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)-10L, (Object)-8L, (Object)-6L));
        this.assertFunction("SEQUENCE(-5, 2, 3)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)-5L, (Object)-2L, (Object)1L));
        this.assertFunction("SEQUENCE(2, 2, 2)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)2L));
        this.assertFunction("SEQUENCE(5, 1, -1)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)5L, (Object)4L, (Object)3L, (Object)2L, (Object)1L));
        this.assertFunction("SEQUENCE(10, 2, -2)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)10L, (Object)8L, (Object)6L, (Object)4L, (Object)2L));
        this.assertInvalidFunction("SEQUENCE(2, -1, 1)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        this.assertInvalidFunction("SEQUENCE(-1, -10, 1)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        this.assertInvalidFunction("SEQUENCE(1, 1000000)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "result of sequence function must not have more than 10000 entries");
        this.assertInvalidFunction("SEQUENCE(date '2000-04-14', date '2030-04-12')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "result of sequence function must not have more than 10000 entries");
    }

    @Test
    public void testSequenceDateTimeDayToSecond() throws ParseException {
        this.assertFunction("SEQUENCE(date '2016-04-12', date '2016-04-14', interval '1' day)", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-04-12"), (Object)TestArrayOperators.sqlDate("2016-04-13"), (Object)TestArrayOperators.sqlDate("2016-04-14")));
        this.assertFunction("SEQUENCE(date '2016-04-14', date '2016-04-12', interval '-1' day)", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-04-14"), (Object)TestArrayOperators.sqlDate("2016-04-13"), (Object)TestArrayOperators.sqlDate("2016-04-12")));
        this.assertFunction("SEQUENCE(date '2016-04-12', date '2016-04-16', interval '2' day)", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-04-12"), (Object)TestArrayOperators.sqlDate("2016-04-14"), (Object)TestArrayOperators.sqlDate("2016-04-16")));
        this.assertFunction("SEQUENCE(date '2016-04-16', date '2016-04-12', interval '-2' day)", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-04-16"), (Object)TestArrayOperators.sqlDate("2016-04-14"), (Object)TestArrayOperators.sqlDate("2016-04-12")));
        this.assertFunction("SEQUENCE(timestamp '2016-04-16 01:00:10', timestamp '2016-04-16 01:07:00', interval '3' minute)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)3, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)6, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("SEQUENCE(timestamp '2016-04-16 01:10:10', timestamp '2016-04-16 01:03:00', interval '-3' minute)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)10, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)7, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)4, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("SEQUENCE(timestamp '2016-04-16 01:00:10', timestamp '2016-04-16 01:01:00', interval '20' second)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)0, (int)30, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)0, (int)50, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("SEQUENCE(timestamp '2016-04-16 01:01:10', timestamp '2016-04-16 01:00:20', interval '-20' second)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)1, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)0, (int)50, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)0, (int)30, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("SEQUENCE(timestamp '2016-04-16 01:00:10', timestamp '2016-04-18 01:01:00', interval '19' hour)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)20, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)17, (int)15, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("SEQUENCE(timestamp '2016-04-16 01:00:10', timestamp '2016-04-14 01:00:20', interval '-19' hour)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)15, (int)6, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)14, (int)11, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertInvalidFunction("SEQUENCE(date '2016-04-12', date '2016-04-14', interval '-1' day)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        this.assertInvalidFunction("SEQUENCE(date '2016-04-14', date '2016-04-12', interval '1' day)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        this.assertInvalidFunction("SEQUENCE(date '2000-04-14', date '2030-04-12', interval '1' day)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "result of sequence function must not have more than 10000 entries");
        this.assertInvalidFunction("SEQUENCE(date '2018-01-01', date '2018-01-04', interval '18' hour)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence step must be a day interval if start and end values are dates");
        this.assertInvalidFunction("SEQUENCE(timestamp '2016-04-16 01:00:10', timestamp '2016-04-16 01:01:00', interval '-20' second)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        this.assertInvalidFunction("SEQUENCE(timestamp '2016-04-16 01:10:10', timestamp '2016-04-16 01:01:00', interval '20' second)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        this.assertInvalidFunction("SEQUENCE(timestamp '2016-04-16 01:00:10', timestamp '2016-04-16 09:01:00', interval '1' second)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "result of sequence function must not have more than 10000 entries");
    }

    @Test
    public void testSequenceDateTimeYearToMonth() throws ParseException {
        this.assertFunction("SEQUENCE(date '2016-04-12', date '2016-06-12', interval '1' month)", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-04-12"), (Object)TestArrayOperators.sqlDate("2016-05-12"), (Object)TestArrayOperators.sqlDate("2016-06-12")));
        this.assertFunction("SEQUENCE(date '2016-06-12', date '2016-04-12', interval '-1' month)", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-06-12"), (Object)TestArrayOperators.sqlDate("2016-05-12"), (Object)TestArrayOperators.sqlDate("2016-04-12")));
        this.assertFunction("SEQUENCE(date '2016-04-12', date '2016-08-12', interval '2' month)", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-04-12"), (Object)TestArrayOperators.sqlDate("2016-06-12"), (Object)TestArrayOperators.sqlDate("2016-08-12")));
        this.assertFunction("SEQUENCE(date '2016-08-12', date '2016-04-12', interval '-2' month)", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-08-12"), (Object)TestArrayOperators.sqlDate("2016-06-12"), (Object)TestArrayOperators.sqlDate("2016-04-12")));
        this.assertFunction("SEQUENCE(date '2016-04-12', date '2018-04-12', interval '1' year)", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2016-04-12"), (Object)TestArrayOperators.sqlDate("2017-04-12"), (Object)TestArrayOperators.sqlDate("2018-04-12")));
        this.assertFunction("SEQUENCE(date '2018-04-12', date '2016-04-12', interval '-1' year)", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)TestArrayOperators.sqlDate("2018-04-12"), (Object)TestArrayOperators.sqlDate("2017-04-12"), (Object)TestArrayOperators.sqlDate("2016-04-12")));
        this.assertFunction("SEQUENCE(timestamp '2016-04-16 01:00:10', timestamp '2016-09-16 01:10:00', interval '2' month)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)6, (int)16, (int)1, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)8, (int)16, (int)1, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("SEQUENCE(timestamp '2016-09-16 01:10:10', timestamp '2016-04-16 01:00:00', interval '-2' month)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)9, (int)16, (int)1, (int)10, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)7, (int)16, (int)1, (int)10, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)5, (int)16, (int)1, (int)10, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("SEQUENCE(timestamp '2016-04-16 01:00:10', timestamp '2021-04-16 01:01:00', interval '2' year)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2018, (int)4, (int)16, (int)1, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2020, (int)4, (int)16, (int)1, (int)0, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertFunction("SEQUENCE(timestamp '2016-04-16 01:01:10', timestamp '2011-04-16 01:00:00', interval '-2' year)", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2016, (int)4, (int)16, (int)1, (int)1, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2014, (int)4, (int)16, (int)1, (int)1, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2012, (int)4, (int)16, (int)1, (int)1, (int)10, (int)0, (Session)SessionTestUtils.TEST_SESSION)));
        this.assertInvalidFunction("SEQUENCE(date '2016-06-12', date '2016-04-12', interval '1' month)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        this.assertInvalidFunction("SEQUENCE(date '2016-04-12', date '2016-06-12', interval '-1' month)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        this.assertInvalidFunction("SEQUENCE(date '2000-04-12', date '3000-06-12', interval '1' month)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "result of sequence function must not have more than 10000 entries");
        this.assertInvalidFunction("SEQUENCE(timestamp '2016-05-16 01:00:10', timestamp '2016-04-16 01:01:00', interval '1' month)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        this.assertInvalidFunction("SEQUENCE(timestamp '2016-04-16 01:10:10', timestamp '2016-05-16 01:01:00', interval '-1' month)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        this.assertInvalidFunction("SEQUENCE(timestamp '2016-04-16 01:00:10', timestamp '3000-04-16 09:01:00', interval '1' month)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "result of sequence function must not have more than 10000 entries");
    }

    @Test
    public void testFlatten() {
        this.assertFunction("flatten(ARRAY [ARRAY [TRUE, FALSE], ARRAY [FALSE]])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false, (Object)false));
        this.assertFunction("flatten(ARRAY [ARRAY [TRUE, FALSE], NULL])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("flatten(ARRAY [ARRAY [TRUE, FALSE]])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("flatten(ARRAY [NULL, ARRAY [TRUE, FALSE]])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("flatten(ARRAY [ARRAY [TRUE], ARRAY [FALSE], ARRAY [TRUE, FALSE]])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false, (Object)true, (Object)false));
        this.assertFunction("flatten(ARRAY [NULL, ARRAY [TRUE], NULL, ARRAY [FALSE], ARRAY [FALSE, TRUE]])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false, (Object)false, (Object)true));
        this.assertFunction("flatten(ARRAY [ARRAY ['1', '2'], ARRAY ['3']])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        this.assertFunction("flatten(ARRAY [ARRAY ['1', '2'], NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"1", (Object)"2"));
        this.assertFunction("flatten(ARRAY [NULL, ARRAY ['1', '2']])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"1", (Object)"2"));
        this.assertFunction("flatten(ARRAY [ARRAY ['0'], ARRAY ['1'], ARRAY ['2', '3']])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3"));
        this.assertFunction("flatten(ARRAY [NULL, ARRAY ['0'], NULL, ARRAY ['1'], ARRAY ['2', '3']])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3"));
        this.assertFunction("flatten(ARRAY [ARRAY [1, 2], ARRAY [3]])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("flatten(ARRAY [ARRAY [1, 2], NULL])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("flatten(ARRAY [NULL, ARRAY [1, 2]])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("flatten(ARRAY [ARRAY [0], ARRAY [1], ARRAY [2, 3]])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3));
        this.assertFunction("flatten(ARRAY [NULL, ARRAY [0], NULL, ARRAY [1], ARRAY [2, 3]])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3));
        this.assertFunction("flatten(ARRAY [ARRAY [1.2E0, 2.2E0], ARRAY [3.2E0]])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.2, (Object)2.2, (Object)3.2));
        this.assertFunction("flatten(ARRAY [ARRAY [1.2E0, 2.2E0], NULL])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.2, (Object)2.2));
        this.assertFunction("flatten(ARRAY [NULL, ARRAY [1.2E0, 2.2E0]])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.2, (Object)2.2));
        this.assertFunction("flatten(ARRAY [ARRAY[0.2E0], ARRAY [1.2E0], ARRAY [2.2E0, 3.2E0]])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)0.2, (Object)1.2, (Object)2.2, (Object)3.2));
        this.assertFunction("flatten(ARRAY [NULL, ARRAY [0.2E0], NULL, ARRAY [1.2E0], ARRAY [2.2E0, 3.2E0]])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)0.2, (Object)1.2, (Object)2.2, (Object)3.2));
        this.assertFunction("flatten(ARRAY [ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [ARRAY [5, 6], ARRAY [7, 8]]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)5, (Object)6), (Object)ImmutableList.of((Object)7, (Object)8)));
        this.assertFunction("flatten(ARRAY [ARRAY [ARRAY [1, 2], ARRAY [3, 4]], NULL])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3, (Object)4)));
        this.assertFunction("flatten(ARRAY [NULL, ARRAY [ARRAY [5, 6], ARRAY [7, 8]]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)5, (Object)6), (Object)ImmutableList.of((Object)7, (Object)8)));
        this.assertFunction("flatten(ARRAY [ARRAY [MAP (ARRAY [1, 2], ARRAY [1, 2])], ARRAY [MAP (ARRAY [3, 4], ARRAY [3, 4])]])", (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)2), (Object)ImmutableMap.of((Object)3, (Object)3, (Object)4, (Object)4)));
        this.assertFunction("flatten(ARRAY [ARRAY [MAP (ARRAY [1, 2], ARRAY [1, 2])], NULL])", (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)2)));
        this.assertFunction("flatten(ARRAY [NULL, ARRAY [MAP (ARRAY [3, 4], ARRAY [3, 4])]])", (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableMap.of((Object)3, (Object)3, (Object)4, (Object)4)));
    }

    @Test
    public void testArrayHashOperator() {
        this.assertArrayHashOperator("ARRAY[1, 2]", (Type)IntegerType.INTEGER, (List<Object>)ImmutableList.of((Object)1, (Object)2));
        this.assertArrayHashOperator("ARRAY[true, false]", (Type)BooleanType.BOOLEAN, (List<Object>)ImmutableList.of((Object)true, (Object)false));
        this.assertArrayHashOperator("ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']", (Type)TimestampType.createTimestampType((int)9), (List<Object>)ImmutableList.of((Object)Timestamps.parseLegacyTimestamp((int)9, (TimeZoneKey)SessionTestUtils.TEST_SESSION.getTimeZoneKey(), (String)"2020-05-10 12:34:56.123456789"), (Object)Timestamps.parseLegacyTimestamp((int)9, (TimeZoneKey)SessionTestUtils.TEST_SESSION.getTimeZoneKey(), (String)"1111-05-10 12:34:56.123456789")));
        MapType mapType = StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER);
        this.assertArrayHashOperator("ARRAY[MAP(ARRAY[1], ARRAY[2])]", (Type)mapType, (List<Object>)ImmutableList.of((Object)StructuralTestUtil.mapBlockOf((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, ImmutableMap.of((Object)1L, (Object)2L))));
    }

    private void assertArrayHashOperator(String inputArray, Type elementType, List<Object> elements) {
        ArrayType arrayType = new ArrayType(elementType);
        BlockBuilder arrayArrayBuilder = arrayType.createBlockBuilder(null, 1);
        BlockBuilder arrayBuilder = elementType.createBlockBuilder(null, elements.size());
        for (Object element : elements) {
            StructuralTestUtil.appendToBlockBuilder(elementType, element, arrayBuilder);
        }
        arrayType.writeObject(arrayArrayBuilder, (Object)arrayBuilder.build());
        this.assertOperator(OperatorType.HASH_CODE, inputArray, (Type)BigintType.BIGINT, arrayType.hash(arrayArrayBuilder.build(), 0));
    }

    private static SqlDate sqlDate(String dateString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return new SqlDate(Math.toIntExact(TimeUnit.MILLISECONDS.toDays(dateFormat.parse(dateString).getTime())));
    }
}

