/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.type.AbstractTestType;
import io.prestosql.util.StructuralTestUtil;
import java.util.List;

public class TestBigintArrayType
extends AbstractTestType {
    public TestBigintArrayType() {
        this((Metadata)MetadataManager.createTestMetadataManager());
    }

    private TestBigintArrayType(Metadata metadata) {
        super(metadata.getType(TypeSignature.arrayType((TypeSignature)BigintType.BIGINT.getTypeSignature())), List.class, TestBigintArrayType.createTestBlock(metadata.getType(TypeSignature.arrayType((TypeSignature)BigintType.BIGINT.getTypeSignature()))));
    }

    public static Block createTestBlock(Type arrayType) {
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 4);
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 1, 2));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 100, 200, 300));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Block block = (Block)value;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            BigintType.BIGINT.appendTo(block, i, blockBuilder);
        }
        BigintType.BIGINT.writeLong(blockBuilder, 1L);
        return blockBuilder.build();
    }
}

