/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestBooleanOperators
extends AbstractTestFunctions {
    @Test
    public void testLiteral() {
        this.assertFunction("true", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("false", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testTypeConstructor() {
        this.assertFunction("BOOLEAN 'true'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("BOOLEAN 'false'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testEqual() {
        this.assertFunction("true = true", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("true = false", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("false = true", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("false = false", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("true <> true", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("true <> false", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("false <> true", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("false <> false", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("true < true", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("true < false", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("false < true", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("false < false", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("true <= true", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("true <= false", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("false <= true", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("false <= false", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("true > true", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("true > false", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("false > true", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("false > false", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("true >= true", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("true >= false", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("false >= true", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("false >= false", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testBetween() {
        this.assertFunction("true BETWEEN true AND true", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("true BETWEEN true AND false", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("true BETWEEN false AND true", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("true BETWEEN false AND false", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("false BETWEEN true AND true", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("false BETWEEN true AND false", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("false BETWEEN false AND true", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("false BETWEEN false AND false", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testCastToReal() {
        this.assertFunction("cast(true as real)", (Type)RealType.REAL, Float.valueOf(1.0f));
        this.assertFunction("cast(false as real)", (Type)RealType.REAL, Float.valueOf(0.0f));
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("cast(true as varchar)", (Type)VarcharType.VARCHAR, "true");
        this.assertFunction("cast(false as varchar)", (Type)VarcharType.VARCHAR, "false");
    }

    @Test
    public void testCastFromVarchar() {
        this.assertFunction("cast('true' as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('false' as boolean)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS BOOLEAN) IS DISTINCT FROM CAST(NULL AS BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("FALSE IS DISTINCT FROM FALSE", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TRUE IS DISTINCT FROM TRUE", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("FALSE IS DISTINCT FROM TRUE", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TRUE IS DISTINCT FROM FALSE", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("FALSE IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TRUE IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null AS BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "true", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "false", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "true AND false", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "true OR false", (Type)BooleanType.BOOLEAN, false);
    }
}

