/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.operator.scalar.CharacterStringCasts;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCharacterStringCasts
extends AbstractTestFunctions {
    @Test
    public void testVarcharToVarcharCast() {
        this.assertFunction("cast('bar' as varchar(20))", (Type)VarcharType.createVarcharType((int)20), "bar");
        this.assertFunction("cast(cast('bar' as varchar(20)) as varchar(30))", (Type)VarcharType.createVarcharType((int)30), "bar");
        this.assertFunction("cast(cast('bar' as varchar(20)) as varchar)", (Type)VarcharType.VARCHAR, "bar");
        this.assertFunction("cast('banana' as varchar(3))", (Type)VarcharType.createVarcharType((int)3), "ban");
        this.assertFunction("cast(cast('banana' as varchar(20)) as varchar(3))", (Type)VarcharType.createVarcharType((int)3), "ban");
    }

    @Test
    public void testVarcharToCharCast() {
        this.assertFunction("cast('bar  ' as char(10))", (Type)CharType.createCharType((long)10L), "bar       ");
        this.assertFunction("cast('bar' as char)", (Type)CharType.createCharType((long)1L), "b");
        this.assertFunction("cast('   ' as char)", (Type)CharType.createCharType((long)1L), " ");
    }

    @Test
    public void testCharToVarcharCast() {
        this.assertFunction("cast(cast('bar' as char(5)) as varchar(10))", (Type)VarcharType.createVarcharType((int)10), "bar  ");
        this.assertFunction("cast(cast('bar' as char(5)) as varchar(1))", (Type)VarcharType.createVarcharType((int)1), "b");
        this.assertFunction("cast(cast('b' as char(5)) as varchar(2))", (Type)VarcharType.createVarcharType((int)2), "b ");
        this.assertFunction("cast(cast('b' as char(5)) as varchar(1))", (Type)VarcharType.createVarcharType((int)1), "b");
        this.assertFunction("cast(cast('bar' as char(3)) as varchar(3))", (Type)VarcharType.createVarcharType((int)3), "bar");
        this.assertFunction("cast(cast('b' as char(3)) as varchar(3))", (Type)VarcharType.createVarcharType((int)3), "b  ");
    }

    @Test
    public void testVarcharToCharSaturatedFloorCast() {
        String nonBmpCharacter = new String(Character.toChars(128269));
        String nonBmpCharacterMinusOne = new String(Character.toChars(128268));
        String maxCodePoint = new String(Character.toChars(0x10FFFF));
        String codePointBeforeSpace = new String(Character.toChars(31));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"12345")), (Object)Slices.utf8Slice((String)"1234"));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"1234")), (Object)Slices.utf8Slice((String)"1234"));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)("123" + nonBmpCharacter))), (Object)Slices.utf8Slice((String)("123" + nonBmpCharacter)));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)("12" + nonBmpCharacter + "3"))), (Object)Slices.utf8Slice((String)("12" + nonBmpCharacter + "3")));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"123 ")), (Object)Slices.utf8Slice((String)"123"));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"123")), (Object)Slices.utf8Slice((String)("122" + maxCodePoint)));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"12 ")), (Object)Slices.utf8Slice((String)("12" + codePointBeforeSpace + maxCodePoint)));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"1  ")), (Object)Slices.utf8Slice((String)("1 " + codePointBeforeSpace + maxCodePoint)));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)" ")), (Object)Slices.utf8Slice((String)(codePointBeforeSpace + maxCodePoint + maxCodePoint + maxCodePoint)));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)("12" + nonBmpCharacter))), (Object)Slices.utf8Slice((String)("12" + nonBmpCharacterMinusOne + maxCodePoint)));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)("1" + nonBmpCharacter + "3"))), (Object)Slices.utf8Slice((String)("1" + nonBmpCharacter + "2" + maxCodePoint)));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"12\u0000")), (Object)Slices.utf8Slice((String)("11" + maxCodePoint + maxCodePoint)));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"1\u0000")), (Object)Slices.utf8Slice((String)("0" + maxCodePoint + maxCodePoint + maxCodePoint)));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"\u0000")), (Object)Slices.utf8Slice((String)"\u0000\u0000\u0000\u0000"));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"\u0000\u0000")), (Object)Slices.utf8Slice((String)"\u0000\u0000\u0000\u0000"));
        Assert.assertEquals((Object)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"")), (Object)Slices.utf8Slice((String)"\u0000\u0000\u0000\u0000"));
    }
}

