/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.base.Verify;
import io.prestosql.Session;
import io.prestosql.operator.scalar.FunctionAssertions;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.SqlTime;
import io.prestosql.spi.type.SqlTimeWithTimeZone;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.testing.DateTimeTestingUtils;
import io.prestosql.testing.TestingSession;
import io.prestosql.type.TestDateTimeOperatorsBase;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public class TestDateTimeOperators
extends TestDateTimeOperatorsBase {
    public TestDateTimeOperators() {
        super(false);
    }

    @Test
    public void testTimeZoneGap() {
        this.assertFunction("TIMESTAMP '2013-03-31 00:05' + INTERVAL '1' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)1, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-03-31 00:05' + INTERVAL '2' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)2, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-03-31 00:05' + INTERVAL '3' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)3, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-03-31 04:05' - INTERVAL '3' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)1, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-03-31 03:05' - INTERVAL '2' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)1, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-03-31 01:05' - INTERVAL '1' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)0, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
    }

    @Test
    public void testDaylightTimeSaving() {
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '1' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)1, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '2' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)2, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '3' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)3, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '4' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)4, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-10-27 03:05' - INTERVAL '4' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)26, (int)23, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-10-27 02:05' - INTERVAL '2' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)0, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-10-27 01:05' - INTERVAL '1' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)0, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-10-27 03:05' - INTERVAL '1' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)2, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
        this.assertFunction("TIMESTAMP '2013-10-27 03:05' - INTERVAL '2' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)1, (int)5, (int)0, (int)0, (DateTimeZone)DATE_TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (ConnectorSession)this.session.toConnectorSession()));
    }

    @Test
    public void testTimeWithTimeZoneRepresentation() {
        this.testTimeRepresentationOnDate(new DateTime(2017, 3, 12, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '02:30:00.000 America/Los_Angeles'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(37800000L, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")));
        this.testTimeRepresentationOnDate(new DateTime(2017, 3, 12, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '03:30:00.000 America/Los_Angeles'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(41400000L, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")));
        this.testTimeRepresentationOnDate(new DateTime(2017, 10, 4, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '02:30:00.000 America/Los_Angeles'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(37800000L, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")));
        this.testTimeRepresentationOnDate(new DateTime(2017, 10, 4, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '03:30:00.000 America/Los_Angeles'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(41400000L, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")));
        this.testTimeRepresentationOnDate(new DateTime(2017, 6, 6, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '02:30:00.000 America/Los_Angeles'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(37800000L, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")));
        this.testTimeRepresentationOnDate(new DateTime(2017, 6, 6, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '03:30:00.000 America/Los_Angeles'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(41400000L, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")));
        this.testTimeRepresentationOnDate(new DateTime(2017, 11, 1, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '02:30:00.000 America/Los_Angeles'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(37800000L, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")));
        this.testTimeRepresentationOnDate(new DateTime(2017, 11, 1, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '03:30:00.000 America/Los_Angeles'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(41400000L, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")));
    }

    @Test
    public void testTimeRepresentation() {
        this.testTimeRepresentationOnDate(new DateTime(2017, 3, 12, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '02:30:00.000'", (Type)TimeType.TIME, new SqlTime(9000000L));
        this.testTimeRepresentationOnDate(new DateTime(2017, 3, 12, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '03:30:00.000'", (Type)TimeType.TIME, new SqlTime(12600000L));
        this.testTimeRepresentationOnDate(new DateTime(2017, 10, 4, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '02:30:00.000'", (Type)TimeType.TIME, new SqlTime(9000000L));
        this.testTimeRepresentationOnDate(new DateTime(2017, 10, 4, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '03:30:00.000'", (Type)TimeType.TIME, new SqlTime(12600000L));
        this.testTimeRepresentationOnDate(new DateTime(2017, 6, 6, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '02:30:00.000'", (Type)TimeType.TIME, new SqlTime(9000000L));
        this.testTimeRepresentationOnDate(new DateTime(2017, 6, 6, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '03:30:00.000'", (Type)TimeType.TIME, new SqlTime(12600000L));
        this.testTimeRepresentationOnDate(new DateTime(2017, 11, 1, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '02:30:00.000'", (Type)TimeType.TIME, new SqlTime(9000000L));
        this.testTimeRepresentationOnDate(new DateTime(2017, 11, 1, 10, 0, 0, 0, DateTimeZone.UTC), "TIME '03:30:00.000'", (Type)TimeType.TIME, new SqlTime(12600000L));
    }

    private void testTimeRepresentationOnDate(DateTime date, String timeLiteral, Type expectedType, Object expected) {
        Session localSession = TestingSession.testSessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")).setStart(Instant.ofEpochMilli(date.getMillis())).setSystemProperty("legacy_timestamp", "false").build();
        try (FunctionAssertions localAssertions = new FunctionAssertions(localSession);){
            localAssertions.assertFunction(timeLiteral, expectedType, expected);
            localAssertions.assertFunctionString(timeLiteral, expectedType, TestDateTimeOperators.valueFromLiteral(timeLiteral));
        }
    }

    private static String valueFromLiteral(String literal) {
        Pattern p = Pattern.compile("'(.*)'");
        Matcher m = p.matcher(literal);
        Verify.verify((boolean)m.find());
        return m.group(1);
    }
}

