/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.LongArrayBlockBuilder;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.type.AbstractTestType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDoubleType
extends AbstractTestType {
    public TestDoubleType() {
        super((Type)DoubleType.DOUBLE, Double.class, TestDoubleType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, 15);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 11.11);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 11.11);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 11.11);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 22.22);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 22.22);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 22.22);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 22.22);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 22.22);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 33.33);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 33.33);
        DoubleType.DOUBLE.writeDouble(blockBuilder, 44.44);
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return (Double)value + 0.1;
    }

    @Test
    public void testNaNHash() {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, 4);
        blockBuilder.writeLong(Double.doubleToLongBits(Double.NaN));
        blockBuilder.writeLong(Double.doubleToRawLongBits(Double.NaN));
        blockBuilder.writeLong(-4503599627370495L);
        blockBuilder.writeLong(9221120237041090560L);
        Assert.assertEquals((long)DoubleType.DOUBLE.hash((Block)blockBuilder, 0), (long)DoubleType.DOUBLE.hash((Block)blockBuilder, 1));
        Assert.assertEquals((long)DoubleType.DOUBLE.hash((Block)blockBuilder, 0), (long)DoubleType.DOUBLE.hash((Block)blockBuilder, 2));
        Assert.assertEquals((long)DoubleType.DOUBLE.hash((Block)blockBuilder, 0), (long)DoubleType.DOUBLE.hash((Block)blockBuilder, 3));
    }
}

