/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.RealOperators;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRealOperators
extends AbstractTestFunctions {
    @Test
    public void testTypeConstructor() {
        this.assertFunction("REAL'12.2'", (Type)RealType.REAL, Float.valueOf(12.2f));
        this.assertFunction("REAL'-17.76'", (Type)RealType.REAL, Float.valueOf(-17.76f));
        this.assertFunction("REAL'NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL '-NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'Infinity'", (Type)RealType.REAL, Float.valueOf(Float.POSITIVE_INFINITY));
        this.assertFunction("REAL'-Infinity'", (Type)RealType.REAL, Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    @Test
    public void testAdd() {
        this.assertFunction("REAL'12.34' + REAL'56.78'", (Type)RealType.REAL, Float.valueOf(69.119995f));
        this.assertFunction("REAL'-17.34' + REAL'-22.891'", (Type)RealType.REAL, Float.valueOf(-40.231003f));
        this.assertFunction("REAL'-89.123' + REAL'754.0'", (Type)RealType.REAL, Float.valueOf(664.877f));
        this.assertFunction("REAL'-0.0' + REAL'0.0'", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("REAL'NaN' + REAL'1.23'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'1.23' + REAL'NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'NaN' + REAL'-NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
    }

    @Test
    public void testSubtract() {
        this.assertFunction("REAL'12.34' - REAL'56.78'", (Type)RealType.REAL, Float.valueOf(-44.44f));
        this.assertFunction("REAL'-17.34' - REAL'-22.891'", (Type)RealType.REAL, Float.valueOf(5.5510006f));
        this.assertFunction("REAL'-89.123' - REAL'754.0'", (Type)RealType.REAL, Float.valueOf(-843.123f));
        this.assertFunction("REAL'-0.0' - REAL'0.0'", (Type)RealType.REAL, Float.valueOf(-0.0f));
        this.assertFunction("REAL'NaN' - REAL'1.23'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'1.23' - REAL'NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'NaN' - REAL'NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
    }

    @Test
    public void testMultiply() {
        this.assertFunction("REAL'12.34' * REAL'56.78'", (Type)RealType.REAL, Float.valueOf(700.6652f));
        this.assertFunction("REAL'-17.34' * REAL'-22.891'", (Type)RealType.REAL, Float.valueOf(396.92996f));
        this.assertFunction("REAL'-89.123' * REAL'754.0'", (Type)RealType.REAL, Float.valueOf(-67198.74f));
        this.assertFunction("REAL'-0.0' * REAL'0.0'", (Type)RealType.REAL, Float.valueOf(-0.0f));
        this.assertFunction("REAL'-17.71' * REAL'-1.0'", (Type)RealType.REAL, Float.valueOf(17.71f));
        this.assertFunction("REAL'NaN' * REAL'1.23'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'1.23' * REAL'NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'NaN' * REAL'-NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
    }

    @Test
    public void testDivide() {
        this.assertFunction("REAL'12.34' / REAL'56.78'", (Type)RealType.REAL, Float.valueOf(0.21733005f));
        this.assertFunction("REAL'-17.34' / REAL'-22.891'", (Type)RealType.REAL, Float.valueOf(0.7575029f));
        this.assertFunction("REAL'-89.123' / REAL'754.0'", (Type)RealType.REAL, Float.valueOf(-0.118200265f));
        this.assertFunction("REAL'-0.0' / REAL'0.0'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'-17.71' / REAL'-1.0'", (Type)RealType.REAL, Float.valueOf(17.71f));
        this.assertFunction("REAL'NaN' / REAL'1.23'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'1.23' / REAL'NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'NaN' / REAL'-NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
    }

    @Test
    public void testModulus() {
        this.assertFunction("REAL'12.34' % REAL'56.78'", (Type)RealType.REAL, Float.valueOf(12.34f));
        this.assertFunction("REAL'-17.34' % REAL'-22.891'", (Type)RealType.REAL, Float.valueOf(-17.34f));
        this.assertFunction("REAL'-89.123' % REAL'754.0'", (Type)RealType.REAL, Float.valueOf(-89.123f));
        this.assertFunction("REAL'-0.0' % REAL'0.0'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'-17.71' % REAL'-1.0'", (Type)RealType.REAL, Float.valueOf(-0.7099991f));
        this.assertFunction("REAL'NaN' % REAL'1.23'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'1.23' % REAL'NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'NaN' % REAL'NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
    }

    @Test
    public void testNegation() {
        this.assertFunction("-REAL'12.34'", (Type)RealType.REAL, Float.valueOf(-12.34f));
        this.assertFunction("-REAL'-17.34'", (Type)RealType.REAL, Float.valueOf(17.34f));
        this.assertFunction("-REAL'-0.0'", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("-REAL'NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("-REAL'-NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
    }

    @Test
    public void testEqual() {
        this.assertFunction("REAL'12.34' = REAL'12.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'12.340' = REAL'12.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-17.34' = REAL'-17.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'71.17' = REAL'23.45'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-0.0' = REAL'0.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'NaN' = REAL'1.23'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'1.23' = REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' = REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("REAL'12.34' <> REAL'12.34'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'12.34' <> REAL'12.340'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-17.34' <> REAL'-17.34'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'71.17' <> REAL'23.45'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-0.0' <> REAL'0.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' <> REAL'1.23'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'1.23' <> REAL'NaN'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'NaN' <> REAL'NaN'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("REAL'12.34' < REAL'754.123'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-17.34' < REAL'-16.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'71.17' < REAL'23.45'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-0.0' < REAL'0.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' < REAL'1.23'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'1.23' < REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' < REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("REAL'12.34' <= REAL'754.123'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-17.34' <= REAL'-17.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'71.17' <= REAL'23.45'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-0.0' <= REAL'0.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'NaN' <= REAL'1.23'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'1.23' <= REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' <= REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("REAL'12.34' > REAL'754.123'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-17.34' > REAL'-17.34'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'71.17' > REAL'23.45'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-0.0' > REAL'0.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' > REAL'1.23'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'1.23' > REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' > REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("REAL'12.34' >= REAL'754.123'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-17.34' >= REAL'-17.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'71.17' >= REAL'23.45'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-0.0' >= REAL'0.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'NaN' >= REAL'1.23'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'1.23' >= REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' >= REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("REAL'12.34' BETWEEN REAL'9.12' AND REAL'25.89'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-17.34' BETWEEN REAL'-17.34' AND REAL'-16.57'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-17.34' BETWEEN REAL'-18.98' AND REAL'-17.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'0.0' BETWEEN REAL'-1.2' AND REAL'2.3'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'56.78' BETWEEN REAL'12.34' AND REAL'34.56'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'56.78' BETWEEN REAL'78.89' AND REAL'98.765'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' BETWEEN REAL'-1.2' AND REAL'2.3'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'56.78' BETWEEN REAL'-NaN' AND REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'56.78' BETWEEN REAL'NaN' AND REAL'-NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'56.78' BETWEEN REAL'56.78' AND REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' BETWEEN REAL'NaN' AND REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("CAST(REAL'754.1985' as VARCHAR)", (Type)VarcharType.VARCHAR, "754.1985");
        this.assertFunction("CAST(REAL'-754.2008' as VARCHAR)", (Type)VarcharType.VARCHAR, "-754.2008");
        this.assertFunction("CAST(REAL'Infinity' as VARCHAR)", (Type)VarcharType.VARCHAR, "Infinity");
        this.assertFunction("CAST(REAL'0.0' / REAL'0.0' as VARCHAR)", (Type)VarcharType.VARCHAR, "NaN");
    }

    @Test
    public void testCastToBigInt() {
        this.assertFunction("CAST(REAL'754.1985' as BIGINT)", (Type)BigintType.BIGINT, 754L);
        this.assertFunction("CAST(REAL'-754.2008' as BIGINT)", (Type)BigintType.BIGINT, -754L);
        this.assertFunction("CAST(REAL'1.98' as BIGINT)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CAST(REAL'-0.0' as BIGINT)", (Type)BigintType.BIGINT, 0L);
        this.assertInvalidFunction("CAST(REAL 'NaN' as BIGINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    @Test
    public void testCastToInteger() {
        this.assertFunction("CAST(REAL'754.2008' AS INTEGER)", (Type)IntegerType.INTEGER, 754);
        this.assertFunction("CAST(REAL'-754.1985' AS INTEGER)", (Type)IntegerType.INTEGER, -754);
        this.assertFunction("CAST(REAL'9.99' AS INTEGER)", (Type)IntegerType.INTEGER, 10);
        this.assertFunction("CAST(REAL'-0.0' AS INTEGER)", (Type)IntegerType.INTEGER, 0);
        this.assertInvalidFunction("CAST(REAL 'NaN' AS INTEGER)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    @Test
    public void testCastToSmallint() {
        this.assertFunction("CAST(REAL'754.2008' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)754);
        this.assertFunction("CAST(REAL'-754.1985' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)-754);
        this.assertFunction("CAST(REAL'9.99' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)10);
        this.assertFunction("CAST(REAL'-0.0' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertInvalidFunction("CAST(REAL 'NaN' AS SMALLINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    @Test
    public void testCastToTinyint() {
        this.assertFunction("CAST(REAL'127.45' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)127);
        this.assertFunction("CAST(REAL'-128.234' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)-128);
        this.assertFunction("CAST(REAL'9.99' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)10);
        this.assertFunction("CAST(REAL'-0.0' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertInvalidFunction("CAST(REAL 'NaN' AS TINYINT)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    @Test
    public void testCastToDouble() {
        this.assertFunction("CAST(REAL'754.1985' AS DOUBLE)", (Type)DoubleType.DOUBLE, 754.198486328125);
        this.assertFunction("CAST(REAL'-754.2008' AS DOUBLE)", (Type)DoubleType.DOUBLE, -754.2008056640625);
        this.assertFunction("CAST(REAL'0.0' AS DOUBLE)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("CAST(REAL'-0.0' AS DOUBLE)", (Type)DoubleType.DOUBLE, -0.0);
        this.assertFunction("CAST(CAST(REAL'754.1985' AS DOUBLE) AS REAL)", (Type)RealType.REAL, Float.valueOf(754.1985f));
        this.assertFunction("CAST(REAL 'NaN' AS DOUBLE)", (Type)DoubleType.DOUBLE, Double.NaN);
    }

    @Test
    public void testCastToBoolean() {
        this.assertFunction("CAST(REAL'754.1985' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(REAL'0.0' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(REAL'-0.0' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(REAL 'NaN' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS REAL) IS DISTINCT FROM CAST(NULL AS REAL)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'37.7' IS DISTINCT FROM REAL'37.7'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'37.7' IS DISTINCT FROM REAL'37.8'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM REAL'37.7'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'37.7' IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(nan() AS REAL) IS DISTINCT FROM CAST(nan() AS REAL)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'NaN' IS DISTINCT FROM REAL'37.8'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'37.8' IS DISTINCT FROM REAL'NaN'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as real)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(-1.2 as real)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(1.2 as real)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(123 as real)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "REAL'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNanHash() {
        int[] nanRepresentations;
        for (int nanRepresentation : nanRepresentations = new int[]{Float.floatToIntBits(Float.NaN), -4194304, 2143289344, 2143294004, -4189644}) {
            Assert.assertTrue((boolean)Float.isNaN(Float.intBitsToFloat(nanRepresentation)));
            Assert.assertEquals((long)RealOperators.hashCode((long)nanRepresentation), (long)RealOperators.hashCode((long)nanRepresentations[0]));
            Assert.assertEquals((long)RealOperators.xxHash64((long)nanRepresentation), (long)RealOperators.xxHash64((long)nanRepresentations[0]));
        }
    }

    @Test
    public void testZeroHash() {
        int[] zeroes;
        for (int zero : zeroes = new int[]{Float.floatToIntBits(0.0f), Float.floatToIntBits(-0.0f)}) {
            Assert.assertTrue((Float.intBitsToFloat(zero) == 0.0f ? 1 : 0) != 0);
            Assert.assertEquals((long)RealOperators.hashCode((long)zero), (long)RealOperators.hashCode((long)zeroes[0]));
            Assert.assertEquals((long)RealOperators.xxHash64((long)zero), (long)RealOperators.xxHash64((long)zeroes[0]));
        }
    }
}

