/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.Session;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.SqlDate;
import io.prestosql.spi.type.SqlTimeWithTimeZone;
import io.prestosql.spi.type.SqlTimestampWithTimeZone;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.DateTimeTestingUtils;
import io.prestosql.testing.TestingSession;
import io.prestosql.type.IntervalDayTimeType;
import io.prestosql.type.JsonType;
import io.prestosql.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public abstract class TestTimestampBase
extends AbstractTestFunctions {
    protected static final TimeZoneKey TIME_ZONE_KEY = TestingSession.DEFAULT_TIME_ZONE_KEY;
    protected static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);

    protected TestTimestampBase(boolean legacyTimestamp) {
        super(TestingSession.testSessionBuilder().setSystemProperty("legacy_timestamp", String.valueOf(legacyTimestamp)).setTimeZoneKey(TIME_ZONE_KEY).build());
    }

    @Test
    public void testSubtract() {
        this.functionAssertions.assertFunctionString("TIMESTAMP '2017-03-30 14:15:16.432' - TIMESTAMP '2016-03-29 03:04:05.321'", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, "366 11:11:11.111");
        this.functionAssertions.assertFunctionString("TIMESTAMP '2016-03-29 03:04:05.321' - TIMESTAMP '2017-03-30 14:15:16.432'", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, "-366 11:11:11.111");
    }

    @Test
    public void testLiteral() {
        this.assertFunction("TIMESTAMP '2013-03-30 01:05'", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2013, (int)3, (int)30, (int)1, (int)5, (int)0, (int)0, (Session)this.session));
        this.assertFunction("TIMESTAMP '2013-03-30 02:05'", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2013, (int)3, (int)30, (int)2, (int)5, (int)0, (int)0, (Session)this.session));
        this.assertFunction("TIMESTAMP '2013-03-30 03:05'", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2013, (int)3, (int)30, (int)3, (int)5, (int)0, (int)0, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-01-22 03:04:05.321'", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-01-22 03:04:05'", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)0, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-01-22 03:04'", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)0, (int)0, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-01-22'", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2001, (int)1, (int)22, (int)0, (int)0, (int)0, (int)0, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-1-2 3:4:5.321'", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)2, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-1-2 3:4:5'", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2001, (int)1, (int)2, (int)3, (int)4, (int)5, (int)0, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-1-2 3:4'", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2001, (int)1, (int)2, (int)3, (int)4, (int)0, (int)0, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-1-2'", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2001, (int)1, (int)2, (int)0, (int)0, (int)0, (int)0, (Session)this.session));
        this.assertFunction("TIMESTAMP '123001-01-22 03:04:05.321'", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)123001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIMESTAMP '+123001-01-22 03:04:05.321'", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)123001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIMESTAMP '-123001-01-22 03:04:05.321'", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)-123001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertInvalidFunction("TIMESTAMP 'text'", (ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, "line 1:1: 'text' is not a valid timestamp literal");
    }

    @Test
    public void testEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' = TIMESTAMP '2001-1-22 03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22' = TIMESTAMP '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' = TIMESTAMP '2001-1-22 03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22' = TIMESTAMP '2001-1-11'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' <> TIMESTAMP '2001-1-22 03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22' <> TIMESTAMP '2001-1-11'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' <> TIMESTAMP '2001-1-22 03:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22' <> TIMESTAMP '2001-1-22'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' < TIMESTAMP '2001-1-22 03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22' < TIMESTAMP '2001-1-23'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' < TIMESTAMP '2001-1-22 03:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' < TIMESTAMP '2001-1-22 03:04:05'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22' < TIMESTAMP '2001-1-22'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22' < TIMESTAMP '2001-1-20'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' <= TIMESTAMP '2001-1-22 03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' <= TIMESTAMP '2001-1-22 03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22' <= TIMESTAMP '2001-1-23'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22' <= TIMESTAMP '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' <= TIMESTAMP '2001-1-22 03:04:05'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22' <= TIMESTAMP '2001-1-20'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' > TIMESTAMP '2001-1-22 03:04:05.111'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22' > TIMESTAMP '2001-1-11'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' > TIMESTAMP '2001-1-22 03:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' > TIMESTAMP '2001-1-22 03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22' > TIMESTAMP '2001-1-22'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22' > TIMESTAMP '2001-1-23'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' >= TIMESTAMP '2001-1-22 03:04:05.111'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' >= TIMESTAMP '2001-1-22 03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22' >= TIMESTAMP '2001-1-11'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22' >= TIMESTAMP '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' >= TIMESTAMP '2001-1-22 03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22' >= TIMESTAMP '2001-1-23'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.111' and TIMESTAMP '2001-1-22 03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.321' and TIMESTAMP '2001-1-22 03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.111' and TIMESTAMP '2001-1-22 03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.321' and TIMESTAMP '2001-1-22 03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.322' and TIMESTAMP '2001-1-22 03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.311' and TIMESTAMP '2001-1-22 03:04:05.312'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.333' and TIMESTAMP '2001-1-22 03:04:05.111'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastToDate() {
        long millis = new DateTime(2001, 1, 22, 0, 0, DateTimeZone.UTC).getMillis();
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as date)", (Type)DateType.DATE, new SqlDate((int)TimeUnit.MILLISECONDS.toDays(millis)));
    }

    @Test
    public void testCastToTime() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as time)", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
    }

    @Test
    public void testCastToTimeWithTimeZone() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2001-1-22 03:04:05.321' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "03:04:05.321 " + DATE_TIME_ZONE.getID());
    }

    @Test
    public void testCastToTimestampWithTimeZone() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)DATE_TIME_ZONE.toTimeZone().getID())));
        this.functionAssertions.assertFunctionString("cast(TIMESTAMP '2001-1-22 03:04:05.321' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "2001-01-22 03:04:05.321 " + DATE_TIME_ZONE.getID());
    }

    @Test
    public void testCastToSlice() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as varchar)", (Type)VarcharType.VARCHAR, "2001-01-22 03:04:05.321");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05' as varchar)", (Type)VarcharType.VARCHAR, "2001-01-22 03:04:05");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04' as varchar)", (Type)VarcharType.VARCHAR, "2001-01-22 03:04:00");
        this.assertFunction("cast(TIMESTAMP '2001-1-22' as varchar)", (Type)VarcharType.VARCHAR, "2001-01-22 00:00:00");
    }

    @Test
    public void testCastToJson() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as json)", (Type)JsonType.JSON, "\"2001-01-22 03:04:05.321\"");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05' as json)", (Type)JsonType.JSON, "\"2001-01-22 03:04:05\"");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04' as json)", (Type)JsonType.JSON, "\"2001-01-22 03:04:00\"");
        this.assertFunction("cast(TIMESTAMP '2001-1-22' as json)", (Type)JsonType.JSON, "\"2001-01-22 00:00:00\"");
        this.assertFunction("cast(ARRAY[TIMESTAMP '2001-1-22 03:04:05.321'] as json)", (Type)JsonType.JSON, "[\"2001-01-22 03:04:05.321\"]");
        this.assertFunction("cast(ARRAY[TIMESTAMP '2001-1-22 03:04:05'] as json)", (Type)JsonType.JSON, "[\"2001-01-22 03:04:05\"]");
        this.assertFunction("cast(ARRAY[TIMESTAMP '2001-1-22 03:04'] as json)", (Type)JsonType.JSON, "[\"2001-01-22 03:04:00\"]");
        this.assertFunction("cast(ARRAY[TIMESTAMP '2001-1-22'] as json)", (Type)JsonType.JSON, "[\"2001-01-22 00:00:00\"]");
    }

    @Test
    public void testCastFromSlice() {
        this.assertFunction("cast('2001-1-22 03:04:05.321' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("cast('2001-1-22 03:04:05' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)0, (Session)this.session));
        this.assertFunction("cast('2001-1-22 03:04' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)0, (int)0, (Session)this.session));
        this.assertFunction("cast('2001-1-22' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)0, (int)0, (int)0, (int)0, (Session)this.session));
        this.assertFunction("cast('\n\t 2001-1-22 03:04:05.321' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("cast('2001-1-22 03:04:05.321 \t\n' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("cast('\n\t 2001-1-22 03:04:05.321 \t\n' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
    }

    @Test
    public void testGreatest() {
        this.assertFunction("greatest(TIMESTAMP '2013-03-30 01:05', TIMESTAMP '2012-03-30 01:05')", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2013, (int)3, (int)30, (int)1, (int)5, (int)0, (int)0, (Session)this.session));
        this.assertFunction("greatest(TIMESTAMP '2013-03-30 01:05', TIMESTAMP '2012-03-30 01:05', TIMESTAMP '2012-05-01 01:05')", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2013, (int)3, (int)30, (int)1, (int)5, (int)0, (int)0, (Session)this.session));
    }

    @Test
    public void testLeast() {
        this.assertFunction("least(TIMESTAMP '2013-03-30 01:05', TIMESTAMP '2012-03-30 01:05')", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2012, (int)3, (int)30, (int)1, (int)5, (int)0, (int)0, (Session)this.session));
        this.assertFunction("least(TIMESTAMP '2013-03-30 01:05', TIMESTAMP '2012-03-30 01:05', TIMESTAMP '2012-05-01 01:05')", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)2012, (int)3, (int)30, (int)1, (int)5, (int)0, (int)0, (Session)this.session));
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as TIMESTAMP)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "TIMESTAMP '2012-03-30 01:05'", (Type)BooleanType.BOOLEAN, false);
    }
}

