/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.Session;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.testing.DateTimeTestingUtils;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.assertions.PrestoExceptionAssert;
import io.prestosql.type.TestTimestampBase;
import org.testng.annotations.Test;

public class TestTimestampLegacy
extends TestTimestampBase {
    public TestTimestampLegacy() {
        super(true);
    }

    @Override
    public void testCastFromSlice() {
        super.testCastFromSlice();
        this.assertFunction("cast('2001-1-22 03:04:05.321 +07:09' as timestamp)", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)21, (int)8, (int)55, (int)5, (int)321, (Session)this.session));
        this.assertFunction("cast('2001-1-22 03:04:05 +07:09' as timestamp)", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)21, (int)8, (int)55, (int)5, (int)0, (Session)this.session));
        this.assertFunction("cast('2001-1-22 03:04 +07:09' as timestamp)", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)21, (int)8, (int)55, (int)0, (int)0, (Session)this.session));
        this.assertFunction("cast('2001-1-22 +07:09' as timestamp)", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)21, (int)5, (int)51, (int)0, (int)0, (Session)this.session));
        this.assertFunction("cast('2001-1-22 03:04:05.321 Asia/Oral' as timestamp)", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)21, (int)12, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("cast('2001-1-22 03:04:05 Asia/Oral' as timestamp)", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)21, (int)12, (int)4, (int)5, (int)0, (Session)this.session));
        this.assertFunction("cast('2001-1-22 03:04 Asia/Oral' as timestamp)", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)21, (int)12, (int)4, (int)0, (int)0, (Session)this.session));
        this.assertFunction("cast('2001-1-22 Asia/Oral' as timestamp)", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)21, (int)9, (int)0, (int)0, (int)0, (Session)this.session));
    }

    @Test
    public void testInvalidLiteral() {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("legacy_timestamp", "true").setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Europe/Vilnius")).build();
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> this.functionAssertions.tryEvaluate("TIMESTAMP '2018-03-25 03:17:17.000'", (Type)TimestampType.TIMESTAMP, session)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL).hasMessage("line 1:1: '2018-03-25 03:17:17.000' is not a valid timestamp literal");
    }
}

