/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.type.AbstractTestType;
import io.prestosql.util.StructuralTestUtil;
import java.util.List;

public class TestTinyintArrayType
extends AbstractTestType {
    public TestTinyintArrayType() {
        this((Metadata)MetadataManager.createTestMetadataManager());
    }

    private TestTinyintArrayType(Metadata metadata) {
        super(metadata.getType(TypeSignature.arrayType((TypeSignature)TinyintType.TINYINT.getTypeSignature())), List.class, TestTinyintArrayType.createTestBlock(metadata.getType(TypeSignature.arrayType((TypeSignature)TinyintType.TINYINT.getTypeSignature()))));
    }

    public static Block createTestBlock(Type arrayType) {
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 4);
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)TinyintType.TINYINT, 1, 2));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)TinyintType.TINYINT, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)TinyintType.TINYINT, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)TinyintType.TINYINT, 100, 110, 127));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Block block = (Block)value;
        BlockBuilder blockBuilder = TinyintType.TINYINT.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            TinyintType.TINYINT.appendTo(block, i, blockBuilder);
        }
        TinyintType.TINYINT.writeLong(blockBuilder, 1L);
        return blockBuilder.build();
    }
}

