/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.util.Failures;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFailures {
    @Test
    public void testToFailureLoop() {
        Object exception1 = new PrestoException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, "fake exception 1");
        RuntimeException exception2 = new RuntimeException("fake exception 2", (Throwable)exception1);
        ((Throwable)exception1).addSuppressed(exception2);
        ExecutionFailureInfo failure = Failures.toFailure((Throwable)exception1);
        Assert.assertEquals((String)failure.getMessage(), (String)"fake exception 1");
        Assert.assertNull((Object)failure.getCause());
        Assert.assertEquals((int)failure.getSuppressed().size(), (int)1);
        Assert.assertEquals((String)((ExecutionFailureInfo)failure.getSuppressed().get(0)).getMessage(), (String)"fake exception 2");
        Assert.assertEquals((Object)failure.getErrorCode(), (Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode());
        failure = Failures.toFailure((Throwable)exception2);
        Assert.assertEquals((String)failure.getMessage(), (String)"fake exception 2");
        Assert.assertNotNull((Object)failure.getCause());
        Assert.assertEquals((String)failure.getCause().getMessage(), (String)"fake exception 1");
        Assert.assertEquals((int)failure.getSuppressed().size(), (int)0);
        Assert.assertEquals((Object)failure.getErrorCode(), (Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode());
        exception1 = new PrestoException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, "fake exception 1");
        exception2 = new RuntimeException("fake exception 2");
        ((Throwable)exception1).addSuppressed(exception2);
        exception2.addSuppressed((Throwable)exception1);
        failure = Failures.toFailure((Throwable)exception1);
        Assert.assertEquals((String)failure.getMessage(), (String)"fake exception 1");
        Assert.assertNull((Object)failure.getCause());
        Assert.assertEquals((int)failure.getSuppressed().size(), (int)1);
        Assert.assertEquals((String)((ExecutionFailureInfo)failure.getSuppressed().get(0)).getMessage(), (String)"fake exception 2");
        Assert.assertEquals((Object)failure.getErrorCode(), (Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode());
        exception1 = new RuntimeException("fake exception 1");
        exception2 = new RuntimeException("fake exception 2", (Throwable)exception1);
        ((Throwable)exception1).initCause(exception2);
        failure = Failures.toFailure((Throwable)exception2);
        Assert.assertEquals((String)failure.getMessage(), (String)"fake exception 2");
        Assert.assertNotNull((Object)failure.getCause());
        Assert.assertEquals((String)failure.getCause().getMessage(), (String)"fake exception 1");
        Assert.assertEquals((int)failure.getSuppressed().size(), (int)0);
        Assert.assertEquals((Object)failure.getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
    }
}

