/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.util.DateTimeZoneIndex;
import java.time.ZoneId;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTimeZoneUtils {
    @Test
    public void test() {
        DateTimeZone dateTimeZone;
        TreeSet<String> jdkZones = new TreeSet<String>(ZoneId.getAvailableZoneIds());
        for (String zoneId : jdkZones) {
            if (zoneId.startsWith("Etc/") || zoneId.startsWith("GMT") || zoneId.startsWith("SystemV/")) continue;
            dateTimeZone = DateTimeZone.forID((String)zoneId);
            DateTimeZone indexedZone = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)zoneId));
            TestTimeZoneUtils.assertDateTimeZoneEquals(zoneId, indexedZone);
            TestTimeZoneUtils.assertTimeZone(zoneId, dateTimeZone);
        }
        for (int offsetHours = -13; offsetHours < 14; ++offsetHours) {
            for (int offsetMinutes = 0; offsetMinutes < 60; ++offsetMinutes) {
                dateTimeZone = DateTimeZone.forOffsetHoursMinutes((int)offsetHours, (int)offsetMinutes);
                TestTimeZoneUtils.assertTimeZone(dateTimeZone.getID(), dateTimeZone);
            }
        }
    }

    public static void assertTimeZone(String zoneId, DateTimeZone dateTimeZone) {
        long dateTimeWithTimeZone = DateTimeZoneIndex.packDateTimeWithZone((DateTime)new DateTime(42L, dateTimeZone));
        Assert.assertEquals((long)DateTimeEncoding.packDateTimeWithZone((long)42L, (String)dateTimeZone.toTimeZone().getID()), (long)dateTimeWithTimeZone);
        DateTimeZone unpackedZone = DateTimeZoneIndex.unpackDateTimeZone((long)dateTimeWithTimeZone);
        TestTimeZoneUtils.assertDateTimeZoneEquals(zoneId, unpackedZone);
    }

    public static void assertDateTimeZoneEquals(String zoneId, DateTimeZone actualTimeZone) {
        DateTimeZone expectedDateTimeZone = TimeZoneKey.isUtcZoneId((String)zoneId) ? DateTimeZone.UTC : DateTimeZone.forID((String)zoneId);
        Assert.assertEquals((Object)actualTimeZone, (Object)expectedDateTimeZone);
    }
}

