/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.version;

import io.prestosql.version.EmbedVersion;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestEmbedVersion {
    private EmbedVersion embedVersion;

    @BeforeClass
    public void setUp() {
        this.embedVersion = new EmbedVersion("123-some-test-version");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.embedVersion = null;
    }

    @Test
    public void testEmbedVersionInRunnable() {
        AtomicInteger counter = new AtomicInteger();
        this.embedVersion.embedVersion(counter::incrementAndGet).run();
        Assert.assertEquals((int)counter.get(), (int)1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.embedVersion.embedVersion(() -> {
            throw new RuntimeException("Zonky zonk");
        }).run()).isInstanceOf(RuntimeException.class)).hasMessage("Zonky zonk").hasStackTraceContaining("at io.prestosql.$gen.Presto_123_some_test_version____");
    }

    @Test
    public void testEmbedVersionInCallable() throws Exception {
        AtomicInteger counter = new AtomicInteger();
        String value = (String)this.embedVersion.embedVersion(() -> "abc" + counter.incrementAndGet()).call();
        Assert.assertEquals((String)value, (String)"abc1");
        Assert.assertEquals((int)counter.get(), (int)1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.embedVersion.embedVersion(() -> {
            throw new RuntimeException("Zonky zonk");
        }).call()).isInstanceOf(RuntimeException.class)).hasMessage("Zonky zonk").hasStackTraceContaining("at io.prestosql.$gen.Presto_123_some_test_version____").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.embedVersion.embedVersion(() -> {
            throw new IOException("a checked exception");
        }).call()).isInstanceOf(IOException.class)).hasMessage("a checked exception").hasStackTraceContaining("at io.prestosql.$gen.Presto_123_some_test_version____").hasNoCause();
    }
}

