/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.FullConnectorSession;
import io.prestosql.NotInTransactionException;
import io.prestosql.SessionRepresentation;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.SecurityContext;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.spi.session.ResourceEstimates;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.sql.SqlPath;
import io.prestosql.sql.tree.Execute;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.util.Failures;
import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;

public final class Session {
    private final QueryId queryId;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final Identity identity;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final SqlPath path;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final Optional<String> clientInfo;
    private final Optional<String> traceToken;
    private final Set<String> clientTags;
    private final Set<String> clientCapabilities;
    private final ResourceEstimates resourceEstimates;
    private final Instant start;
    private final Map<String, String> systemProperties;
    private final Map<CatalogName, Map<String, String>> connectorProperties;
    private final Map<String, Map<String, String>> unprocessedCatalogProperties;
    private final SessionPropertyManager sessionPropertyManager;
    private final Map<String, String> preparedStatements;

    public Session(QueryId queryId, Optional<TransactionId> transactionId, boolean clientTransactionSupport, Identity identity, Optional<String> source, Optional<String> catalog, Optional<String> schema, SqlPath path, Optional<String> traceToken, TimeZoneKey timeZoneKey, Locale locale, Optional<String> remoteUserAddress, Optional<String> userAgent, Optional<String> clientInfo, Set<String> clientTags, Set<String> clientCapabilities, ResourceEstimates resourceEstimates, Instant start, Map<String, String> systemProperties, Map<CatalogName, Map<String, String>> connectorProperties, Map<String, Map<String, String>> unprocessedCatalogProperties, SessionPropertyManager sessionPropertyManager, Map<String, String> preparedStatements) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.clientTransactionSupport = clientTransactionSupport;
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.clientCapabilities = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientCapabilities, "clientCapabilities is null"));
        this.resourceEstimates = Objects.requireNonNull(resourceEstimates, "resourceEstimates is null");
        this.start = start;
        this.systemProperties = ImmutableMap.copyOf(Objects.requireNonNull(systemProperties, "systemProperties is null"));
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.preparedStatements = Objects.requireNonNull(preparedStatements, "preparedStatements is null");
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        connectorProperties.entrySet().stream().map(entry -> Maps.immutableEntry((Object)((CatalogName)entry.getKey()), (Object)ImmutableMap.copyOf((Map)((Map)entry.getValue())))).forEach(arg_0 -> ((ImmutableMap.Builder)catalogPropertiesBuilder).put(arg_0));
        this.connectorProperties = catalogPropertiesBuilder.build();
        ImmutableMap.Builder unprocessedCatalogPropertiesBuilder = ImmutableMap.builder();
        unprocessedCatalogProperties.entrySet().stream().map(entry -> Maps.immutableEntry((Object)((String)entry.getKey()), (Object)ImmutableMap.copyOf((Map)((Map)entry.getValue())))).forEach(arg_0 -> ((ImmutableMap.Builder)unprocessedCatalogPropertiesBuilder).put(arg_0));
        this.unprocessedCatalogProperties = unprocessedCatalogPropertiesBuilder.build();
        Preconditions.checkArgument((transactionId.isEmpty() || unprocessedCatalogProperties.isEmpty() ? 1 : 0) != 0, (Object)"Catalog session properties cannot be set if there is an open transaction");
        Preconditions.checkArgument((catalog.isPresent() || schema.isEmpty() ? 1 : 0) != 0, (Object)"schema is set but catalog is not");
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public String getUser() {
        return this.identity.getUser();
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public SqlPath getPath() {
        return this.path;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public Set<String> getClientCapabilities() {
        return this.clientCapabilities;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    public Instant getStart() {
        return this.start;
    }

    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    public TransactionId getRequiredTransactionId() throws NotInTransactionException {
        return this.transactionId.orElseThrow(NotInTransactionException::new);
    }

    public boolean isClientTransactionSupport() {
        return this.clientTransactionSupport;
    }

    public <T> T getSystemProperty(String name, Class<T> type) {
        return this.sessionPropertyManager.decodeSystemPropertyValue(name, this.systemProperties.get(name), type);
    }

    public Map<CatalogName, Map<String, String>> getConnectorProperties() {
        return this.connectorProperties;
    }

    public Map<String, String> getConnectorProperties(CatalogName catalogName) {
        return this.connectorProperties.getOrDefault(catalogName, (Map<String, String>)ImmutableMap.of());
    }

    public Map<String, Map<String, String>> getUnprocessedCatalogProperties() {
        return this.unprocessedCatalogProperties;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public String getPreparedStatementFromExecute(Execute execute) {
        return this.getPreparedStatement(execute.getName().getValue());
    }

    public String getPreparedStatement(String name) {
        String sql = this.preparedStatements.get(name);
        Failures.checkCondition(sql != null, (ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + name, new Object[0]);
        return sql;
    }

    public Session beginTransactionId(TransactionId transactionId, TransactionManager transactionManager, AccessControl accessControl) {
        Objects.requireNonNull(transactionId, "transactionId is null");
        Preconditions.checkArgument((boolean)this.transactionId.isEmpty(), (Object)"Session already has an active transaction");
        Objects.requireNonNull(transactionManager, "transactionManager is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            accessControl.checkCanSetSystemSessionProperty(this.identity, entry.getKey());
            this.sessionPropertyManager.validateSystemSessionProperty(entry.getKey(), entry.getValue());
        }
        ImmutableMap.Builder connectorProperties = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, String>> entry : this.unprocessedCatalogProperties.entrySet()) {
            String catalogName = entry.getKey();
            Map<String, String> catalogProperties = entry.getValue();
            if (catalogProperties.isEmpty()) continue;
            CatalogName catalog = transactionManager.getOptionalCatalogMetadata(transactionId, catalogName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Session property catalog does not exist: " + catalogName)).getCatalogName();
            for (Map.Entry<String, String> property : catalogProperties.entrySet()) {
                accessControl.checkCanSetCatalogSessionProperty(new SecurityContext(transactionId, this.identity, this.queryId), catalogName, property.getKey());
                this.sessionPropertyManager.validateCatalogSessionProperty(catalog, catalogName, property.getKey(), property.getValue());
            }
            connectorProperties.put((Object)catalog, catalogProperties);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.identity.getRoles().entrySet()) {
            String catalogName = (String)entry.getKey();
            SelectedRole role = (SelectedRole)entry.getValue();
            CatalogName catalog = transactionManager.getOptionalCatalogMetadata(transactionId, catalogName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog for role does not exist: " + catalogName)).getCatalogName();
            if (role.getType() == SelectedRole.Type.ROLE) {
                accessControl.checkCanSetRole(new SecurityContext(transactionId, this.identity, this.queryId), (String)role.getRole().get(), catalogName);
            }
            builder.put((Object)catalog.getCatalogName(), (Object)role);
            String informationSchemaCatalogName = CatalogName.createInformationSchemaCatalogName(catalog).getCatalogName();
            if (transactionManager.getCatalogNames(transactionId).containsKey(informationSchemaCatalogName)) {
                builder.put((Object)informationSchemaCatalogName, (Object)role);
            }
            String systemTablesCatalogName = CatalogName.createSystemTablesCatalogName(catalog).getCatalogName();
            if (!transactionManager.getCatalogNames(transactionId).containsKey(systemTablesCatalogName)) continue;
            builder.put((Object)systemTablesCatalogName, (Object)role);
        }
        return new Session(this.queryId, Optional.of(transactionId), this.clientTransactionSupport, Identity.from((Identity)this.identity).withRoles((Map)builder.build()).build(), this.source, this.catalog, this.schema, this.path, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.clientCapabilities, this.resourceEstimates, this.start, this.systemProperties, (Map<CatalogName, Map<String, String>>)connectorProperties.build(), (Map<String, Map<String, String>>)ImmutableMap.of(), this.sessionPropertyManager, this.preparedStatements);
    }

    public Session withDefaultProperties(Map<String, String> systemPropertyDefaults, Map<String, Map<String, String>> catalogPropertyDefaults) {
        Objects.requireNonNull(systemPropertyDefaults, "systemPropertyDefaults is null");
        Objects.requireNonNull(catalogPropertyDefaults, "catalogPropertyDefaults is null");
        Preconditions.checkState((this.transactionId.isEmpty() && this.connectorProperties.isEmpty() ? 1 : 0) != 0, (Object)"Session properties cannot be overridden once a transaction is active");
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        systemProperties.putAll(systemPropertyDefaults);
        systemProperties.putAll(this.systemProperties);
        Map<String, Map<String, String>> connectorProperties = catalogPropertyDefaults.entrySet().stream().map(entry -> Maps.immutableEntry((Object)((String)entry.getKey()), new HashMap((Map)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<String, Map<String, String>> catalogProperties : this.unprocessedCatalogProperties.entrySet()) {
            String catalog = catalogProperties.getKey();
            for (Map.Entry<String, String> entry2 : catalogProperties.getValue().entrySet()) {
                connectorProperties.computeIfAbsent(catalog, id -> new HashMap()).put(entry2.getKey(), entry2.getValue());
            }
        }
        return new Session(this.queryId, this.transactionId, this.clientTransactionSupport, this.identity, this.source, this.catalog, this.schema, this.path, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.clientCapabilities, this.resourceEstimates, this.start, systemProperties, (Map<CatalogName, Map<String, String>>)ImmutableMap.of(), connectorProperties, this.sessionPropertyManager, this.preparedStatements);
    }

    public ConnectorSession toConnectorSession() {
        return new FullConnectorSession(this, this.identity.toConnectorIdentity());
    }

    public ConnectorSession toConnectorSession(String catalogName) {
        return this.toConnectorSession(new CatalogName(catalogName));
    }

    public ConnectorSession toConnectorSession(CatalogName catalogName) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        return new FullConnectorSession(this, this.identity.toConnectorIdentity(catalogName.getCatalogName()), this.connectorProperties.getOrDefault(catalogName, (Map<String, String>)ImmutableMap.of()), catalogName, catalogName.getCatalogName(), this.sessionPropertyManager);
    }

    public SessionRepresentation toSessionRepresentation() {
        return new SessionRepresentation(this.queryId.toString(), this.transactionId, this.clientTransactionSupport, this.identity.getUser(), this.identity.getGroups(), this.identity.getPrincipal().map(Principal::toString), this.source, this.catalog, this.schema, this.path, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.clientCapabilities, this.resourceEstimates, this.start, this.systemProperties, this.connectorProperties, this.unprocessedCatalogProperties, this.identity.getRoles(), this.preparedStatements);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("transactionId", this.transactionId).add("user", (Object)this.getUser()).add("principal", this.getIdentity().getPrincipal().orElse(null)).add("source", this.source.orElse(null)).add("catalog", this.catalog.orElse(null)).add("schema", this.schema.orElse(null)).add("path", (Object)this.path).add("traceToken", this.traceToken.orElse(null)).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("remoteUserAddress", this.remoteUserAddress.orElse(null)).add("userAgent", this.userAgent.orElse(null)).add("clientInfo", this.clientInfo.orElse(null)).add("clientTags", this.clientTags).add("clientCapabilities", this.clientCapabilities).add("resourceEstimates", (Object)this.resourceEstimates).add("start", (Object)this.start).omitNullValues().toString();
    }

    public static SessionBuilder builder(SessionPropertyManager sessionPropertyManager) {
        return new SessionBuilder(sessionPropertyManager);
    }

    @VisibleForTesting
    public static SessionBuilder builder(Session session) {
        return new SessionBuilder(session);
    }

    public SecurityContext toSecurityContext() {
        return new SecurityContext(this.getRequiredTransactionId(), this.getIdentity(), this.queryId);
    }

    public static class ResourceEstimateBuilder {
        private Optional<Duration> executionTime = Optional.empty();
        private Optional<Duration> cpuTime = Optional.empty();
        private Optional<DataSize> peakMemory = Optional.empty();

        public ResourceEstimateBuilder setExecutionTime(Duration executionTime) {
            this.executionTime = Optional.of(executionTime);
            return this;
        }

        public ResourceEstimateBuilder setCpuTime(Duration cpuTime) {
            this.cpuTime = Optional.of(cpuTime);
            return this;
        }

        public ResourceEstimateBuilder setPeakMemory(DataSize peakMemory) {
            this.peakMemory = Optional.of(peakMemory);
            return this;
        }

        public ResourceEstimates build() {
            return new ResourceEstimates(this.executionTime.map(Duration::toMillis).map(java.time.Duration::ofMillis), this.cpuTime.map(Duration::toMillis).map(java.time.Duration::ofMillis), this.peakMemory.map(DataSize::toBytes));
        }
    }

    public static class SessionBuilder {
        private QueryId queryId;
        private TransactionId transactionId;
        private boolean clientTransactionSupport;
        private Identity identity;
        private String source;
        private String catalog;
        private String schema;
        private SqlPath path = new SqlPath(Optional.empty());
        private Optional<String> traceToken = Optional.empty();
        private TimeZoneKey timeZoneKey = TimeZoneKey.getTimeZoneKey((String)TimeZone.getDefault().getID());
        private Locale locale = Locale.getDefault();
        private String remoteUserAddress;
        private String userAgent;
        private String clientInfo;
        private Set<String> clientTags = ImmutableSet.of();
        private Set<String> clientCapabilities = ImmutableSet.of();
        private ResourceEstimates resourceEstimates;
        private Instant start = Instant.now();
        private final Map<String, String> systemProperties = new HashMap<String, String>();
        private final Map<String, Map<String, String>> catalogSessionProperties = new HashMap<String, Map<String, String>>();
        private final SessionPropertyManager sessionPropertyManager;
        private final Map<String, String> preparedStatements = new HashMap<String, String>();

        private SessionBuilder(SessionPropertyManager sessionPropertyManager) {
            this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        }

        private SessionBuilder(Session session) {
            Objects.requireNonNull(session, "session is null");
            Preconditions.checkArgument((boolean)session.getTransactionId().isEmpty(), (Object)"Session builder cannot be created from a session in a transaction");
            this.sessionPropertyManager = session.sessionPropertyManager;
            this.queryId = session.queryId;
            this.transactionId = session.transactionId.orElse(null);
            this.clientTransactionSupport = session.clientTransactionSupport;
            this.identity = session.identity;
            this.source = session.source.orElse(null);
            this.catalog = session.catalog.orElse(null);
            this.path = session.path;
            this.schema = session.schema.orElse(null);
            this.traceToken = Objects.requireNonNull(session.traceToken, "traceToken is null");
            this.timeZoneKey = session.timeZoneKey;
            this.locale = session.locale;
            this.remoteUserAddress = session.remoteUserAddress.orElse(null);
            this.userAgent = session.userAgent.orElse(null);
            this.clientInfo = session.clientInfo.orElse(null);
            this.clientTags = ImmutableSet.copyOf(session.clientTags);
            this.start = session.start;
            this.systemProperties.putAll(session.systemProperties);
            this.catalogSessionProperties.putAll(session.unprocessedCatalogProperties);
            this.preparedStatements.putAll(session.preparedStatements);
        }

        public SessionBuilder setQueryId(QueryId queryId) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            return this;
        }

        public SessionBuilder setTransactionId(TransactionId transactionId) {
            Preconditions.checkArgument((boolean)this.catalogSessionProperties.isEmpty(), (Object)"Catalog session properties cannot be set if there is an open transaction");
            this.transactionId = transactionId;
            return this;
        }

        public SessionBuilder setClientTransactionSupport() {
            this.clientTransactionSupport = true;
            return this;
        }

        public SessionBuilder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public SessionBuilder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public SessionBuilder setRemoteUserAddress(String remoteUserAddress) {
            this.remoteUserAddress = remoteUserAddress;
            return this;
        }

        public SessionBuilder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public SessionBuilder setPath(SqlPath path) {
            this.path = path;
            return this;
        }

        public SessionBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public SessionBuilder setTraceToken(Optional<String> traceToken) {
            this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
            return this;
        }

        public SessionBuilder setStart(Instant start) {
            this.start = start;
            return this;
        }

        public SessionBuilder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = timeZoneKey;
            return this;
        }

        public SessionBuilder setIdentity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public SessionBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public SessionBuilder setClientInfo(String clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        public SessionBuilder setClientTags(Set<String> clientTags) {
            this.clientTags = ImmutableSet.copyOf(clientTags);
            return this;
        }

        public SessionBuilder setClientCapabilities(Set<String> clientCapabilities) {
            this.clientCapabilities = ImmutableSet.copyOf(clientCapabilities);
            return this;
        }

        public SessionBuilder setResourceEstimates(ResourceEstimates resourceEstimates) {
            this.resourceEstimates = resourceEstimates;
            return this;
        }

        public SessionBuilder setSystemProperty(String propertyName, String propertyValue) {
            this.systemProperties.put(propertyName, propertyValue);
            return this;
        }

        public SessionBuilder setCatalogSessionProperty(String catalogName, String propertyName, String propertyValue) {
            Preconditions.checkArgument((this.transactionId == null ? 1 : 0) != 0, (Object)"Catalog session properties cannot be set if there is an open transaction");
            this.catalogSessionProperties.computeIfAbsent(catalogName, id -> new HashMap()).put(propertyName, propertyValue);
            return this;
        }

        public SessionBuilder addPreparedStatement(String statementName, String query) {
            this.preparedStatements.put(statementName, query);
            return this;
        }

        public Session build() {
            return new Session(this.queryId, Optional.ofNullable(this.transactionId), this.clientTransactionSupport, this.identity, Optional.ofNullable(this.source), Optional.ofNullable(this.catalog), Optional.ofNullable(this.schema), this.path, this.traceToken, this.timeZoneKey, this.locale, Optional.ofNullable(this.remoteUserAddress), Optional.ofNullable(this.userAgent), Optional.ofNullable(this.clientInfo), this.clientTags, this.clientCapabilities, Optional.ofNullable(this.resourceEstimates).orElse(new ResourceEstimateBuilder().build()), this.start, this.systemProperties, (Map<CatalogName, Map<String, String>>)ImmutableMap.of(), this.catalogSessionProperties, this.sessionPropertyManager, this.preparedStatements);
        }
    }
}

