/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorCapabilities;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeNotFoundException;
import io.prestosql.sql.NodeUtils;
import io.prestosql.sql.ParameterUtils;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.tree.AddColumn;
import io.prestosql.sql.tree.ColumnDefinition;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Statement;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.type.UnknownType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class AddColumnTask
implements DataDefinitionTask<AddColumn> {
    @Override
    public String getName() {
        return "ADD COLUMN";
    }

    @Override
    public ListenableFuture<?> execute(AddColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Type type;
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName()));
        if (tableHandle.isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
        }
        CatalogName catalogName = metadata.getCatalogHandle(session, tableName.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + tableName.getCatalogName()));
        accessControl.checkCanAddColumns(session.toSecurityContext(), tableName);
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle.get());
        ColumnDefinition element = statement.getColumn();
        try {
            type = metadata.getType(TypeSignatureTranslator.toTypeSignature(element.getType()));
        }
        catch (TypeNotFoundException e) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)element, "Unknown type '%s' for column '%s'", element.getType(), element.getName());
        }
        if (type.equals((Object)UnknownType.UNKNOWN)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)element, "Unknown type '%s' for column '%s'", element.getType(), element.getName());
        }
        if (columnHandles.containsKey(element.getName().getValue().toLowerCase(Locale.ENGLISH))) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", element.getName());
        }
        if (!element.isNullable() && !metadata.getConnectorCapabilities(session, catalogName).contains(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)element, "Catalog '%s' does not support NOT NULL for column '%s'", catalogName.getCatalogName(), element.getName());
        }
        Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(element.getProperties());
        Map<String, Object> columnProperties = metadata.getColumnPropertyManager().getProperties(catalogName, tableName.getCatalogName(), sqlProperties, session, metadata, accessControl, ParameterUtils.parameterExtractor((Statement)statement, parameters));
        ColumnMetadata column = ColumnMetadata.builder().setName(element.getName().getValue()).setType(type).setNullable(element.isNullable()).setComment(element.getComment()).setProperties(columnProperties).build();
        metadata.addColumn(session, tableHandle.get(), column);
        return Futures.immediateFuture(null);
    }
}

