/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.DropView;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class DropViewTask
implements DataDefinitionTask<DropView> {
    @Override
    public String getName() {
        return "DROP VIEW";
    }

    @Override
    public ListenableFuture<?> execute(DropView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        QualifiedObjectName name;
        Session session = stateMachine.getSession();
        Optional<ConnectorViewDefinition> view = metadata.getView(session, name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName()));
        if (view.isEmpty()) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist", name);
            }
            return Futures.immediateFuture(null);
        }
        accessControl.checkCanDropView(session.toSecurityContext(), name);
        metadata.dropView(session, name);
        return Futures.immediateFuture(null);
    }
}

