/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.scheduler.NetworkLocation;
import io.prestosql.execution.scheduler.NetworkTopology;
import io.prestosql.execution.scheduler.NodeMap;
import io.prestosql.execution.scheduler.NodeSchedulerConfig;
import io.prestosql.execution.scheduler.NodeSelector;
import io.prestosql.execution.scheduler.NodeSelectorFactory;
import io.prestosql.execution.scheduler.TopologyAwareNodeSelector;
import io.prestosql.execution.scheduler.TopologyAwareNodeSelectorConfig;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.NodeState;
import io.prestosql.spi.HostAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class TopologyAwareNodeSelectorFactory
implements NodeSelectorFactory {
    private static final Logger LOG = Logger.get(TopologyAwareNodeSelectorFactory.class);
    private final Cache<InternalNode, Boolean> inaccessibleNodeLogCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private final NetworkTopology networkTopology;
    private final InternalNodeManager nodeManager;
    private final int minCandidates;
    private final boolean includeCoordinator;
    private final int maxSplitsPerNode;
    private final int maxPendingSplitsPerTask;
    private final NodeTaskMap nodeTaskMap;
    private final List<CounterStat> placementCounters;
    private final Map<String, CounterStat> placementCountersByName;

    @Inject
    public TopologyAwareNodeSelectorFactory(NetworkTopology networkTopology, InternalNodeManager nodeManager, NodeSchedulerConfig schedulerConfig, NodeTaskMap nodeTaskMap, TopologyAwareNodeSelectorConfig topologyConfig) {
        Objects.requireNonNull(networkTopology, "networkTopology is null");
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(schedulerConfig, "schedulerConfig is null");
        Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        Objects.requireNonNull(topologyConfig, "topologyConfig is null");
        this.networkTopology = networkTopology;
        this.nodeManager = nodeManager;
        this.minCandidates = schedulerConfig.getMinCandidates();
        this.includeCoordinator = schedulerConfig.isIncludeCoordinator();
        this.maxSplitsPerNode = schedulerConfig.getMaxSplitsPerNode();
        this.maxPendingSplitsPerTask = schedulerConfig.getMaxPendingSplitsPerTask();
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        Preconditions.checkArgument((this.maxSplitsPerNode >= this.maxPendingSplitsPerTask ? 1 : 0) != 0, (Object)"maxSplitsPerNode must be > maxPendingSplitsPerTask");
        ImmutableList.Builder placementCounters = ImmutableList.builder();
        ImmutableMap.Builder placementCountersByName = ImmutableMap.builder();
        CounterStat allCounter = new CounterStat();
        placementCounters.add((Object)allCounter);
        placementCountersByName.put((Object)"all", (Object)allCounter);
        for (String segmentName : ImmutableList.copyOf(topologyConfig.getLocationSegmentNames())) {
            CounterStat segmentCounter = new CounterStat();
            placementCounters.add((Object)segmentCounter);
            placementCountersByName.put((Object)segmentName, (Object)segmentCounter);
        }
        this.placementCounters = placementCounters.build();
        this.placementCountersByName = placementCountersByName.build();
    }

    public Map<String, CounterStat> getPlacementCountersByName() {
        return this.placementCountersByName;
    }

    @Override
    public NodeSelector createNodeSelector(Optional<CatalogName> catalogName) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Supplier nodeMap = Suppliers.memoizeWithExpiration(() -> this.createNodeMap(catalogName), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        return new TopologyAwareNodeSelector(this.nodeManager, this.nodeTaskMap, this.includeCoordinator, (java.util.function.Supplier<NodeMap>)nodeMap, this.minCandidates, this.maxSplitsPerNode, this.maxPendingSplitsPerTask, this.placementCounters, this.networkTopology);
    }

    private NodeMap createNodeMap(Optional<CatalogName> catalogName) {
        Set nodes = catalogName.map(this.nodeManager::getActiveConnectorNodes).orElseGet(() -> this.nodeManager.getNodes(NodeState.ACTIVE));
        Set coordinatorNodeIds = (Set)this.nodeManager.getCoordinators().stream().map(InternalNode::getNodeIdentifier).collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap.Builder byHostAndPort = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder byHost = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder workersByNetworkPath = ImmutableSetMultimap.builder();
        for (InternalNode node : nodes) {
            if (this.includeCoordinator || !coordinatorNodeIds.contains(node.getNodeIdentifier())) {
                NetworkLocation location = this.networkTopology.locate(node.getHostAndPort());
                for (int i = 0; i <= location.getSegments().size(); ++i) {
                    workersByNetworkPath.put((Object)location.subLocation(0, i), (Object)node);
                }
            }
            try {
                byHostAndPort.put((Object)node.getHostAndPort(), (Object)node);
                InetAddress host = InetAddress.getByName(node.getInternalUri().getHost());
                byHost.put((Object)host, (Object)node);
            }
            catch (UnknownHostException e) {
                if (this.inaccessibleNodeLogCache.getIfPresent((Object)node) != null) continue;
                this.inaccessibleNodeLogCache.put((Object)node, (Object)true);
                LOG.warn((Throwable)e, "Unable to resolve host name for node: %s", new Object[]{node});
            }
        }
        return new NodeMap((SetMultimap<HostAddress, InternalNode>)byHostAndPort.build(), (SetMultimap<InetAddress, InternalNode>)byHost.build(), (SetMultimap<NetworkLocation, InternalNode>)workersByNetworkPath.build(), coordinatorNodeIds);
    }
}

