/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public final class ScalarFunctionAdapter {
    private static final MethodHandle IS_NULL_METHOD = ScalarFunctionAdapter.lookupIsNullMethod();
    private final NullAdaptationPolicy nullAdaptationPolicy;

    public ScalarFunctionAdapter(NullAdaptationPolicy nullAdaptationPolicy) {
        this.nullAdaptationPolicy = Objects.requireNonNull(nullAdaptationPolicy, "nullAdaptationPolicy is null");
    }

    public boolean canAdapt(InvocationConvention actualConvention, InvocationConvention expectedConvention) {
        Objects.requireNonNull(actualConvention, "actualConvention is null");
        Objects.requireNonNull(expectedConvention, "expectedConvention is null");
        Preconditions.checkArgument((expectedConvention.getArgumentConventions().size() == expectedConvention.getArgumentConventions().size() ? 1 : 0) != 0);
        if (actualConvention.supportsSession() && !expectedConvention.supportsSession()) {
            return false;
        }
        if (actualConvention.supportsInstanceFactor() && !expectedConvention.supportsInstanceFactor()) {
            return false;
        }
        if (!this.canAdaptReturn(actualConvention.getReturnConvention(), expectedConvention.getReturnConvention())) {
            return false;
        }
        for (int argumentIndex = 0; argumentIndex < actualConvention.getArgumentConventions().size(); ++argumentIndex) {
            InvocationConvention.InvocationArgumentConvention expectedArgumentConvention;
            InvocationConvention.InvocationArgumentConvention actualArgumentConvention = actualConvention.getArgumentConvention(argumentIndex);
            if (this.canAdaptParameter(actualArgumentConvention, expectedArgumentConvention = expectedConvention.getArgumentConvention(argumentIndex), expectedConvention.getReturnConvention())) continue;
            return false;
        }
        return true;
    }

    private boolean canAdaptReturn(InvocationConvention.InvocationReturnConvention actualReturnConvention, InvocationConvention.InvocationReturnConvention expectedReturnConvention) {
        if (actualReturnConvention == expectedReturnConvention) {
            return true;
        }
        if (expectedReturnConvention == InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN && actualReturnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
            return true;
        }
        if (expectedReturnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL && actualReturnConvention == InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN) {
            switch (this.nullAdaptationPolicy) {
                case THROW_ON_NULL: 
                case UNDEFINED_VALUE_FOR_NULL: {
                    return true;
                }
                case UNSUPPORTED: 
                case RETURN_NULL_ON_NULL: {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    private boolean canAdaptParameter(InvocationConvention.InvocationArgumentConvention actualArgumentConvention, InvocationConvention.InvocationArgumentConvention expectedArgumentConvention, InvocationConvention.InvocationReturnConvention returnConvention) {
        if (actualArgumentConvention == expectedArgumentConvention) {
            return true;
        }
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION || actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.FUNCTION) {
            return false;
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
            return true;
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) {
            return true;
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE || expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
                switch (this.nullAdaptationPolicy) {
                    case THROW_ON_NULL: 
                    case UNDEFINED_VALUE_FOR_NULL: {
                        return true;
                    }
                    case RETURN_NULL_ON_NULL: {
                        return returnConvention != InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL;
                    }
                    case UNSUPPORTED: {
                        return false;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public MethodHandle adapt(MethodHandle methodHandle, List<Type> actualArgumentTypes, InvocationConvention actualConvention, InvocationConvention expectedConvention) {
        Objects.requireNonNull(methodHandle, "methodHandle is null");
        Objects.requireNonNull(actualConvention, "actualConvention is null");
        Objects.requireNonNull(expectedConvention, "expectedConvention is null");
        Preconditions.checkArgument((actualConvention.getArgumentConventions().size() == expectedConvention.getArgumentConventions().size() ? 1 : 0) != 0);
        Preconditions.checkArgument((!actualConvention.supportsSession() || expectedConvention.supportsSession() ? 1 : 0) != 0, (Object)"Session method can not be adapted to no session");
        Preconditions.checkArgument((!actualConvention.supportsInstanceFactor() || expectedConvention.supportsInstanceFactor() ? 1 : 0) != 0, (Object)"Instance method can not be adapted to no instance");
        methodHandle = this.adaptReturn(methodHandle, actualConvention.getReturnConvention(), expectedConvention.getReturnConvention());
        int parameterIndex = 0;
        if (actualConvention.supportsInstanceFactor()) {
            ++parameterIndex;
        }
        if (actualConvention.supportsSession()) {
            ++parameterIndex;
        }
        for (int argumentIndex = 0; argumentIndex < actualConvention.getArgumentConventions().size(); ++argumentIndex) {
            Type argumentType = actualArgumentTypes.get(argumentIndex);
            InvocationConvention.InvocationArgumentConvention actualArgumentConvention = actualConvention.getArgumentConvention(argumentIndex);
            InvocationConvention.InvocationArgumentConvention expectedArgumentConvention = expectedConvention.getArgumentConvention(argumentIndex);
            methodHandle = this.adaptParameter(methodHandle, parameterIndex, argumentType, actualArgumentConvention, expectedArgumentConvention, expectedConvention.getReturnConvention());
            ++parameterIndex;
            if (expectedArgumentConvention != InvocationConvention.InvocationArgumentConvention.NULL_FLAG && expectedArgumentConvention != InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) continue;
            ++parameterIndex;
        }
        return methodHandle;
    }

    private MethodHandle adaptReturn(MethodHandle methodHandle, InvocationConvention.InvocationReturnConvention actualReturnConvention, InvocationConvention.InvocationReturnConvention expectedReturnConvention) {
        if (actualReturnConvention == expectedReturnConvention) {
            return methodHandle;
        }
        TypeDescriptor.OfField returnType = methodHandle.type().returnType();
        if (expectedReturnConvention == InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN && actualReturnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
            return MethodHandles.explicitCastArguments(methodHandle, methodHandle.type().changeReturnType(Primitives.wrap((Class)returnType)));
        }
        if (expectedReturnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL && actualReturnConvention == InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN) {
            if (this.nullAdaptationPolicy == NullAdaptationPolicy.UNSUPPORTED || this.nullAdaptationPolicy == NullAdaptationPolicy.RETURN_NULL_ON_NULL) {
                throw new IllegalArgumentException("Nullable return can not be adapted fail on null");
            }
            if (this.nullAdaptationPolicy == NullAdaptationPolicy.UNDEFINED_VALUE_FOR_NULL) {
                methodHandle = MethodHandles.explicitCastArguments(methodHandle, methodHandle.type().changeReturnType(Primitives.unwrap((Class)returnType)));
                return methodHandle;
            }
            if (this.nullAdaptationPolicy == NullAdaptationPolicy.THROW_ON_NULL) {
                MethodHandle adapter = MethodHandles.identity(returnType);
                adapter = MethodHandles.explicitCastArguments(adapter, adapter.type().changeReturnType(Primitives.unwrap((Class)returnType)));
                adapter = MethodHandles.guardWithTest(ScalarFunctionAdapter.isNullArgument(adapter.type(), 0), ScalarFunctionAdapter.throwPrestoNullArgumentException(adapter.type()), adapter);
                return MethodHandles.filterReturnValue(methodHandle, adapter);
            }
        }
        throw new IllegalArgumentException("Unsupported return convention: " + actualReturnConvention);
    }

    private MethodHandle adaptParameter(MethodHandle methodHandle, int parameterIndex, Type argumentType, InvocationConvention.InvocationArgumentConvention actualArgumentConvention, InvocationConvention.InvocationArgumentConvention expectedArgumentConvention, InvocationConvention.InvocationReturnConvention returnConvention) {
        if (actualArgumentConvention == expectedArgumentConvention) {
            return methodHandle;
        }
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) {
            throw new IllegalArgumentException("Block and position argument can not be adapted");
        }
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.FUNCTION) {
            throw new IllegalArgumentException("Function argument can not be adapted");
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
                if (Primitives.isWrapperType((Class)methodHandle.type().parameterType(parameterIndex))) {
                    MethodType targetType = methodHandle.type().changeParameterType(parameterIndex, Primitives.unwrap((Class)methodHandle.type().parameterType(parameterIndex)));
                    methodHandle = MethodHandles.explicitCastArguments(methodHandle, targetType);
                }
                return methodHandle;
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                return MethodHandles.insertArguments(methodHandle, parameterIndex + 1, false);
            }
            throw new IllegalArgumentException("Unsupported actual argument convention: " + actualArgumentConvention);
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.UNSUPPORTED) {
                    throw new IllegalArgumentException("Not null argument can not be adapted to nullable");
                }
                Class boxedType = Primitives.wrap((Class)methodHandle.type().parameterType(parameterIndex));
                MethodType targetType = methodHandle.type().changeParameterType(parameterIndex, boxedType);
                methodHandle = MethodHandles.explicitCastArguments(methodHandle, targetType);
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.UNDEFINED_VALUE_FOR_NULL) {
                    return methodHandle;
                }
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.RETURN_NULL_ON_NULL) {
                    if (returnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
                        throw new IllegalArgumentException("RETURN_NULL_ON_NULL adaptation can not be used with FAIL_ON_NULL return convention");
                    }
                    return MethodHandles.guardWithTest(ScalarFunctionAdapter.isNullArgument(methodHandle.type(), parameterIndex), ScalarFunctionAdapter.returnNull(methodHandle.type()), methodHandle);
                }
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.THROW_ON_NULL) {
                    MethodType adapterType = MethodType.methodType(boxedType, boxedType);
                    MethodHandle adapter = MethodHandles.guardWithTest(ScalarFunctionAdapter.isNullArgument(adapterType, 0), ScalarFunctionAdapter.throwPrestoNullArgumentException(adapterType), MethodHandles.identity(boxedType));
                    return MethodHandles.collectArguments(methodHandle, parameterIndex, adapter);
                }
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                TypeDescriptor.OfField parameterType = methodHandle.type().parameterType(parameterIndex);
                methodHandle = MethodHandles.explicitCastArguments(methodHandle, methodHandle.type().changeParameterType(parameterIndex, Primitives.wrap((Class)parameterType)));
                methodHandle = MethodHandles.filterArguments(methodHandle, parameterIndex + 1, MethodHandles.explicitCastArguments(IS_NULL_METHOD, MethodType.methodType(Boolean.TYPE, Primitives.wrap((Class)parameterType))));
                int[] reorder = IntStream.range(0, methodHandle.type().parameterCount()).map(i -> i <= parameterIndex ? i : i - 1).toArray();
                MethodType newType = methodHandle.type().dropParameterTypes(parameterIndex + 1, parameterIndex + 2);
                methodHandle = MethodHandles.permuteArguments(methodHandle, newType, reorder);
                return methodHandle;
            }
            throw new IllegalArgumentException("Unsupported actual argument convention: " + actualArgumentConvention);
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.UNSUPPORTED) {
                    throw new IllegalArgumentException("Not null argument can not be adapted to nullable");
                }
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.UNDEFINED_VALUE_FOR_NULL) {
                    methodHandle = MethodHandles.dropArguments(methodHandle, parameterIndex + 1, new Class[]{Boolean.TYPE});
                    return methodHandle;
                }
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.RETURN_NULL_ON_NULL) {
                    if (returnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
                        throw new IllegalArgumentException("RETURN_NULL_ON_NULL adaptation can not be used with FAIL_ON_NULL return convention");
                    }
                    methodHandle = MethodHandles.dropArguments(methodHandle, parameterIndex + 1, new Class[]{Boolean.TYPE});
                    return MethodHandles.guardWithTest(ScalarFunctionAdapter.isTrueNullFlag(methodHandle.type(), parameterIndex), ScalarFunctionAdapter.returnNull(methodHandle.type()), methodHandle);
                }
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.THROW_ON_NULL) {
                    MethodHandle adapter = MethodHandles.identity(methodHandle.type().parameterType(parameterIndex));
                    adapter = MethodHandles.dropArguments(adapter, 1, new Class[]{Boolean.TYPE});
                    adapter = MethodHandles.guardWithTest(ScalarFunctionAdapter.isTrueNullFlag(adapter.type(), 0), ScalarFunctionAdapter.throwPrestoNullArgumentException(adapter.type()), adapter);
                    return MethodHandles.collectArguments(methodHandle, parameterIndex, adapter);
                }
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
                return MethodHandles.collectArguments(methodHandle, parameterIndex, ScalarFunctionAdapter.boxedToNullFlagFilter(methodHandle.type().parameterType(parameterIndex)));
            }
            throw new IllegalArgumentException("Unsupported actual argument convention: " + actualArgumentConvention);
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) {
            MethodHandle getBlockValue = ScalarFunctionAdapter.getBlockValue(argumentType);
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.UNDEFINED_VALUE_FOR_NULL) {
                    methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, getBlockValue);
                    return methodHandle;
                }
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.RETURN_NULL_ON_NULL && returnConvention != InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
                    methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, getBlockValue);
                    return MethodHandles.guardWithTest(ScalarFunctionAdapter.isBlockPositionNull(methodHandle.type(), parameterIndex), ScalarFunctionAdapter.returnNull(methodHandle.type()), methodHandle);
                }
                if (this.nullAdaptationPolicy == NullAdaptationPolicy.THROW_ON_NULL || this.nullAdaptationPolicy == NullAdaptationPolicy.UNSUPPORTED || this.nullAdaptationPolicy == NullAdaptationPolicy.RETURN_NULL_ON_NULL) {
                    MethodHandle adapter = MethodHandles.guardWithTest(ScalarFunctionAdapter.isBlockPositionNull(getBlockValue.type(), 0), ScalarFunctionAdapter.throwPrestoNullArgumentException(getBlockValue.type()), getBlockValue);
                    return MethodHandles.collectArguments(methodHandle, parameterIndex, adapter);
                }
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
                getBlockValue = MethodHandles.explicitCastArguments(getBlockValue, getBlockValue.type().changeReturnType(Primitives.wrap((Class)getBlockValue.type().returnType())));
                getBlockValue = MethodHandles.guardWithTest(ScalarFunctionAdapter.isBlockPositionNull(getBlockValue.type(), 0), ScalarFunctionAdapter.returnNull(getBlockValue.type()), getBlockValue);
                methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, getBlockValue);
                return methodHandle;
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                MethodHandle isNull = ScalarFunctionAdapter.isBlockPositionNull(getBlockValue.type(), 0);
                methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex + 1, isNull);
                getBlockValue = MethodHandles.guardWithTest(ScalarFunctionAdapter.isBlockPositionNull(getBlockValue.type(), 0), ScalarFunctionAdapter.returnNull(getBlockValue.type()), getBlockValue);
                methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, getBlockValue);
                int[] reorder = IntStream.range(0, methodHandle.type().parameterCount()).map(i -> i <= parameterIndex + 1 ? i : i - 2).toArray();
                MethodType newType = methodHandle.type().dropParameterTypes(parameterIndex + 2, parameterIndex + 4);
                methodHandle = MethodHandles.permuteArguments(methodHandle, newType, reorder);
                return methodHandle;
            }
            throw new IllegalArgumentException("Unsupported actual argument convention: " + actualArgumentConvention);
        }
        throw new IllegalArgumentException("Unsupported expected argument convention: " + expectedArgumentConvention);
    }

    private static MethodHandle getBlockValue(Type argumentType) {
        String getterName;
        Class<Object> methodArgumentType = argumentType.getJavaType();
        if (methodArgumentType == Boolean.TYPE) {
            getterName = "getBoolean";
        } else if (methodArgumentType == Long.TYPE) {
            getterName = "getLong";
        } else if (methodArgumentType == Double.TYPE) {
            getterName = "getDouble";
        } else if (methodArgumentType == Slice.class) {
            getterName = "getSlice";
        } else {
            getterName = "getObject";
            methodArgumentType = Object.class;
        }
        try {
            MethodHandle getValue = MethodHandles.lookup().findVirtual(Type.class, getterName, MethodType.methodType(methodArgumentType, Block.class, Integer.TYPE)).bindTo(argumentType);
            return MethodHandles.explicitCastArguments(getValue, getValue.type().changeReturnType(argumentType.getJavaType()));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle boxedToNullFlagFilter(Class<?> argumentType) {
        MethodHandle handle = MethodHandles.identity(argumentType);
        if (Primitives.isWrapperType(argumentType)) {
            handle = MethodHandles.explicitCastArguments(handle, handle.type().changeParameterType(0, Primitives.unwrap(argumentType)));
        }
        handle = MethodHandles.dropArguments(handle, 1, new Class[]{Boolean.TYPE});
        return MethodHandles.guardWithTest(ScalarFunctionAdapter.isTrueNullFlag(handle.type(), 0), ScalarFunctionAdapter.returnNull(handle.type()), handle);
    }

    private static MethodHandle isTrueNullFlag(MethodType methodType, int index) {
        return MethodHandles.permuteArguments(MethodHandles.identity(Boolean.TYPE), methodType.changeReturnType(Boolean.TYPE), index + 1);
    }

    private static MethodHandle isNullArgument(MethodType methodType, int index) {
        MethodHandle isNull = IS_NULL_METHOD;
        isNull = MethodHandles.explicitCastArguments(isNull, MethodType.methodType(Boolean.TYPE, methodType.parameterType(index)));
        isNull = MethodHandles.permuteArguments(isNull, methodType.changeReturnType(Boolean.TYPE), index);
        return isNull;
    }

    private static MethodHandle isBlockPositionNull(MethodType methodType, int index) {
        MethodHandle isNull;
        try {
            isNull = MethodHandles.lookup().findVirtual(Block.class, "isNull", MethodType.methodType(Boolean.TYPE, Integer.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        isNull = MethodHandles.permuteArguments(isNull, methodType.changeReturnType(Boolean.TYPE), index, index + 1);
        return isNull;
    }

    private static MethodHandle lookupIsNullMethod() {
        MethodHandle isNull;
        try {
            isNull = MethodHandles.lookup().findStatic(Objects.class, "isNull", MethodType.methodType(Boolean.TYPE, Object.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        return isNull;
    }

    private static MethodHandle returnNull(MethodType methodType) {
        MethodHandle returnNull = MethodHandles.constant(Primitives.wrap((Class)methodType.returnType()), null);
        returnNull = MethodHandles.permuteArguments(returnNull, methodType.changeReturnType(Primitives.wrap((Class)methodType.returnType())), new int[0]);
        returnNull = MethodHandles.explicitCastArguments(returnNull, methodType);
        return returnNull;
    }

    private static MethodHandle throwPrestoNullArgumentException(MethodType type) {
        MethodHandle throwException = MethodHandles.collectArguments(MethodHandles.throwException(type.returnType(), PrestoException.class), 0, ScalarFunctionAdapter.prestoNullArgumentException());
        return MethodHandles.permuteArguments(throwException, type, new int[0]);
    }

    private static MethodHandle prestoNullArgumentException() {
        try {
            return MethodHandles.publicLookup().findConstructor(PrestoException.class, MethodType.methodType(Void.TYPE, ErrorCodeSupplier.class, String.class)).bindTo(StandardErrorCode.INVALID_FUNCTION_ARGUMENT).bindTo("A never null argument is null");
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum NullAdaptationPolicy {
        UNSUPPORTED,
        THROW_ON_NULL,
        RETURN_NULL_ON_NULL,
        UNDEFINED_VALUE_FOR_NULL;

    }
}

