/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.util.MorePredicates;
import java.util.List;

public final class JoinUtils {
    private JoinUtils() {
    }

    public static List<Page> channelsToPages(List<List<Block>> channels) {
        ImmutableList.Builder pagesBuilder = ImmutableList.builder();
        if (!channels.isEmpty()) {
            int pagesCount = channels.get(0).size();
            for (int pageIndex = 0; pageIndex < pagesCount; ++pageIndex) {
                Block[] blocks = new Block[channels.size()];
                for (int channelIndex = 0; channelIndex < channels.size(); ++channelIndex) {
                    blocks[channelIndex] = channels.get(channelIndex).get(pageIndex);
                }
                pagesBuilder.add((Object)new Page(blocks));
            }
        }
        return pagesBuilder.build();
    }

    public static boolean isBuildSideReplicated(JoinNode joinNode) {
        return PlanNodeSearcher.searchFrom(joinNode.getRight()).recurseOnlyWhen(MorePredicates.isInstanceOfAny(ProjectNode.class).or(JoinUtils::isLocalRepartitionExchange)).where(JoinUtils::isRemoteReplicatedExchange).matches();
    }

    private static boolean isRemoteReplicatedExchange(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == ExchangeNode.Scope.REMOTE && exchangeNode.getType() == ExchangeNode.Type.REPLICATE;
    }

    private static boolean isLocalRepartitionExchange(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == ExchangeNode.Scope.LOCAL && exchangeNode.getType() == ExchangeNode.Type.REPARTITION;
    }
}

