/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.operator.annotations.ImplementationDependency;
import io.prestosql.spi.function.InvocationConvention;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import java.util.Optional;

public abstract class ScalarImplementationDependency
implements ImplementationDependency {
    private final Optional<InvocationConvention> invocationConvention;

    protected ScalarImplementationDependency(Optional<InvocationConvention> invocationConvention) {
        this.invocationConvention = Objects.requireNonNull(invocationConvention, "invocationConvention is null");
        if (invocationConvention.map(InvocationConvention::supportsInstanceFactor).orElse(false).booleanValue()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not support instance functions");
        }
    }

    protected abstract ResolvedFunction getResolvedFunction(BoundVariables var1, Metadata var2);

    @Override
    public MethodHandle resolve(BoundVariables boundVariables, Metadata metadata) {
        ResolvedFunction resolvedFunction = this.getResolvedFunction(boundVariables, metadata);
        return metadata.getScalarFunctionInvoker(resolvedFunction, this.invocationConvention).getMethodHandle();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

