/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameterSpecialization;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.EQUAL)
public final class ArrayEqualOperator {
    private ArrayEqualOperator() {
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equals(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        boolean indeterminate = false;
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            if (leftArray.isNull(i) || rightArray.isNull(i)) {
                indeterminate = true;
                continue;
            }
            Object leftElement = TypeUtils.readNativeValue((Type)type, (Block)leftArray, (int)i);
            Object rightElement = TypeUtils.readNativeValue((Type)type, (Block)rightArray, (int)i);
            try {
                Boolean result = equalsFunction.invoke(leftElement, rightElement);
                if (result == null) {
                    indeterminate = true;
                    continue;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (indeterminate) {
            return null;
        }
        return true;
    }

    @TypeParameter(value="E")
    @TypeParameterSpecialization(name="E", nativeContainerType=long.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equalsLong(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        boolean indeterminate = false;
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            if (leftArray.isNull(i) || rightArray.isNull(i)) {
                indeterminate = true;
                continue;
            }
            long leftElement = type.getLong(leftArray, i);
            long rightElement = type.getLong(rightArray, i);
            try {
                Boolean result = equalsFunction.invokeExact(leftElement, rightElement);
                if (result == null) {
                    indeterminate = true;
                    continue;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (indeterminate) {
            return null;
        }
        return true;
    }

    @TypeParameter(value="E")
    @TypeParameterSpecialization(name="E", nativeContainerType=double.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equalsDouble(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        boolean indeterminate = false;
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            if (leftArray.isNull(i) || rightArray.isNull(i)) {
                indeterminate = true;
                continue;
            }
            double leftElement = type.getDouble(leftArray, i);
            double rightElement = type.getDouble(rightArray, i);
            try {
                Boolean result = equalsFunction.invokeExact(leftElement, rightElement);
                if (result == null) {
                    indeterminate = true;
                    continue;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (indeterminate) {
            return null;
        }
        return true;
    }
}

