/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.OperatorNotFoundException;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.type.JsonType;
import io.prestosql.type.Timestamps;
import io.prestosql.type.UnknownType;
import io.prestosql.util.Failures;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;

public final class FormatFunction
extends SqlScalarFunction {
    public static final String NAME = "$format";
    public static final FormatFunction FORMAT_FUNCTION = new FormatFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(FormatFunction.class, "sqlFormat", List.class, ConnectorSession.class, Slice.class, Block.class);

    private FormatFunction() {
        super(new FunctionMetadata(Signature.builder().name(NAME).typeVariableConstraints(Signature.withVariadicBound("T", "row")).argumentTypes(VarcharType.VARCHAR.getTypeSignature(), new TypeSignature("T", new TypeSignatureParameter[0])).returnType(VarcharType.VARCHAR.getTypeSignature()).build(), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), true, true, "formats the input arguments using a format string", FunctionKind.SCALAR));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        Type rowType = boundVariables.getTypeVariable("T");
        List converters = (List)Streams.mapWithIndex(rowType.getTypeParameters().stream(), (type, index) -> FormatFunction.converter(metadata, type, Math.toIntExact(index))).collect(ImmutableList.toImmutableList());
        return new ScalarFunctionImplementation(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), METHOD_HANDLE.bindTo(converters));
    }

    public static void validateType(Metadata metadata, Type type) {
        FormatFunction.valueConverter(metadata, type, 0);
    }

    @UsedByGeneratedCode
    public static Slice sqlFormat(List<BiFunction<ConnectorSession, Block, Object>> converters, ConnectorSession session, Slice slice, Block row) {
        Object[] args = new Object[converters.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = converters.get(i).apply(session, row);
        }
        return FormatFunction.sqlFormat(session, slice.toStringUtf8(), args);
    }

    private static Slice sqlFormat(ConnectorSession session, String format, Object[] args) {
        try {
            return Slices.utf8Slice((String)String.format(session.getLocale(), format, args));
        }
        catch (IllegalFormatException e) {
            String message = e.toString().replaceFirst("^java\\.util\\.(\\w+)Exception", "$1");
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid format string: %s (%s)", format, message), (Throwable)e);
        }
    }

    private static BiFunction<ConnectorSession, Block, Object> converter(Metadata metadata, Type type, int position) {
        BiFunction<ConnectorSession, Block, Object> converter = FormatFunction.valueConverter(metadata, type, position);
        return (session, block) -> block.isNull(position) ? null : converter.apply((ConnectorSession)session, (Block)block);
    }

    private static BiFunction<ConnectorSession, Block, Object> valueConverter(Metadata metadata, Type type, int position) {
        if (type.equals((Object)UnknownType.UNKNOWN)) {
            return (session, block) -> null;
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return (session, block) -> type.getBoolean(block, position);
        }
        if (type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT)) {
            return (session, block) -> type.getLong(block, position);
        }
        if (type.equals(RealType.REAL)) {
            return (session, block) -> Float.valueOf(Float.intBitsToFloat(Math.toIntExact(type.getLong(block, position))));
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return (session, block) -> type.getDouble(block, position);
        }
        if (type.equals(DateType.DATE)) {
            return (session, block) -> LocalDate.ofEpochDay(type.getLong(block, position));
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return (session, block) -> Timestamps.toZonedDateTime((TimestampWithTimeZoneType)type, block, position);
        }
        if (type instanceof TimestampType) {
            return (session, block) -> Timestamps.toLocalDateTime((TimestampType)type, session, block, position);
        }
        if (type.equals(TimeType.TIME)) {
            return (session, block) -> FormatFunction.toLocalTime(session, type.getLong(block, position));
        }
        if (type.equals((Object)JsonType.JSON)) {
            ResolvedFunction function = metadata.resolveFunction(QualifiedName.of((String)"json_format"), TypeSignatureProvider.fromTypes(new Type[]{JsonType.JSON}));
            MethodHandle handle = metadata.getScalarFunctionInvoker(function, Optional.empty()).getMethodHandle();
            return (session, block) -> FormatFunction.convertToString(handle, type.getSlice(block, position));
        }
        if (Decimals.isShortDecimal((Type)type)) {
            int scale = ((DecimalType)type).getScale();
            return (session, block) -> BigDecimal.valueOf(type.getLong(block, position), scale);
        }
        if (Decimals.isLongDecimal((Type)type)) {
            int scale = ((DecimalType)type).getScale();
            return (session, block) -> new BigDecimal(Decimals.decodeUnscaledValue((Slice)type.getSlice(block, position)), scale);
        }
        if (Varchars.isVarcharType((Type)type)) {
            return (session, block) -> type.getSlice(block, position).toStringUtf8();
        }
        if (Chars.isCharType((Type)type)) {
            CharType charType = (CharType)type;
            return (session, block) -> Chars.padSpaces((Slice)type.getSlice(block, position), (CharType)charType).toStringUtf8();
        }
        BiFunction<ConnectorSession, Block, Object> function = type.getJavaType() == Long.TYPE ? (session, block) -> type.getLong(block, position) : (type.getJavaType() == Double.TYPE ? (session, block) -> type.getDouble(block, position) : (type.getJavaType() == Boolean.TYPE ? (session, block) -> type.getBoolean(block, position) : (type.getJavaType() == Slice.class ? (session, block) -> type.getSlice(block, position) : (session, block) -> type.getObject(block, position))));
        MethodHandle handle = FormatFunction.castToVarchar(metadata, type);
        if (handle == null || handle.type().parameterCount() != 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Type not supported for formatting: " + type.getDisplayName());
        }
        return (session, block) -> FormatFunction.convertToString(handle, function.apply((ConnectorSession)session, (Block)block));
    }

    private static MethodHandle castToVarchar(Metadata metadata, Type type) {
        try {
            ResolvedFunction cast = metadata.getCoercion(type, (Type)VarcharType.VARCHAR);
            return metadata.getScalarFunctionInvoker(cast, Optional.empty()).getMethodHandle();
        }
        catch (OperatorNotFoundException e) {
            return null;
        }
    }

    private static LocalTime toLocalTime(ConnectorSession session, long value) {
        if (session.isLegacyTimestamp()) {
            Instant instant = Instant.ofEpochMilli(value);
            ZoneId zoneId = ZoneId.of(session.getTimeZoneKey().getId());
            return ZonedDateTime.ofInstant(instant, zoneId).toLocalTime();
        }
        return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(value));
    }

    private static Object convertToString(MethodHandle handle, Object value) {
        try {
            return handle.invoke(value).toStringUtf8();
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

