/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.sql.gen.CachedInstanceBinder;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.InvokeFunctionBytecodeExpression;
import io.prestosql.sql.gen.SqlTypeBytecodeExpression;
import io.prestosql.type.UnknownType;
import io.prestosql.util.CompilerUtils;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class RowIndeterminateOperator
extends SqlOperator {
    public static final RowIndeterminateOperator ROW_INDETERMINATE = new RowIndeterminateOperator();

    private RowIndeterminateOperator() {
        super(OperatorType.INDETERMINATE, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.withVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false);
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type type = boundVariables.getTypeVariable("T");
        Class<?> indeterminateOperatorClass = RowIndeterminateOperator.generateIndeterminate(type, metadata);
        MethodHandle indeterminateMethod = Reflection.methodHandle(indeterminateOperatorClass, "indeterminate", type.getJavaType(), Boolean.TYPE);
        return new ScalarFunctionImplementation(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG)), indeterminateMethod);
    }

    private static Class<?> generateIndeterminate(Type type, Metadata metadata) {
        CallSiteBinder binder = new CallSiteBinder();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("RowIndeterminateOperator"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        Parameter value = Parameter.arg((String)"value", (Class)type.getJavaType());
        Parameter isNull = Parameter.arg((String)"isNull", Boolean.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "indeterminate", ParameterizedType.type(Boolean.TYPE), new Parameter[]{value, isNull});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        body.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(definition, binder);
        LabelNode end = new LabelNode("end");
        List fieldTypes = type.getTypeParameters();
        boolean hasUnknownFields = fieldTypes.stream().anyMatch(fieldType -> fieldType.equals((Object)UnknownType.UNKNOWN));
        body.append((BytecodeNode)new IfStatement("if isNull is true...", new Object[0]).condition((BytecodeNode)isNull).ifTrue((BytecodeNode)new BytecodeBlock().push(true).gotoLabel(end)));
        if (hasUnknownFields) {
            body.push(true).gotoLabel(end);
        } else {
            for (int i = 0; i < fieldTypes.size(); ++i) {
                IfStatement ifNullField = new IfStatement("if the field is null...", new Object[0]);
                ifNullField.condition((BytecodeNode)value.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)})).ifTrue((BytecodeNode)new BytecodeBlock().push(true).gotoLabel(end));
                ResolvedFunction resolvedFunction = metadata.resolveOperator(OperatorType.INDETERMINATE, (List<? extends Type>)ImmutableList.of((Object)((Type)fieldTypes.get(i))));
                BytecodeExpression element = SqlTypeBytecodeExpression.constantType(binder, (Type)fieldTypes.get(i)).getValue((BytecodeExpression)value, BytecodeExpressions.constantInt((int)i));
                ifNullField.ifFalse((BytecodeNode)new IfStatement("if the field is not null but indeterminate...", new Object[0]).condition((BytecodeNode)InvokeFunctionBytecodeExpression.invokeFunction(scope, cachedInstanceBinder, resolvedFunction, metadata, element)).ifTrue((BytecodeNode)new BytecodeBlock().push(true).gotoLabel(end)));
                body.append((BytecodeNode)ifNullField);
            }
            body.push(false);
        }
        body.visitLabel(end).retBoolean();
        MethodDefinition constructorDefinition = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), RowIndeterminateOperator.class.getClassLoader());
    }
}

