/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@Description(value="Add the specified amount of time to the given timestamp")
@ScalarFunction(value="date_add")
public class DateAdd {
    private DateAdd() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static long add(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="timestamp(p)") long timestamp) {
        long epochMillis = timestamp;
        int microFraction = 0;
        if (precision > 3L) {
            epochMillis = Timestamps.scaleEpochMicrosToMillis(timestamp);
            microFraction = Timestamps.getMicrosOfMilli(timestamp);
        }
        long result = session.isLegacyTimestamp() ? DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).add(epochMillis, Math.toIntExact(value)) : DateTimeFunctions.getTimestampField(ISOChronology.getInstanceUTC(), unit).add(epochMillis, Math.toIntExact(value));
        if (precision <= 3L) {
            return Timestamps.round(result, (int)(3L - precision));
        }
        return Timestamps.scaleEpochMillisToMicros(result) + (long)microFraction;
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp add(ConnectorSession session, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return new LongTimestamp(DateAdd.add(6L, session, unit, value, timestamp.getEpochMicros()), timestamp.getPicosOfMicro());
    }
}

