/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

@ScalarOperator(value=OperatorType.CAST)
public final class DateToTimestampCast {
    private DateToTimestampCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p)")
    public static long cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="date") long date) {
        long result;
        if (session.isLegacyTimestamp()) {
            long utcMillis = TimeUnit.DAYS.toMillis(date);
            ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
            result = utcMillis - (long)chronology.getZone().getOffset(utcMillis);
        } else {
            result = TimeUnit.DAYS.toMillis(date);
        }
        if (precision > 3L) {
            return Timestamps.scaleEpochMillisToMicros(result);
        }
        return result;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp cast(ConnectorSession session, @SqlType(value="date") long date) {
        return new LongTimestamp(DateToTimestampCast.cast(6L, session, date), 0);
    }
}

