/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@Description(value="Minute of the hour of the given timestamp")
@ScalarFunction(value="minute")
public class ExtractMinute {
    private ExtractMinute() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp) {
        if (precision > 3L) {
            timestamp = Timestamps.scaleEpochMicrosToMillis(timestamp);
        }
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        if (session.isLegacyTimestamp()) {
            chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        }
        return chronology.minuteOfHour().get(timestamp);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return ExtractMinute.extract(6L, session, timestamp.getEpochMicros());
    }
}

