/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;

@Description(value="Formats the given time by the given format")
@ScalarFunction(value="format_datetime")
public class FormatDateTime {
    private FormatDateTime() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        ISOChronology chronology;
        if (precision > 3L) {
            timestamp = Timestamps.scaleEpochMicrosToMillis(Timestamps.round(timestamp, 3));
        }
        if (session.isLegacyTimestamp()) {
            chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        } else {
            if (FormatDateTime.datetimeFormatSpecifiesZone(formatString)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "format_datetime for TIMESTAMP type, cannot use 'Z' nor 'z' in format, as this type does not contain TZ information");
            }
            chronology = ISOChronology.getInstanceUTC();
        }
        try {
            return Slices.utf8Slice((String)DateTimeFormat.forPattern((String)formatString.toStringUtf8()).withChronology((Chronology)chronology).withLocale(session.getLocale()).print(timestamp));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice formatDatetime(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        return FormatDateTime.format(6L, session, timestamp.getEpochMicros(), formatString);
    }

    private static boolean datetimeFormatSpecifiesZone(Slice formatString) {
        boolean quoted = false;
        for (char c : formatString.toStringUtf8().toCharArray()) {
            if (quoted) {
                if (c != '\'') continue;
                quoted = false;
                continue;
            }
            switch (c) {
                case 'Z': 
                case 'z': {
                    return true;
                }
                case '\'': {
                    quoted = true;
                }
            }
        }
        return false;
    }
}

