/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.TimeWithTimeZoneOperators;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import org.joda.time.chrono.ISOChronology;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeWithTimezoneToTimestampCast {
    private TimeWithTimezoneToTimestampCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p)")
    public static long cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="time with time zone") long time) {
        long epochMillis;
        if (session.isLegacyTimestamp()) {
            epochMillis = DateTimeEncoding.unpackMillisUtc((long)time);
        } else {
            long currentMillisOfDay = ChronoField.MILLI_OF_DAY.getFrom(Instant.ofEpochMilli(TimeWithTimeZoneOperators.REFERENCE_TIMESTAMP_UTC).atZone(ZoneOffset.UTC));
            long timeMillisUtcInCurrentDay = TimeWithTimeZoneOperators.REFERENCE_TIMESTAMP_UTC - currentMillisOfDay + DateTimeEncoding.unpackMillisUtc((long)time);
            ISOChronology chronology = DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)time));
            epochMillis = DateTimeEncoding.unpackMillisUtc((long)time) + (long)chronology.getZone().getOffset(timeMillisUtcInCurrentDay);
        }
        if (precision > 3L) {
            return Timestamps.scaleEpochMillisToMicros(epochMillis);
        }
        if (precision < 3L) {
            return Timestamps.round(epochMillis, (int)(3L - precision));
        }
        return epochMillis;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp cast(ConnectorSession session, @SqlType(value="time with time zone") long time) {
        return new LongTimestamp(TimeWithTimezoneToTimestampCast.cast(6L, session, time), 0);
    }
}

