/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.airlift.slice.XxHash64;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.TimestampTypes;
import io.prestosql.type.Constraint;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public final class TimestampOperators {
    private TimestampOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusTimestamp {
        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") long left, @SqlType(value="timestamp(p)") long right) {
            long interval = left - right;
            if (precision > 3L) {
                interval = Timestamps.round(interval, 3);
                interval = Timestamps.rescale(interval, 6, 3);
            }
            return interval;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="timestamp(p)") LongTimestamp left, @SqlType(value="timestamp(p)") LongTimestamp right) {
            return TimestampMinusTimestamp.subtract(6L, left.getEpochMicros(), right.getEpochMicros());
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusIntervalDayToSecond {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static long subtract(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="interval day to second") long interval) {
            return TimestampPlusIntervalDayToSecond.add(precision, timestamp, -interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestamp subtract(@SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="interval day to second") long interval) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, -interval);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusIntervalYearToMonth {
        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static long subtract(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="interval year to month") long interval) {
            return TimestampPlusIntervalYearToMonth.add(precision, session, timestamp, -interval);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static LongTimestamp subtract(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="interval year to month") long interval) {
            return TimestampPlusIntervalYearToMonth.add(session, timestamp, -interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class IntervalYearToMonthPlusTimestamp {
        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static long add(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="interval year to month") long interval, @SqlType(value="timestamp(p)") long timestamp) {
            return TimestampPlusIntervalYearToMonth.add(precision, session, timestamp, interval);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static LongTimestamp add(ConnectorSession session, @SqlType(value="interval year to month") long interval, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
            return TimestampPlusIntervalYearToMonth.add(session, timestamp, interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class TimestampPlusIntervalYearToMonth {
        private static final DateTimeField MONTH_OF_YEAR_UTC = ISOChronology.getInstanceUTC().monthOfYear();

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static long add(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="interval year to month") long interval) {
            long fractionMicros = 0L;
            if (precision > 3L) {
                fractionMicros = Timestamps.getMicrosOfMilli(timestamp);
                timestamp = Timestamps.scaleEpochMicrosToMillis(timestamp);
            }
            long result = session.isLegacyTimestamp() ? DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).monthOfYear().add(timestamp, interval) : MONTH_OF_YEAR_UTC.add(timestamp, interval);
            if (precision > 3L) {
                return Timestamps.scaleEpochMillisToMicros(result) + fractionMicros;
            }
            return result;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static LongTimestamp add(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="interval year to month") long interval) {
            return new LongTimestamp(TimestampPlusIntervalYearToMonth.add(6L, session, timestamp.getEpochMicros(), interval), timestamp.getPicosOfMicro());
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class IntervalDayToSecondPlusTimestamp {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@LiteralParameter(value="p") long precision, @SqlType(value="interval day to second") long interval, @SqlType(value="timestamp(p)") long timestamp) {
            return TimestampPlusIntervalDayToSecond.add(precision, timestamp, interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestamp add(@SqlType(value="interval day to second") long interval, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class TimestampPlusIntervalDayToSecond {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="interval day to second") long interval) {
            if (precision > 3L) {
                interval = Math.multiplyExact(interval, 1000);
            }
            return timestamp + interval;
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestamp add(@SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="interval day to second") long interval) {
            return new LongTimestamp(timestamp.getEpochMicros() + Math.multiplyExact(interval, 1000), timestamp.getPicosOfMicro());
        }
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    public static final class XxHash64Operator {
        @LiteralParameters(value={"p"})
        @SqlType(value="bigint")
        public static long xxHash64(@SqlType(value="timestamp(p)") long value) {
            return XxHash64.hash((long)value);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="bigint")
        public static long xxHash64(@SqlType(value="timestamp(p)") LongTimestamp value) {
            return XxHash64.hash((long)value.getEpochMicros()) ^ XxHash64.hash((long)value.getPicosOfMicro());
        }
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    public static final class Indeterminate {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean indeterminate(@SqlType(value="timestamp(p)") long value, @IsNull boolean isNull) {
            return isNull;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean indeterminate(@SqlType(value="timestamp(p)") LongTimestamp value, @IsNull boolean isNull) {
            return isNull;
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static final class HashCode {
        @SqlType(value="bigint")
        @LiteralParameters(value={"p"})
        public static long hashCode(@SqlType(value="timestamp(p)") long value) {
            return TimestampTypes.hashShortTimestamp((long)value);
        }

        @SqlType(value="bigint")
        @LiteralParameters(value={"p"})
        public static long hashCode(@SqlType(value="timestamp(p)") LongTimestamp value) {
            return TimestampTypes.hashLongTimestamp((LongTimestamp)value);
        }
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    public static final class GreaterThanOrEqual {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThanOrEqual(@SqlType(value="timestamp(p)") long left, @SqlType(value="timestamp(p)") long right) {
            return left >= right;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThanOrEqual(@SqlType(value="timestamp(p)") LongTimestamp left, @SqlType(value="timestamp(p)") LongTimestamp right) {
            return !LessThan.lessThan(left, right);
        }
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    public static final class GreaterThan {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThan(@SqlType(value="timestamp(p)") long left, @SqlType(value="timestamp(p)") long right) {
            return left > right;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThan(@SqlType(value="timestamp(p)") LongTimestamp left, @SqlType(value="timestamp(p)") LongTimestamp right) {
            return !LessThanOrEqual.lessThanOrEqual(left, right);
        }
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    public static final class LessThanOrEqual {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThanOrEqual(@SqlType(value="timestamp(p)") long left, @SqlType(value="timestamp(p)") long right) {
            return left <= right;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThanOrEqual(@SqlType(value="timestamp(p)") LongTimestamp left, @SqlType(value="timestamp(p)") LongTimestamp right) {
            return left.getEpochMicros() < right.getEpochMicros() || left.getEpochMicros() == right.getEpochMicros() && left.getPicosOfMicro() <= right.getPicosOfMicro();
        }
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    public static final class LessThan {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThan(@SqlType(value="timestamp(p)") long left, @SqlType(value="timestamp(p)") long right) {
            return left < right;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThan(@SqlType(value="timestamp(p)") LongTimestamp left, @SqlType(value="timestamp(p)") LongTimestamp right) {
            return left.getEpochMicros() < right.getEpochMicros() || left.getEpochMicros() == right.getEpochMicros() && left.getPicosOfMicro() < right.getPicosOfMicro();
        }
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    public static final class NotEqual {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean notEqual(@SqlType(value="timestamp(p)") long left, @SqlType(value="timestamp(p)") long right) {
            return left != right;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean notEqual(@SqlType(value="timestamp(p)") LongTimestamp left, @SqlType(value="timestamp(p)") LongTimestamp right) {
            return !left.equals((Object)right);
        }
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    public static final class Equal {
        @LiteralParameters(value={"p"})
        @SqlNullable
        @SqlType(value="boolean")
        public static Boolean equal(@SqlType(value="timestamp(p)") long left, @SqlType(value="timestamp(p)") long right) {
            return left == right;
        }

        @LiteralParameters(value={"p"})
        @SqlNullable
        @SqlType(value="boolean")
        public static Boolean equal(@SqlType(value="timestamp(p)") LongTimestamp left, @SqlType(value="timestamp(p)") LongTimestamp right) {
            return left.equals((Object)right);
        }
    }
}

