/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

@ScalarOperator(value=OperatorType.CAST)
@ScalarFunction(value="date")
public final class TimestampToDateCast {
    private TimestampToDateCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp) {
        if (precision > 3L) {
            timestamp = Timestamps.scaleEpochMicrosToMillis(timestamp);
        }
        if (session.isLegacyTimestamp()) {
            ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
            long date = chronology.dayOfYear().roundFloor(timestamp);
            long millis = date + (long)chronology.getZone().getOffset(date);
            return TimeUnit.MILLISECONDS.toDays(millis);
        }
        return TimeUnit.MILLISECONDS.toDays(timestamp);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long cast(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return TimestampToDateCast.cast(6L, session, timestamp.getEpochMicros());
    }
}

