/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimeOperators;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToTimeCast {
    private TimestampToTimeCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time")
    public static long cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long value) {
        if (precision > 3L) {
            value = Timestamps.scaleEpochMicrosToMillis(Timestamps.round(value, 3));
        }
        if (session.isLegacyTimestamp()) {
            ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
            long result = chronology.millisOfDay().get(value) - chronology.getZone().getOffset(value);
            return result -= DateTimeFunctions.valueToSessionTimeZoneOffsetDiff(value, DateTimeZoneIndex.getDateTimeZone(session.getTimeZoneKey()));
        }
        return DateTimeOperators.modulo24Hour(value);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time")
    public static long cast(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return TimestampToTimeCast.cast(6L, session, timestamp.getEpochMicros());
    }
}

