/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.DateTimeOperators;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToTimeWithTimezoneCast {
    private TimestampToTimeWithTimezoneCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time with time zone")
    public static long cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long value) {
        if (precision > 3L) {
            value = Timestamps.scaleEpochMicrosToMillis(Timestamps.round(value, 3));
        }
        if (session.isLegacyTimestamp()) {
            int timeMillis = DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), value);
            return DateTimeEncoding.packDateTimeWithZone((long)timeMillis, (TimeZoneKey)session.getTimeZoneKey());
        }
        ISOChronology localChronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        return DateTimeEncoding.packDateTimeWithZone((long)localChronology.getZone().convertLocalToUTC(DateTimeOperators.modulo24Hour(value), false), (TimeZoneKey)session.getTimeZoneKey());
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time with time zone")
    public static long cast(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return TimestampToTimeWithTimezoneCast.cast(6L, session, timestamp.getEpochMicros());
    }
}

