/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.StringFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.Timestamps;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.function.Function;
import java.util.regex.Matcher;

@ScalarOperator(value=OperatorType.CAST)
public final class VarcharToTimestampCast {
    private VarcharToTimestampCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static long castToShort(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="varchar(x)") Slice value) {
        if (session.isLegacyTimestamp()) {
            try {
                return VarcharToTimestampCast.castToLegacyShortTimestamp((int)precision, session.getTimeZoneKey(), StringFunctions.trim(value).toStringUtf8());
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
            }
        }
        try {
            return VarcharToTimestampCast.castToShortTimestamp((int)precision, StringFunctions.trim(value).toStringUtf8(), timezone -> ZoneOffset.UTC);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp castToLong(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="varchar(x)") Slice value) {
        if (session.isLegacyTimestamp()) {
            try {
                return VarcharToTimestampCast.castToLegacyLongTimestamp((int)precision, session.getTimeZoneKey(), StringFunctions.trim(value).toStringUtf8());
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
            }
        }
        try {
            return VarcharToTimestampCast.castToLongTimestamp((int)precision, StringFunctions.trim(value).toStringUtf8(), timezone -> ZoneOffset.UTC);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    public static long castToLegacyShortTimestamp(int precision, TimeZoneKey timeZoneKey, String value) {
        return VarcharToTimestampCast.castToShortTimestamp(precision, value, timezone -> {
            if (timezone == null) {
                return timeZoneKey.getZoneId();
            }
            return ZoneId.of(timezone);
        });
    }

    private static LongTimestamp castToLegacyLongTimestamp(int precision, TimeZoneKey timeZoneKey, String value) {
        return VarcharToTimestampCast.castToLongTimestamp(precision, value, timezone -> {
            if (timezone == null) {
                return timeZoneKey.getZoneId();
            }
            return ZoneId.of(timezone);
        });
    }

    private static long castToShortTimestamp(int precision, String value, Function<String, ZoneId> zoneId) {
        Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (Object)"precision must be less than max short timestamp precision");
        Matcher matcher = Timestamps.DATETIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid timestamp: " + value);
        }
        String year = matcher.group("year");
        String month = matcher.group("month");
        String day = matcher.group("day");
        String hour = matcher.group("hour");
        String minute = matcher.group("minute");
        String second = matcher.group("second");
        String fraction = matcher.group("fraction");
        String timezone = matcher.group("timezone");
        long epochSecond = ZonedDateTime.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), hour == null ? 0 : Integer.parseInt(hour), minute == null ? 0 : Integer.parseInt(minute), second == null ? 0 : Integer.parseInt(second), 0, zoneId.apply(timezone)).toEpochSecond();
        int actualPrecision = 0;
        long fractionValue = 0L;
        if (fraction != null) {
            actualPrecision = fraction.length();
            fractionValue = Long.parseLong(fraction);
        }
        if (actualPrecision > precision) {
            fractionValue = Timestamps.round(fractionValue, actualPrecision - precision);
        }
        if (precision <= 3) {
            return epochSecond * 1000L + Timestamps.rescale(fractionValue, actualPrecision, 3);
        }
        return epochSecond * 1000000L + Timestamps.rescale(fractionValue, actualPrecision, 6);
    }

    private static LongTimestamp castToLongTimestamp(int precision, String value, Function<String, ZoneId> zoneId) {
        Preconditions.checkArgument((precision > 6 && precision <= 12 ? 1 : 0) != 0, (Object)"precision out of range");
        Matcher matcher = Timestamps.DATETIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid timestamp: " + value);
        }
        String year = matcher.group("year");
        String month = matcher.group("month");
        String day = matcher.group("day");
        String hour = matcher.group("hour");
        String minute = matcher.group("minute");
        String second = matcher.group("second");
        String fraction = matcher.group("fraction");
        String timezone = matcher.group("timezone");
        long epochSecond = ZonedDateTime.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), hour == null ? 0 : Integer.parseInt(hour), minute == null ? 0 : Integer.parseInt(minute), second == null ? 0 : Integer.parseInt(second), 0, zoneId.apply(timezone)).toEpochSecond();
        int actualPrecision = 0;
        long fractionValue = 0L;
        if (fraction != null) {
            actualPrecision = fraction.length();
            fractionValue = Long.parseLong(fraction);
        }
        if (actualPrecision > precision) {
            fractionValue = Timestamps.round(fractionValue, actualPrecision - precision);
        }
        return Timestamps.longTimestamp(epochSecond, Timestamps.rescale(fractionValue, actualPrecision, 12));
    }
}

