/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.util.DateTimeZoneIndex;

@Description(value="Day of the month of the given timestamp")
@ScalarFunction(value="day", alias={"day_of_month"})
public class ExtractDay {
    private ExtractDay() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        return DateTimeZoneIndex.unpackChronology(packedEpochMillis).dayOfMonth().get(DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())).dayOfMonth().get(timestamp.getEpochMillis());
    }
}

