/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;

@Description(value="Formats the given time by the given format")
@ScalarFunction(value="format_datetime")
public class FormatDateTime {
    private FormatDateTime() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="varchar(x)") Slice formatString) {
        ISOChronology chronology = DateTimeZoneIndex.unpackChronology(packedEpochMillis);
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        return FormatDateTime.format(session, epochMillis, chronology, formatString);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        return FormatDateTime.format(session, Timestamps.roundToEpochMillis(timestamp), DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())), formatString);
    }

    private static Slice format(ConnectorSession session, long epochMillis, ISOChronology chronology, Slice formatString) {
        try {
            return Slices.utf8Slice((String)DateTimeFormat.forPattern((String)formatString.toStringUtf8()).withChronology((Chronology)chronology).withLocale(session.getLocale()).print(epochMillis));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }
}

