/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeWithTimeZoneToTimestampWithTimeZoneCast {
    private TimeWithTimeZoneToTimestampWithTimeZoneCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long castToShort(@SqlType(value="time with time zone") long time) {
        return time;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone castToLong(@SqlType(value="time with time zone") long time) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)DateTimeEncoding.unpackMillisUtc((long)time), (int)0, (TimeZoneKey)DateTimeEncoding.unpackZoneKey((long)time));
    }
}

