/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimezoneToTimestampCast {
    private TimestampWithTimezoneToTimestampCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long shortToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="timestamp(sourcePrecision) with time zone") long timestamp) {
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)timestamp);
        if (!session.isLegacyTimestamp()) {
            epochMillis = DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)timestamp)).getZone().convertUTCToLocal(epochMillis);
        }
        if (targetPrecision <= 3L) {
            return Timestamps.round(epochMillis, (int)(3L - targetPrecision));
        }
        return Timestamps.round(Timestamps.scaleEpochMillisToMicros(epochMillis), (int)(6L - targetPrecision));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        long epochMillis = timestamp.getEpochMillis();
        int picosOfMilli = timestamp.getPicosOfMilli();
        if (!session.isLegacyTimestamp()) {
            epochMillis = DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())).getZone().convertUTCToLocal(epochMillis);
        }
        if (targetPrecision < 3L) {
            return Timestamps.round(epochMillis, (int)(3L - targetPrecision));
        }
        if (targetPrecision == 3L) {
            if (Timestamps.roundToNearest(timestamp.getPicosOfMilli(), 1000000000L) == 1000000000L) {
                ++epochMillis;
            }
            return epochMillis;
        }
        long epochMicros = Timestamps.toEpochMicros(epochMillis, picosOfMilli);
        if (targetPrecision < 6L) {
            return Timestamps.round(epochMicros, (int)(6L - targetPrecision));
        }
        if (Timestamps.roundToNearest(timestamp.getPicosOfMilli(), 1000000000L) == 1000000000L) {
            ++epochMicros;
        }
        return epochMicros;
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp shortToLong(ConnectorSession session, @SqlType(value="timestamp(sourcePrecision) with time zone") long timestamp) {
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)timestamp);
        if (!session.isLegacyTimestamp()) {
            epochMillis = DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)timestamp)).getZone().convertUTCToLocal(epochMillis);
        }
        return new LongTimestamp(Timestamps.scaleEpochMillisToMicros(epochMillis), 0);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp longToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        int picosOfMicro;
        long epochMicros;
        long epochMillis = timestamp.getEpochMillis();
        if (!session.isLegacyTimestamp()) {
            epochMillis = DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())).getZone().convertUTCToLocal(epochMillis);
        }
        if (targetPrecision <= 3L) {
            epochMicros = Timestamps.scaleEpochMillisToMicros(Timestamps.round(epochMillis, (int)(3L - targetPrecision)));
            picosOfMicro = 0;
        } else if (targetPrecision <= 6L) {
            epochMicros = Timestamps.toEpochMicros(epochMillis, timestamp.getPicosOfMilli());
            epochMicros = Timestamps.round(epochMicros, (int)(6L - targetPrecision));
            picosOfMicro = 0;
        } else {
            int picosOfMilli = timestamp.getPicosOfMilli();
            epochMicros = Timestamps.toEpochMicros(epochMillis, picosOfMilli);
            picosOfMicro = (int)Timestamps.round(picosOfMilli % 1000000, (int)(12L - targetPrecision));
        }
        return new LongTimestamp(epochMicros, picosOfMicro);
    }
}

