/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.RankingWindowFunction;
import io.prestosql.spi.function.WindowFunctionSignature;
import io.prestosql.spi.type.BigintType;

@WindowFunctionSignature(name="rank", returnType="bigint")
public class RankFunction
extends RankingWindowFunction {
    private long rank;
    private long count;

    public void reset() {
        this.rank = 0L;
        this.count = 1L;
    }

    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount, int currentPosition) {
        if (newPeerGroup) {
            this.rank += this.count;
            this.count = 1L;
        } else {
            ++this.count;
        }
        BigintType.BIGINT.writeLong(output, this.rank);
    }
}

