/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.prestosql.Session;
import io.prestosql.server.SessionPropertyConfigurationManagerContextInstance;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.resourcegroups.SessionPropertyConfigurationManagerContext;
import io.prestosql.spi.session.SessionConfigurationContext;
import io.prestosql.spi.session.SessionPropertyConfigurationManager;
import io.prestosql.spi.session.SessionPropertyConfigurationManagerFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;

public class SessionPropertyDefaults {
    private static final Logger log = Logger.get(SessionPropertyDefaults.class);
    private static final File CONFIG_FILE = new File("etc/session-property-config.properties");
    private static final String NAME_PROPERTY = "session-property-config.configuration-manager";
    private final SessionPropertyConfigurationManagerContext configurationManagerContext;
    private final Map<String, SessionPropertyConfigurationManagerFactory> factories = new ConcurrentHashMap<String, SessionPropertyConfigurationManagerFactory>();
    private final AtomicReference<SessionPropertyConfigurationManager> delegate = new AtomicReference();

    @Inject
    public SessionPropertyDefaults(NodeInfo nodeInfo) {
        this.configurationManagerContext = new SessionPropertyConfigurationManagerContextInstance(nodeInfo.getEnvironment());
    }

    public void addConfigurationManagerFactory(SessionPropertyConfigurationManagerFactory sessionConfigFactory) {
        if (this.factories.putIfAbsent(sessionConfigFactory.getName(), sessionConfigFactory) != null) {
            throw new IllegalArgumentException(String.format("Session property configuration manager '%s' is already registered", sessionConfigFactory.getName()));
        }
    }

    public void loadConfigurationManager() throws IOException {
        File configFile = CONFIG_FILE.getAbsoluteFile();
        if (!configFile.exists()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>(ConfigurationLoader.loadPropertiesFrom((String)configFile.getPath()));
        String name = (String)properties.remove(NAME_PROPERTY);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Session property configuration %s does not contain '%s'", (Object)configFile, (Object)NAME_PROPERTY);
        this.setConfigurationManager(name, properties);
    }

    @VisibleForTesting
    public void setConfigurationManager(String name, Map<String, String> properties) {
        log.info("-- Loading session property configuration manager --");
        SessionPropertyConfigurationManagerFactory factory = this.factories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Session property configuration manager '%s' is not registered", (Object)name);
        SessionPropertyConfigurationManager manager = factory.create(properties, this.configurationManagerContext);
        Preconditions.checkState((boolean)this.delegate.compareAndSet(null, manager), (Object)"sessionPropertyConfigurationManager is already set");
        log.info("-- Loaded session property configuration manager %s --", new Object[]{name});
    }

    public Session newSessionWithDefaultProperties(Session session, Optional<String> queryType, ResourceGroupId resourceGroupId) {
        SessionPropertyConfigurationManager configurationManager = this.delegate.get();
        if (configurationManager == null) {
            return session;
        }
        SessionConfigurationContext context = new SessionConfigurationContext(session.getIdentity().getUser(), session.getSource(), session.getClientTags(), queryType, resourceGroupId);
        Map systemPropertyOverrides = configurationManager.getSystemSessionProperties(context);
        Map catalogPropertyOverrides = configurationManager.getCatalogSessionProperties(context);
        return session.withDefaultProperties(systemPropertyOverrides, catalogPropertyOverrides);
    }
}

