/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.base.Strings;
import io.prestosql.server.security.AuthenticationException;
import io.prestosql.server.security.Authenticator;
import io.prestosql.server.security.BasicAuthCredentials;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.spi.security.Identity;
import java.security.Principal;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;

public class InsecureAuthenticator
implements Authenticator {
    @Override
    public Identity authenticate(ContainerRequestContext request) throws AuthenticationException {
        String user;
        Optional<BasicAuthCredentials> basicAuthCredentials = BasicAuthCredentials.extractBasicAuthCredentials(request);
        if (basicAuthCredentials.isPresent()) {
            if (basicAuthCredentials.get().getPassword().isPresent()) {
                throw new AuthenticationException("Password not allowed for insecure authentication", "Basic realm=\"Presto\"");
            }
            user = basicAuthCredentials.get().getUser();
        } else {
            user = Strings.emptyToNull((String)((String)request.getHeaders().getFirst((Object)"X-Presto-User")));
        }
        if (user == null) {
            throw new AuthenticationException("Basic authentication or X-Presto-User must be sent", "Basic realm=\"Presto\"");
        }
        return Identity.forUser((String)user).withPrincipal((Principal)new BasicPrincipal(user)).build();
    }
}

