/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.split;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.split.BufferingSplitSource;
import io.prestosql.split.ConnectorAwareSplitSource;
import io.prestosql.split.SplitSource;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.inject.Inject;

public class SplitManager {
    private final ConcurrentMap<CatalogName, ConnectorSplitManager> splitManagers = new ConcurrentHashMap<CatalogName, ConnectorSplitManager>();
    private final int minScheduleSplitBatchSize;
    private final Metadata metadata;

    @Inject
    public SplitManager(QueryManagerConfig config, Metadata metadata) {
        this.minScheduleSplitBatchSize = config.getMinScheduleSplitBatchSize();
        this.metadata = metadata;
    }

    public void addConnectorSplitManager(CatalogName catalogName, ConnectorSplitManager connectorSplitManager) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(connectorSplitManager, "connectorSplitManager is null");
        Preconditions.checkState((this.splitManagers.putIfAbsent(catalogName, connectorSplitManager) == null ? 1 : 0) != 0, (String)"SplitManager for connector '%s' is already registered", (Object)catalogName);
    }

    public void removeConnectorSplitManager(CatalogName catalogName) {
        this.splitManagers.remove(catalogName);
    }

    public SplitSource getSplits(Session session, TableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, Supplier<TupleDomain<ColumnHandle>> dynamicFilter) {
        ConnectorSplitSource source;
        CatalogName catalogName = table.getCatalogName();
        ConnectorSplitManager splitManager = this.getConnectorSplitManager(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        if (this.metadata.usesLegacyTableLayouts(session, table)) {
            ConnectorTableLayoutHandle layout = table.getLayout().orElseGet(() -> this.metadata.getLayout(session, table, Constraint.alwaysTrue(), Optional.empty()).get().getNewTableHandle().getLayout().get());
            source = splitManager.getSplits(table.getTransaction(), connectorSession, layout, splitSchedulingStrategy);
        } else {
            source = splitManager.getSplits(table.getTransaction(), connectorSession, table.getConnectorHandle(), splitSchedulingStrategy, dynamicFilter);
        }
        SplitSource splitSource = new ConnectorAwareSplitSource(catalogName, source);
        int minScheduleSplitBatchSize = this.minScheduleSplitBatchSize;
        if (splitSource.getMinScheduleSplitBatchSize().isPresent()) {
            minScheduleSplitBatchSize = Math.min(minScheduleSplitBatchSize, splitSource.getMinScheduleSplitBatchSize().get());
        }
        if (minScheduleSplitBatchSize > 1) {
            splitSource = new BufferingSplitSource(splitSource, minScheduleSplitBatchSize);
        }
        return splitSource;
    }

    private ConnectorSplitManager getConnectorSplitManager(CatalogName catalogName) {
        ConnectorSplitManager result = (ConnectorSplitManager)this.splitManagers.get(catalogName);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No split manager for connector '%s'", (Object)catalogName);
        return result;
    }
}

