/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DynamicFilters {
    private DynamicFilters() {
    }

    public static Expression createDynamicFilterExpression(Metadata metadata, DynamicFilterId id, Type inputType, SymbolReference input) {
        return DynamicFilters.createDynamicFilterExpression(metadata, id, inputType, (Expression)input);
    }

    @VisibleForTesting
    public static Expression createDynamicFilterExpression(Metadata metadata, DynamicFilterId id, Type inputType, Expression input) {
        return new FunctionCallBuilder(metadata).setName(QualifiedName.of((String)"$internal$dynamic_filter_function")).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral(id.toString())).addArgument(inputType, input).build();
    }

    public static ExtractResult extractDynamicFilters(Expression expression) {
        List<Expression> conjuncts = ExpressionUtils.extractConjuncts(expression);
        ImmutableList.Builder staticConjuncts = ImmutableList.builder();
        ImmutableList.Builder dynamicConjuncts = ImmutableList.builder();
        for (Expression conjunct : conjuncts) {
            Optional<Descriptor> descriptor = DynamicFilters.getDescriptor(conjunct);
            if (descriptor.isPresent()) {
                dynamicConjuncts.add((Object)descriptor.get());
                continue;
            }
            staticConjuncts.add((Object)conjunct);
        }
        return new ExtractResult((List<Expression>)staticConjuncts.build(), (List<Descriptor>)dynamicConjuncts.build());
    }

    public static boolean isDynamicFilter(Expression expression) {
        return DynamicFilters.getDescriptor(expression).isPresent();
    }

    public static Optional<Descriptor> getDescriptor(Expression expression) {
        if (!(expression instanceof FunctionCall)) {
            return Optional.empty();
        }
        FunctionCall functionCall = (FunctionCall)expression;
        boolean isDynamicFilterFunction = ResolvedFunction.fromQualifiedName(functionCall.getName()).map(ResolvedFunction::getSignature).map(Signature::getName).map("$internal$dynamic_filter_function"::equals).orElse(false);
        if (!isDynamicFilterFunction) {
            return Optional.empty();
        }
        List arguments = functionCall.getArguments();
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (String)"invalid arguments count: %s", (int)arguments.size());
        Expression firstArgument = (Expression)arguments.get(0);
        Preconditions.checkArgument((boolean)(firstArgument instanceof StringLiteral), (String)"firstArgument is expected to be an instance of StringLiteral: %s", (Object)firstArgument.getClass().getSimpleName());
        String id = ((StringLiteral)firstArgument).getValue();
        return Optional.of(new Descriptor(new DynamicFilterId(id), (Expression)arguments.get(1)));
    }

    @ScalarFunction(value="$internal$dynamic_filter_function", hidden=true)
    public static final class Function {
        private static final String NAME = "$internal$dynamic_filter_function";

        private Function() {
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="varchar") Slice id, @SqlType(value="T") Object input) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="varchar") Slice id, @SqlType(value="T") long input) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="varchar") Slice id, @SqlType(value="T") boolean input) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="varchar") Slice id, @SqlType(value="T") double input) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Descriptor {
        private final DynamicFilterId id;
        private final Expression input;

        public Descriptor(DynamicFilterId id, Expression input) {
            this.id = Objects.requireNonNull(id, "id is null");
            this.input = Objects.requireNonNull(input, "input is null");
        }

        public DynamicFilterId getId() {
            return this.id;
        }

        public Expression getInput() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Descriptor that = (Descriptor)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.input, that.input);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.input);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("input", (Object)this.input).toString();
        }
    }

    public static class ExtractResult {
        private final List<Expression> staticConjuncts;
        private final List<Descriptor> dynamicConjuncts;

        public ExtractResult(List<Expression> staticConjuncts, List<Descriptor> dynamicConjuncts) {
            this.staticConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(staticConjuncts, "staticConjuncts is null"));
            this.dynamicConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(dynamicConjuncts, "dynamicConjuncts is null"));
        }

        public List<Expression> getStaticConjuncts() {
            return this.staticConjuncts;
        }

        public List<Descriptor> getDynamicConjuncts() {
            return this.dynamicConjuncts;
        }
    }
}

