/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.sql.gen.BytecodeUtils;
import io.prestosql.sql.gen.CachedInstanceBinder;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.RowExpressionCompiler;
import io.prestosql.sql.relational.RowExpression;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class BytecodeGeneratorContext {
    private final RowExpressionCompiler rowExpressionCompiler;
    private final Scope scope;
    private final CallSiteBinder callSiteBinder;
    private final CachedInstanceBinder cachedInstanceBinder;
    private final Metadata metadata;
    private final Variable wasNull;

    public BytecodeGeneratorContext(RowExpressionCompiler rowExpressionCompiler, Scope scope, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, Metadata metadata) {
        Objects.requireNonNull(rowExpressionCompiler, "bytecodeGenerator is null");
        Objects.requireNonNull(cachedInstanceBinder, "cachedInstanceBinder is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.rowExpressionCompiler = rowExpressionCompiler;
        this.scope = scope;
        this.callSiteBinder = callSiteBinder;
        this.cachedInstanceBinder = cachedInstanceBinder;
        this.metadata = metadata;
        this.wasNull = scope.getVariable("wasNull");
    }

    public Scope getScope() {
        return this.scope;
    }

    public CallSiteBinder getCallSiteBinder() {
        return this.callSiteBinder;
    }

    public BytecodeNode generate(RowExpression expression) {
        return this.rowExpressionCompiler.compile(expression, this.scope);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public BytecodeNode generateCall(ResolvedFunction resolvedFunction, List<BytecodeNode> arguments) {
        return BytecodeUtils.generateInvocation(this.scope, resolvedFunction, this.metadata, arguments, this.callSiteBinder);
    }

    public BytecodeNode generateFullCall(ResolvedFunction resolvedFunction, List<RowExpression> arguments) {
        List argumentCompilers = (List)arguments.stream().map(this::argumentCompiler).collect(ImmutableList.toImmutableList());
        Function<MethodHandle, BytecodeNode> instance = instanceFactory -> this.scope.getThis().getField(this.cachedInstanceBinder.getCachedInstance((MethodHandle)instanceFactory));
        return BytecodeUtils.generateFullInvocation(this.scope, resolvedFunction, this.metadata, instance, argumentCompilers, this.callSiteBinder);
    }

    private Function<Optional<Class<?>>, BytecodeNode> argumentCompiler(RowExpression argument) {
        return lambdaInterface -> this.rowExpressionCompiler.compile(argument, this.scope, (Optional<Class<?>>)lambdaInterface);
    }

    public Variable wasNull() {
        return this.wasNull;
    }
}

