/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.tree.AtTimeZone;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Map;
import java.util.Objects;

public final class DesugarAtTimeZoneRewriter {
    public static Expression rewrite(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes, Metadata metadata) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(expressionTypes, metadata), (Expression)expression);
    }

    private DesugarAtTimeZoneRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, SymbolAllocator symbolAllocator) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        return DesugarAtTimeZoneRewriter.rewrite(expression, expressionTypes, metadata);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> expressionTypes;
        private final Metadata metadata;

        public Visitor(Map<NodeRef<Expression>, Type> expressionTypes, Metadata metadata) {
            this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
            this.metadata = metadata;
        }

        public Expression rewriteAtTimeZone(AtTimeZone node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Type valueType = this.getType(node.getValue());
            Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
            if (valueType.equals(TimeType.TIME)) {
                valueType = TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
                value = new Cast(value, TypeSignatureTranslator.toSqlType(valueType));
            } else if (valueType instanceof TimestampType) {
                valueType = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
                value = new Cast(value, TypeSignatureTranslator.toSqlType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE));
            }
            Type timeZoneType = this.getType(node.getTimeZone());
            Expression timeZone = treeRewriter.rewrite(node.getTimeZone(), (Object)context);
            return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"at_timezone")).addArgument(valueType, value).addArgument(timeZoneType, timeZone).build();
        }

        private Type getType(Expression expression) {
            return this.expressionTypes.get(NodeRef.of((Node)expression));
        }
    }
}

